/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.PasswordChangeDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ProjectAccessDialog;
import ghidra.framework.main.ProjectDataPanel;
import ghidra.framework.main.ProjectInfoDialog;
import ghidra.framework.main.RepositoryChooser;
import ghidra.framework.main.ViewInfo;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.Workspace;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.remote.User;
import ghidra.util.HashUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ProjectActionManager {
    private static final String CLOSE_ALL_OPEN_VIEWS = "Close All Read-Only Views";
    private static final String LAST_VIEWED_PROJECT_DIRECTORY = "LastViewedProjectDirectory";
    private static final String LAST_VIEWED_REPOSITORY_URL = "LastViewedRepositoryURL";
    private FrontEndTool tool;
    private FrontEndPlugin plugin;
    private List<ViewInfo> openViewsList;
    private List<ViewInfo> reopenViewsList;
    private Project activeProject;
    private GhidraFileChooser fileChooser;
    private RepositoryChooser repositoryChooser;
    private DockingAction openProjectViewAction;
    private DockingAction openRepositoryViewAction;
    private DockingAction addWSAction;
    private DockingAction removeWSAction;
    private DockingAction renameWSAction;
    private DockingAction switchWSAction;
    private DockingAction editAccessAction;
    private DockingAction viewAccessAction;
    private DockingAction setPasswordAction;
    private DockingAction viewInfoAction;
    private ProjectInfoDialog infoDialog;

    ProjectActionManager(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = plugin.getFrontEndTool();
        this.openViewsList = new ArrayList<ViewInfo>();
        this.reopenViewsList = new ArrayList<ViewInfo>();
        this.createActions();
        this.createSwitchWorkspaceAction();
    }

    private void openRecentView(String urlPath) {
        URL url = GhidraURL.toURL(urlPath);
        this.openView(url);
    }

    private void createActions() {
        String owner = this.plugin.getName();
        this.openProjectViewAction = new DockingAction("View Project", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.openProjectView();
            }
        };
        this.openProjectViewAction.setEnabled(false);
        this.openProjectViewAction.setMenuBarData(new MenuData(new String[]{"&Project", "View Project..."}, "AView"));
        this.openProjectViewAction.getMenuBarData().setMenuSubGroup("1");
        this.tool.addAction((DockingActionIf)this.openProjectViewAction);
        this.openRepositoryViewAction = new DockingAction("View Repository", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.openRepositoryView();
            }
        };
        this.openRepositoryViewAction.setEnabled(false);
        this.openRepositoryViewAction.setMenuBarData(new MenuData(new String[]{"&Project", "View Repository..."}, "AView"));
        this.openRepositoryViewAction.getMenuBarData().setMenuSubGroup("2");
        this.tool.addAction((DockingActionIf)this.openRepositoryViewAction);
        this.addWSAction = new DockingAction("Add Workspace", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.plugin.getWorkspacePanel().addWorkspace();
            }
        };
        this.addWSAction.setEnabled(false);
        this.addWSAction.setMenuBarData(new MenuData(new String[]{"&Project", "Workspace", "Add..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.addWSAction);
        this.renameWSAction = new DockingAction("Rename Workspace", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.plugin.getWorkspacePanel().renameWorkspace();
            }
        };
        this.renameWSAction.setEnabled(false);
        this.renameWSAction.setMenuBarData(new MenuData(new String[]{"&Project", "Workspace", "Rename..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.renameWSAction);
        this.removeWSAction = new DockingAction("Delete Workspace", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.plugin.getWorkspacePanel().removeWorkspace();
            }
        };
        this.removeWSAction.setEnabled(false);
        this.removeWSAction.setMenuBarData(new MenuData(new String[]{"&Project", "Workspace", "Delete..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.removeWSAction);
        this.tool.setMenuGroup(new String[]{"&Project", "Workspace"}, "zProject");
        this.editAccessAction = new DockingAction("Edit Project Access List", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.editProjectAccess();
            }
        };
        this.editAccessAction.setMenuBarData(new MenuData(new String[]{"Project", "Edit Project Access List..."}, "zzProject"));
        this.viewAccessAction = new DockingAction("View Project Access List", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.viewProjectAccess();
            }
        };
        this.viewAccessAction.setMenuBarData(new MenuData(new String[]{"Project", "View Project Access List..."}, "zzProject"));
        this.setPasswordAction = new DockingAction("Change Password", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.changePassword();
            }
        };
        this.setPasswordAction.setMenuBarData(new MenuData(new String[]{"Project", "Change Password..."}, "zzProject"));
        this.viewInfoAction = new DockingAction("View Project Info", owner){

            public void actionPerformed(ActionContext context) {
                ProjectActionManager.this.showProjectInfo();
            }
        };
        this.viewInfoAction.setEnabled(false);
        this.viewInfoAction.setMenuBarData(new MenuData(new String[]{"Project", "View Project Info..."}, "zzzProject"));
        this.tool.addAction((DockingActionIf)this.viewInfoAction);
    }

    private void createSwitchWorkspaceAction() {
        String owner = this.plugin.getName();
        this.switchWSAction = new DockingAction("Switch Workspace", owner){

            public void actionPerformed(ActionContext context) {
                ToolManager toolManager = ProjectActionManager.this.activeProject.getToolManager();
                Workspace[] workspaces = toolManager.getWorkspaces();
                if (workspaces.length <= 1) {
                    Msg.info((Object)"FrontEnd", (Object)"Unable to switch workspace, only 1 exists.");
                    return;
                }
                Workspace activeWorkspace = ProjectActionManager.this.plugin.getWorkspacePanel().getActiveWorkspace();
                int index = 0;
                for (Workspace workspace : workspaces) {
                    ++index;
                    if (workspace.equals(activeWorkspace)) break;
                }
                if (index >= workspaces.length) {
                    index = 0;
                }
                ProjectActionManager.this.plugin.getWorkspacePanel().setActiveWorkspace(workspaces[index]);
            }
        };
        this.switchWSAction.setEnabled(false);
        this.switchWSAction.setMenuBarData(new MenuData(new String[]{"&Project", "Workspace", "Switch..."}, "zProject"));
        this.tool.addAction((DockingActionIf)this.switchWSAction);
    }

    private void buildCloseViewsActions() {
        DockingAction action;
        ProjectLocator[] projectViews;
        for (ViewInfo info : this.openViewsList) {
            this.tool.removeAction((DockingActionIf)info.getAction());
        }
        this.openViewsList.clear();
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        if (pdp == null) {
            return;
        }
        this.tool.setMenuGroup(new String[]{"&Project", "Close View"}, "AView", "4");
        for (ProjectLocator view : projectViews = pdp.getProjectViews()) {
            CloseViewPluginAction action2 = new CloseViewPluginAction(GhidraURL.getDisplayString(view.getURL()));
            this.openViewsList.add(new ViewInfo(action2, view.getURL()));
            this.tool.addAction((DockingActionIf)action2);
        }
        if (projectViews.length > 1) {
            action = new DockingAction(CLOSE_ALL_OPEN_VIEWS, this.plugin.getName(), false){

                public void actionPerformed(ActionContext context) {
                    ProjectActionManager.this.closeView(ProjectActionManager.CLOSE_ALL_OPEN_VIEWS);
                }
            };
            action.setMenuBarData(new MenuData(new String[]{"&Project", "Close View", CLOSE_ALL_OPEN_VIEWS}, "AView"));
            this.openViewsList.add(new ViewInfo(action, null));
            this.tool.addAction((DockingActionIf)action);
        } else if (projectViews.length == 0) {
            action = new DockingAction("Close View", this.plugin.getName()){

                public void actionPerformed(ActionContext context) {
                }
            };
            action.setEnabled(false);
            action.setMenuBarData(new MenuData(new String[]{"&Project", "Close View"}, "AView"));
            action.getMenuBarData().setMenuSubGroup("4");
            this.openViewsList.add(new ViewInfo(action, null));
            this.tool.addAction((DockingActionIf)action);
        }
    }

    void buildRecentViewsActions() {
        for (ViewInfo viewInfo : this.reopenViewsList) {
            this.tool.removeAction((DockingActionIf)viewInfo.getAction());
        }
        this.reopenViewsList.clear();
        if (this.activeProject == null) {
            return;
        }
        URL[] recentViews = this.plugin.getRecentViewedProjects();
        this.tool.setMenuGroup(new String[]{"&Project", "View Recent"}, "AView", "3");
        for (URL projectView : recentViews) {
            String urlPath = GhidraURL.getDisplayString(projectView);
            RecentViewPluginAction action = new RecentViewPluginAction(urlPath);
            this.reopenViewsList.add(new ViewInfo(action, projectView));
            this.tool.addAction((DockingActionIf)action);
        }
        if (this.reopenViewsList.size() == 0) {
            DockingAction dockingAction = new DockingAction("View Recent", this.plugin.getName(), false){

                public void actionPerformed(ActionContext context) {
                }
            };
            dockingAction.setEnabled(false);
            dockingAction.setMenuBarData(new MenuData(new String[]{"&Project", "View Recent"}, "AView"));
            dockingAction.getMenuBarData().setMenuSubGroup("3");
            this.reopenViewsList.add(new ViewInfo(dockingAction, null));
            this.tool.addAction((DockingActionIf)dockingAction);
        }
    }

    void showProjectInfo() {
        if (this.infoDialog != null && !this.infoDialog.isVisible()) {
            this.infoDialog = null;
        }
        if (this.infoDialog == null) {
            this.infoDialog = new ProjectInfoDialog(this.plugin);
            this.tool.showDialog((DialogComponentProvider)this.infoDialog, (ComponentProvider)null);
        } else {
            this.infoDialog.toFront();
        }
    }

    void enableActions(boolean enabled) {
        this.openProjectViewAction.setEnabled(enabled);
        this.openRepositoryViewAction.setEnabled(enabled);
        this.addWSAction.setEnabled(enabled);
        this.removeWSAction.setEnabled(enabled);
        this.renameWSAction.setEnabled(enabled);
        this.switchWSAction.setEnabled(enabled);
        this.viewInfoAction.setEnabled(enabled);
    }

    void setActiveProject(Project activeProject) {
        RepositoryAdapter repository;
        if (this.infoDialog != null) {
            this.infoDialog.close();
            this.infoDialog = null;
        }
        this.tool.removeAction((DockingActionIf)this.viewAccessAction);
        this.tool.removeAction((DockingActionIf)this.editAccessAction);
        this.tool.removeAction((DockingActionIf)this.setPasswordAction);
        this.viewAccessAction.setEnabled(false);
        this.editAccessAction.setEnabled(false);
        this.setPasswordAction.setEnabled(false);
        this.activeProject = activeProject;
        this.plugin.rebuildRecentMenus();
        this.buildCloseViewsActions();
        this.enableActions(activeProject != null);
        if (activeProject != null && (repository = activeProject.getRepository()) != null) {
            this.connectionStateChanged(repository);
        }
    }

    void connectionStateChanged(RepositoryAdapter repository) {
        this.setPasswordAction.setEnabled(false);
        this.editAccessAction.setEnabled(false);
        this.viewAccessAction.setEnabled(false);
        this.tool.removeAction((DockingActionIf)this.setPasswordAction);
        this.tool.removeAction((DockingActionIf)this.editAccessAction);
        this.tool.removeAction((DockingActionIf)this.viewAccessAction);
        if (repository.isConnected()) {
            if (repository.getServer().canSetPassword()) {
                this.tool.addAction((DockingActionIf)this.setPasswordAction);
                this.setPasswordAction.setEnabled(true);
            }
            if (this.isUserAdmin(repository)) {
                this.tool.addAction((DockingActionIf)this.editAccessAction);
                this.editAccessAction.setEnabled(true);
            } else if (!this.isAnonymousUserOrNotConnected(repository)) {
                this.tool.addAction((DockingActionIf)this.viewAccessAction);
                this.viewAccessAction.setEnabled(true);
            }
        }
        if (this.infoDialog != null && this.infoDialog.isVisible()) {
            this.infoDialog.updateConnectionStatus();
        }
    }

    void setViewsVisible(boolean visible) {
        this.buildCloseViewsActions();
    }

    private boolean isUserAdmin(RepositoryAdapter rep) {
        try {
            User user = rep.getUser();
            return user.isAdmin();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean isAnonymousUserOrNotConnected(RepositoryAdapter rep) {
        try {
            User user = rep.getUser();
            if ("-anonymous-".equals(user.getName())) {
                return true;
            }
            for (User u : rep.getUserList()) {
                if (!u.equals((Object)user)) continue;
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private void closeAllViews() {
        ProjectLocator[] openViews;
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        for (ProjectLocator openView : openViews = pdp.getProjectViews()) {
            URL view = openView.getURL();
            pdp.closeView(view);
        }
        this.buildCloseViewsActions();
    }

    private void closeView(String urlPath) {
        if (urlPath.equals(CLOSE_ALL_OPEN_VIEWS)) {
            this.closeAllViews();
            return;
        }
        URL url = GhidraURL.toURL(urlPath);
        this.closeView(url);
    }

    void closeView(URL view) {
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        pdp.closeView(view);
        this.buildCloseViewsActions();
    }

    void viewClosed() {
        this.buildCloseViewsActions();
    }

    private void openProjectView() {
        ProjectLocator projectView;
        if (this.fileChooser == null) {
            this.fileChooser = this.plugin.createFileChooser(LAST_VIEWED_PROJECT_DIRECTORY);
        }
        if ((projectView = this.plugin.chooseProject(this.fileChooser, "Select", LAST_VIEWED_PROJECT_DIRECTORY)) != null) {
            this.openView(projectView.getURL());
        }
    }

    private void openRepositoryView() {
        URL repositoryURL;
        if (this.repositoryChooser == null) {
            this.repositoryChooser = new RepositoryChooser("View Server Repository");
            this.repositoryChooser.setHelpLocation(new HelpLocation("FrontEndPlugin", "View_Repository"));
        }
        String urlStr = Preferences.getProperty((String)LAST_VIEWED_REPOSITORY_URL);
        URL lastURL = null;
        if (urlStr != null) {
            try {
                lastURL = new URL(urlStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((repositoryURL = this.repositoryChooser.getSelectedRepository(this.tool, lastURL)) != null) {
            this.openView(repositoryURL);
            Preferences.setProperty((String)LAST_VIEWED_REPOSITORY_URL, (String)repositoryURL.toExternalForm());
            Preferences.store();
        }
    }

    private void openView(URL view) {
        if (this.activeProject != null && this.activeProject.getProjectLocator().getURL().equals(view)) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Error Opening as Read-Only", (Object)"Cannot open active project as Read-Only view!");
            return;
        }
        ProjectDataPanel pdp = this.plugin.getProjectDataPanel();
        pdp.openView(view);
        this.plugin.rebuildRecentMenus();
    }

    private void editProjectAccess() {
        RepositoryAdapter repository = this.activeProject.getRepository();
        try {
            ProjectAccessDialog dialog = new ProjectAccessDialog(this.plugin, repository, repository.getServerUserList(), true);
            this.tool.showDialog(dialog);
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"Edit Project Access List", (Component)this.tool.getToolFrame());
        }
    }

    private void viewProjectAccess() {
        RepositoryAdapter repository = this.activeProject.getRepository();
        try {
            ProjectAccessDialog dialog = new ProjectAccessDialog(this.plugin, repository, repository.getServerUserList(), false);
            this.tool.showDialog(dialog);
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"View Project Access List", (Component)this.tool.getToolFrame());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePassword() {
        block13: {
            PasswordChangeDialog dlg;
            block12: {
                RepositoryAdapter repository = this.activeProject.getRepository();
                if (repository == null) {
                    return;
                }
                dlg = null;
                char[] pwd = null;
                try {
                    repository.connect();
                    ServerInfo info = repository.getServerInfo();
                    if (1 != OptionDialog.showOptionDialog((Component)this.tool.getToolFrame(), (String)"Confirm Password Change", (String)("You are about to change your repository server password for:\n" + info + "\n \nThis password is used when connecting to project\nrepositories associated with this server"), (String)"Continue", (int)2)) {
                        return;
                    }
                    dlg = new PasswordChangeDialog("Change Password", "Repository Server", repository.getServerInfo().getServerName(), repository.getServer().getUser());
                    this.tool.showDialog((DialogComponentProvider)dlg);
                    pwd = dlg.getPassword();
                    if (pwd != null) {
                        repository.getServer().setPassword(HashUtilities.getSaltedHash((String)HashUtilities.SHA256_ALGORITHM, (char[])pwd));
                        Msg.showInfo(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Password Changed", (Object)"Password was changed successfully");
                    }
                    if (pwd == null) break block12;
                }
                catch (IOException e) {
                    ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"Password Change", (Component)this.tool.getToolFrame());
                    break block13;
                }
                finally {
                    if (pwd != null) {
                        Arrays.fill(pwd, ' ');
                    }
                    if (dlg != null) {
                        dlg.dispose();
                    }
                }
                Arrays.fill(pwd, ' ');
            }
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    private class CloseViewPluginAction
    extends DockingAction {
        private final String urlPath;

        private CloseViewPluginAction(String urlPath) {
            super("Close View " + urlPath, ProjectActionManager.this.plugin.getName(), false);
            this.urlPath = urlPath;
            this.setMenuBarData(new MenuData(new String[]{"&Project", "Close View", urlPath}, "AView"));
            this.setHelpLocation(new HelpLocation(ProjectActionManager.this.plugin.getName(), "Close_View"));
        }

        public void actionPerformed(ActionContext context) {
            ProjectActionManager.this.closeView(this.urlPath);
        }
    }

    private class RecentViewPluginAction
    extends DockingAction {
        private final String urlPath;

        private RecentViewPluginAction(String urlPath) {
            super("View " + urlPath, ProjectActionManager.this.plugin.getName(), false);
            this.urlPath = urlPath;
            this.setMenuBarData(new MenuData(new String[]{"&Project", "View Recent", urlPath}, "AView"));
            this.setHelpLocation(new HelpLocation(ProjectActionManager.this.plugin.getName(), "View_Recent"));
        }

        public void actionPerformed(ActionContext context) {
            ProjectActionManager.this.openRecentView(this.urlPath);
        }
    }
}

