/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.DockingUtils;
import docking.util.AnimationUtils;
import docking.util.SwingAnimationCallback;
import docking.widgets.EventTrigger;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.listener.FieldLocationListener;
import docking.widgets.fieldpanel.listener.FieldMouseListener;
import docking.widgets.fieldpanel.listener.FieldSelectionListener;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.FieldSelectionHelper;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.HoverProvider;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.indexedscrollpane.IndexedScrollPane;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.ClangHighlightListener;
import ghidra.app.decompiler.component.ClangLayoutController;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerHoverProvider;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.EmptyDecompileData;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.decompile.DecompilerClipboardProvider;
import ghidra.app.plugin.core.decompile.actions.FieldBasedSearchLocation;
import ghidra.app.plugin.core.decompile.actions.TokenHighlightColorProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.NumericUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.UndefinedFunction;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import util.CollectionUtils;

public class DecompilerPanel
extends JPanel
implements FieldMouseListener,
FieldLocationListener,
FieldSelectionListener,
ClangHighlightListener {
    private static final Color NON_FUNCTION_BACKGROUND_COLOR_DEF = new Color(220, 220, 220);
    private static final Color SPECIAL_COLOR_DEF = new Color(255, 100, 0, 128);
    private final DecompilerController controller;
    private final DecompileOptions options;
    private DecompilerFieldPanel fieldPanel;
    private ClangLayoutController layoutMgr;
    private HighlightFactory hlFactory;
    private ClangHighlightController highlightController;
    private PendingHighlightUpdate pendingHighlightUpdate;
    private SwingUpdateManager highlighCursorUpdater = new SwingUpdateManager(() -> {
        if (this.pendingHighlightUpdate != null) {
            this.pendingHighlightUpdate.doUpdate();
            this.pendingHighlightUpdate = null;
        }
    });
    private int middleMouseHighlightButton;
    private Color middleMouseHighlightColor;
    private Color currentVariableHighlightColor;
    private Color searchHighlightColor;
    private SearchLocation currentSearchLocation;
    private DecompileData decompileData = new EmptyDecompileData("No Function");
    private final DecompilerClipboardProvider clipboard;
    private Color originalBackgroundColor;
    private boolean useNonFunctionColor = false;
    private boolean navitationEnabled = true;
    private DecompilerHoverProvider decompilerHoverProvider;

    DecompilerPanel(DecompilerController controller, DecompileOptions options, DecompilerClipboardProvider clipboard, JComponent taskMonitorComponent) {
        this.controller = controller;
        this.options = options;
        this.clipboard = clipboard;
        FontMetrics metrics = this.getFontMetrics(options);
        if (clipboard != null) {
            clipboard.setFontMetrics(metrics);
        }
        this.hlFactory = new SearchHighlightFactory();
        this.layoutMgr = new ClangLayoutController(options, this, metrics, this.hlFactory);
        this.fieldPanel = new DecompilerFieldPanel(this.layoutMgr);
        this.setBackground(options.getCodeViewerBackgroundColor());
        IndexedScrollPane scroller = new IndexedScrollPane((JComponent)((Object)this.fieldPanel));
        this.fieldPanel.addFieldSelectionListener(this);
        this.fieldPanel.addFieldMouseListener(this);
        this.fieldPanel.addFieldLocationListener(this);
        this.decompilerHoverProvider = new DecompilerHoverProvider();
        this.searchHighlightColor = options.getSearchHighlightColor();
        this.currentVariableHighlightColor = options.getCurrentVariableHighlightColor();
        this.middleMouseHighlightColor = options.getMiddleMouseHighlightColor();
        this.middleMouseHighlightButton = options.getMiddleMouseHighlightButton();
        this.setLayout(new BorderLayout());
        this.add((Component)scroller);
        this.add((Component)taskMonitorComponent, "South");
        this.setPreferredSize(new Dimension(600, 400));
        this.setDecompileData(new EmptyDecompileData("No Function"));
    }

    public List<ClangLine> getLines() {
        return this.layoutMgr.getLines();
    }

    public List<Field> getFields() {
        return Arrays.asList(this.layoutMgr.getFields());
    }

    public FieldPanel getFieldPanel() {
        return this.fieldPanel;
    }

    public void applySecondaryHighlights(Map<String, Color> highlightsByName) {
        Set<Map.Entry<String, Color>> entries = highlightsByName.entrySet();
        for (Map.Entry<String, Color> entry : entries) {
            String tokenName = entry.getKey();
            Color color = entry.getValue();
            Supplier<List> lazyTokens = () -> this.findTokensByName(tokenName);
            this.highlightController.addSecondaryHighlights(lazyTokens, color);
        }
    }

    public TokenHighlightColors getSecondaryHighlightColors() {
        return this.highlightController.getSecondaryHighlightColors();
    }

    public TokenHighlights getSecondaryHighlightedTokens() {
        return this.highlightController.getSecondaryHighlightedTokens();
    }

    public void removeSecondaryHighlights() {
        Function function = this.controller.getFunction();
        this.highlightController.removeSecondaryHighlights(function);
    }

    public void removeSecondaryHighlight(ClangToken token) {
        this.removeSecondaryHighlight(token.getText());
    }

    private void removeSecondaryHighlight(String tokenText) {
        Supplier<List> lazyTokens = () -> this.findTokensByName(tokenText);
        this.highlightController.removeSecondaryHighlights(lazyTokens);
    }

    public void addSecondaryHighlight(ClangToken token) {
        String tokenText = token.getText();
        this.addSecondaryHighlight(tokenText);
    }

    private void addSecondaryHighlight(String tokenText) {
        Supplier<List> lazyTokens = () -> this.findTokensByName(tokenText);
        this.highlightController.addSecondaryHighlights(tokenText, lazyTokens);
    }

    public void addSecondaryHighlight(ClangToken token, Color color) {
        this.addSecondaryHighlight(token.getText(), color);
    }

    private void addSecondaryHighlight(String tokenText, Color color) {
        Supplier<List> lazyTokens = () -> this.findTokensByName(tokenText);
        this.highlightController.addSecondaryHighlights(lazyTokens, color);
    }

    private void togglePrimaryHighlight(FieldLocation location, Field field, Color highlightColor) {
        ClangToken token = ((ClangTextField)field).getToken(location);
        Supplier<List<ClangToken>> lazyTokens = () -> this.findTokensByName(token.getText());
        this.highlightController.togglePrimaryHighlights(this.middleMouseHighlightColor, lazyTokens);
    }

    @Override
    public void setBackground(Color bg) {
        this.originalBackgroundColor = bg;
        if (this.useNonFunctionColor) {
            bg = NON_FUNCTION_BACKGROUND_COLOR_DEF;
        }
        if (this.fieldPanel != null) {
            this.fieldPanel.setBackgroundColor(bg);
        }
        super.setBackground(bg);
    }

    void setDecompileData(DecompileData decompileData) {
        if (this.layoutMgr == null) {
            return;
        }
        DecompileData oldData = this.decompileData;
        this.decompileData = decompileData;
        Function function = decompileData.getFunction();
        if (decompileData.hasDecompileResults()) {
            this.layoutMgr.buildLayouts(function, decompileData.getCCodeMarkup(), null, true);
            if (decompileData.getDebugFile() != null) {
                this.controller.setStatusMessage("Debug file generated: " + decompileData.getDebugFile().getAbsolutePath());
            }
        } else {
            this.layoutMgr.buildLayouts(null, null, decompileData.getErrorMessage(), true);
        }
        this.setLocation(oldData, decompileData);
        this.decompilerHoverProvider.setProgram(decompileData.getProgram());
        this.useNonFunctionColor = function instanceof UndefinedFunction;
        this.setBackground(this.originalBackgroundColor);
        if (this.clipboard != null) {
            this.clipboard.selectionChanged(null);
        }
        this.currentSearchLocation = null;
        this.reapplySecondaryHighlights();
    }

    private void reapplySecondaryHighlights() {
        Function function = this.decompileData.getFunction();
        if (function == null) {
            return;
        }
        Set<HighlightToken> oldHighlights = this.highlightController.getSecondaryHighlightsByFunction(function);
        Map<String, List<ClangToken>> tokensByName = CollectionUtils.asStream((Iterable[])new Iterable[]{oldHighlights}).map(ht -> ht.getToken()).collect(Collectors.groupingBy(t -> t.getText()));
        Set<Map.Entry<String, List<ClangToken>>> entries = tokensByName.entrySet();
        for (Map.Entry<String, List<ClangToken>> entry : entries) {
            String name = entry.getKey();
            List<ClangToken> oldTokens = entry.getValue();
            this.highlightController.removeSecondaryHighlights(() -> oldTokens);
            this.addSecondaryHighlight(name);
        }
    }

    private void setLocation(DecompileData oldData, DecompileData newData) {
        Function function = oldData.getFunction();
        if (SystemUtilities.isEqual((Object)function, (Object)newData.getFunction())) {
            return;
        }
        ProgramLocation location = newData.getLocation();
        if (location != null) {
            this.setLocation(location, newData.getViewerPosition());
        }
    }

    public LayoutModel getLayoutModel() {
        return this.layoutMgr;
    }

    public boolean containsLocation(ProgramLocation location) {
        return this.decompileData.contains(location);
    }

    public void setLocation(ProgramLocation location, ViewerPosition viewerPosition) {
        this.repaint();
        if (location.getAddress() == null) {
            return;
        }
        if (viewerPosition != null) {
            this.fieldPanel.setViewerPosition(viewerPosition.getIndex(), viewerPosition.getXOffset(), viewerPosition.getYOffset());
        }
        if (location instanceof DecompilerLocation) {
            DecompilerLocation decompilerLocation = (DecompilerLocation)location;
            this.fieldPanel.goTo(BigInteger.valueOf(decompilerLocation.getLineNumber()), 0, 0, decompilerLocation.getCharPos(), false);
            return;
        }
        Address address = location.getAddress();
        if (this.goToFunctionSignature(address)) {
            return;
        }
        Address translated = this.translate(address);
        List<ClangToken> tokens = DecompilerUtils.getTokensFromView(this.layoutMgr.getFields(), translated);
        this.goToBeginningOfLine(tokens);
    }

    private boolean goToFunctionSignature(Address address) {
        if (!this.decompileData.hasDecompileResults()) {
            return false;
        }
        Address entry = this.decompileData.getFunction().getEntryPoint();
        if (!entry.equals((Object)address)) {
            return false;
        }
        ArrayList<ClangLine> lines = this.layoutMgr.getLines();
        ClangLine signatureLine = this.getFunctionSignatureLine(lines);
        if (signatureLine == null) {
            return false;
        }
        int lineNumber = signatureLine.getLineNumber() - 1;
        this.fieldPanel.goTo(BigInteger.valueOf(lineNumber), 0, 0, 0, false);
        return true;
    }

    private ClangLine getFunctionSignatureLine(List<ClangLine> functionLines) {
        for (ClangLine line : functionLines) {
            ArrayList<ClangToken> tokens = line.getAllTokens();
            for (ClangToken token : tokens) {
                if (!(token.Parent() instanceof ClangFuncProto)) continue;
                return line;
            }
        }
        return null;
    }

    private void goToBeginningOfLine(List<ClangToken> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        int firstLineNumber = DecompilerUtils.findIndexOfFirstField(tokens, this.layoutMgr.getFields());
        if (firstLineNumber != -1) {
            this.fieldPanel.goTo(BigInteger.valueOf(firstLineNumber), 0, 0, 0, false);
        }
    }

    private void goToToken(ClangToken token) {
        ClangToken lineToken;
        ClangLine line = token.getLineParent();
        int offset = 0;
        ArrayList<ClangToken> tokens = line.getAllTokens();
        Iterator iterator = tokens.iterator();
        while (iterator.hasNext() && !(lineToken = (ClangToken)iterator.next()).equals(token)) {
            offset += lineToken.getText().length();
        }
        int lineNumber = line.getLineNumber() - 1;
        int column = offset;
        FieldLocation start = this.getCursorPosition();
        int distance = this.getOffscreenDistance(lineNumber);
        if (distance == 0) {
            this.fieldPanel.navigateTo(lineNumber, column);
            return;
        }
        ScrollingCallback callback = new ScrollingCallback(start, lineNumber, column, distance);
        AnimationUtils.executeSwingAnimationCallback((SwingAnimationCallback)callback);
    }

    private int getOffscreenDistance(int line) {
        AnchoredLayout start = this.fieldPanel.getVisibleStartLayout();
        int visibleStartLine = start.getIndex().intValue();
        if (visibleStartLine > line) {
            return visibleStartLine - line;
        }
        AnchoredLayout end = this.fieldPanel.getVisibleEndLayout();
        int visibleEndLine = end.getIndex().intValue();
        if (visibleEndLine < line) {
            return line - visibleEndLine;
        }
        return 0;
    }

    private Address translate(Address addr) {
        Function func = this.decompileData.getFunction();
        if (func == null) {
            return addr;
        }
        AddressSpace funcSpace = func.getEntryPoint().getAddressSpace();
        if (funcSpace.isOverlaySpace() && addr.getAddressSpace().equals(funcSpace)) {
            return addr.getPhysicalAddress();
        }
        return addr;
    }

    private AddressSetView translateSet(AddressSetView set) {
        Function func = this.decompileData.getFunction();
        if (func == null) {
            return set;
        }
        AddressSpace funcSpace = func.getEntryPoint().getAddressSpace();
        if (!funcSpace.isOverlaySpace()) {
            return set;
        }
        AddressSet newSet = new AddressSet();
        AddressRangeIterator iter = set.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            Address min = range.getMinAddress();
            if (min.getAddressSpace().equals(funcSpace)) {
                Address max = range.getMaxAddress();
                range = new AddressRangeImpl(min.getPhysicalAddress(), max.getPhysicalAddress());
            }
            newSet.add(range);
        }
        return newSet;
    }

    void setSelection(ProgramSelection selection) {
        FieldSelection fieldSelection = null;
        if (selection == null || selection.isEmpty()) {
            fieldSelection = new FieldSelection();
        } else {
            List<ClangToken> tokens = DecompilerUtils.getTokens((ClangNode)this.layoutMgr.getRoot(), this.translateSet((AddressSetView)selection));
            fieldSelection = DecompilerUtils.getFieldSelection(tokens);
        }
        this.fieldPanel.setSelection(fieldSelection);
    }

    public void setDecompilerHoverProvider(DecompilerHoverProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the hover handler to null!");
        }
        if (this.decompilerHoverProvider != null) {
            if (this.decompilerHoverProvider.isShowing()) {
                this.decompilerHoverProvider.closeHover();
            }
            this.decompilerHoverProvider.initializeListingHoverHandler(provider);
            this.decompilerHoverProvider.dispose();
        }
        this.decompilerHoverProvider = provider;
    }

    public void dispose() {
        this.setDecompileData(new EmptyDecompileData("Disposed"));
        this.layoutMgr = null;
        this.decompilerHoverProvider.dispose();
        this.highlighCursorUpdater.dispose();
        this.highlightController.clearAllHighlights();
    }

    private FontMetrics getFontMetrics(DecompileOptions decompileOptions) {
        Font font = decompileOptions.getDefaultFont();
        return this.getFontMetrics(font);
    }

    void setMouseNavigationEnabled(boolean enabled) {
        this.navitationEnabled = enabled;
    }

    public void buttonPressed(FieldLocation location, Field field, MouseEvent ev) {
        if (!this.decompileData.hasDecompileResults()) {
            return;
        }
        int clickCount = ev.getClickCount();
        int buttonState = ev.getButton();
        if (buttonState == 1) {
            if (DockingUtils.isControlModifier((MouseEvent)ev) && clickCount == 2) {
                this.tryToGoto(location, field, ev, true);
            } else if (clickCount == 2) {
                this.tryToGoto(location, field, ev, false);
            } else if (DockingUtils.isControlModifier((MouseEvent)ev) && ev.isShiftDown()) {
                this.controller.exportLocation();
            }
        }
        if (buttonState == this.middleMouseHighlightButton && clickCount == 1) {
            this.togglePrimaryHighlight(location, field, this.middleMouseHighlightColor);
        }
    }

    private void tryToGoto(FieldLocation location, Field field, MouseEvent event, boolean newWindow) {
        if (!this.navitationEnabled) {
            return;
        }
        ClangTextField textField = (ClangTextField)field;
        ClangToken token = textField.getToken(location);
        if (token instanceof ClangFuncNameToken) {
            this.tryGoToFunction((ClangFuncNameToken)token, newWindow);
        } else if (token instanceof ClangLabelToken) {
            this.tryGoToLabel((ClangLabelToken)token, newWindow);
        } else if (token instanceof ClangVariableToken) {
            this.tryGoToVarnode((ClangVariableToken)token, newWindow);
        } else if (token instanceof ClangCommentToken) {
            this.tryGoToComment(location, event, textField, token, newWindow);
        } else if (token instanceof ClangSyntaxToken) {
            this.tryGoToSyntaxToken((ClangSyntaxToken)token);
        }
    }

    private void tryGoToComment(FieldLocation location, MouseEvent event, ClangTextField textField, ClangToken token, boolean newWindow) {
        FieldElement clickedElement = textField.getClickedObject(location);
        if (clickedElement instanceof AnnotatedTextFieldElement) {
            AnnotatedTextFieldElement annotation = (AnnotatedTextFieldElement)clickedElement;
            this.controller.annotationClicked(annotation, event, newWindow);
            return;
        }
        String text = clickedElement.getText();
        String word = StringUtilities.findWord((String)text, (int)location.col);
        this.tryGoToScalar(word, newWindow);
    }

    private void tryGoToFunction(ClangFuncNameToken functionToken, boolean newWindow) {
        Function function = DecompilerUtils.getFunction(this.controller.getProgram(), functionToken);
        if (function != null) {
            this.controller.goToFunction(function, newWindow);
            return;
        }
        String labelName = functionToken.getText();
        if (labelName.startsWith("func_0x")) {
            try {
                Address addr = this.decompileData.getFunction().getEntryPoint().getAddress(labelName.substring(7));
                this.controller.goToAddress(addr, newWindow);
            }
            catch (AddressFormatException e) {
                this.controller.goToLabel(labelName, newWindow);
            }
        }
    }

    private void tryGoToLabel(ClangLabelToken token, boolean newWindow) {
        ClangTokenGroup root;
        ClangLabelToken destination;
        ClangNode node = token.Parent();
        if (node instanceof ClangStatement && (destination = DecompilerUtils.getGoToTargetToken(root = this.layoutMgr.getRoot(), token)) != null) {
            this.goToToken(destination);
            return;
        }
        Address addr = token.getMinAddress();
        this.controller.goToAddress(addr, newWindow);
    }

    private void tryGoToSyntaxToken(ClangSyntaxToken token) {
        ClangSyntaxToken otherBrace;
        if (DecompilerUtils.isBrace(token) && (otherBrace = DecompilerUtils.getMatchingBrace(token)) != null) {
            this.goToToken(otherBrace);
        }
    }

    private void tryGoToVarnode(ClangVariableToken token, boolean newWindow) {
        HighVariable highVar;
        Varnode vn = token.getVarnode();
        if (vn == null) {
            PcodeOp op = token.getPcodeOp();
            if (op == null) {
                return;
            }
            int operation = op.getOpcode();
            if (operation != 66 && operation != 65) {
                return;
            }
            vn = op.getInput(1);
            if (vn == null) {
                return;
            }
        }
        if ((highVar = vn.getHigh()) instanceof HighGlobal) {
            vn = highVar.getRepresentative();
        }
        if (vn.isAddress()) {
            Address addr = vn.getAddress();
            if (addr.isMemoryAddress()) {
                this.controller.goToAddress(vn.getAddress(), newWindow);
            }
        } else if (vn.isConstant()) {
            this.controller.goToScalar(vn.getOffset(), newWindow);
        }
    }

    private void tryGoToScalar(String text, boolean newWindow) {
        if (text.startsWith("0x")) {
            text = text.substring(2);
        } else if (text.startsWith("(") && text.endsWith(")")) {
            int commaIx = text.indexOf(",0x");
            if (commaIx < 2) {
                return;
            }
            String spaceName = text.substring(1, commaIx);
            String offsetStr = text.substring(commaIx + 3, text.length() - 1);
            try {
                AddressSpace space = this.decompileData.getProgram().getAddressFactory().getAddressSpace(spaceName);
                if (space == null) {
                    return;
                }
                Address addr = space.getAddress(NumericUtilities.parseHexLong((String)offsetStr), true);
                this.controller.goToAddress(addr, newWindow);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            long value = NumericUtilities.parseHexLong((String)text);
            this.controller.goToScalar(value, newWindow);
        }
        catch (Exception e) {
            return;
        }
    }

    Program getProgram() {
        return this.decompileData.getProgram();
    }

    public ProgramLocation getCurrentLocation() {
        if (!this.decompileData.hasDecompileResults()) {
            return null;
        }
        Field currentField = this.fieldPanel.getCurrentField();
        FieldLocation cursorPosition = this.fieldPanel.getCursorLocation();
        return this.getProgramLocation(currentField, cursorPosition);
    }

    public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
        ProgramLocation programLocation;
        if (!this.decompileData.hasDecompileResults()) {
            return;
        }
        this.pendingHighlightUpdate = new PendingHighlightUpdate(location, field, trigger);
        this.highlighCursorUpdater.update();
        if (!(field instanceof ClangTextField)) {
            return;
        }
        ClangToken tok = ((ClangTextField)field).getToken(location);
        if (tok == null) {
            return;
        }
        if (trigger == EventTrigger.GUI_ACTION && (programLocation = this.getProgramLocation(field, location)) != null) {
            this.controller.locationChanged(programLocation);
        }
    }

    public void selectionChanged(FieldSelection selection, EventTrigger trigger) {
        if (this.clipboard != null) {
            this.clipboard.selectionChanged(selection);
        }
        if (!this.decompileData.hasDecompileResults()) {
            return;
        }
        if (trigger != EventTrigger.API_CALL) {
            Program program = this.decompileData.getProgram();
            Field[] lines = this.layoutMgr.getFields();
            List<ClangToken> tokenList = DecompilerUtils.getTokensInSelection(selection, lines);
            AddressSpace functionSpace = this.decompileData.getFunctionSpace();
            AddressSet addrset = DecompilerUtils.findClosestAddressSet(program, functionSpace, tokenList);
            ProgramSelection programSelection = new ProgramSelection((AddressSetView)addrset);
            this.controller.selectionChanged(programSelection);
        }
    }

    private ProgramLocation getProgramLocation(Field field, FieldLocation location) {
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangToken token = ((ClangTextField)field).getToken(location);
        if (token == null) {
            return null;
        }
        Address address = DecompilerUtils.getClosestAddress(this.getProgram(), token);
        if (address == null) {
            address = DecompilerUtils.findAddressBefore(this.layoutMgr.getFields(), token);
        }
        if (address == null) {
            address = this.decompileData.getFunction().getEntryPoint();
        }
        address = this.decompileData.getFunctionSpace().getOverlayAddress(address);
        return new DecompilerLocation(this.decompileData.getProgram(), address, this.decompileData.getFunction().getEntryPoint(), this.decompileData.getDecompileResults(), token, location.getIndex().intValue(), location.col);
    }

    public SearchLocation searchText(String text, FieldLocation startLocation, boolean forwardDirection) {
        return this.layoutMgr.findNextTokenForSearch(text, startLocation, forwardDirection);
    }

    public SearchLocation searchTextRegex(String text, FieldLocation startLocation, boolean forwardDirection) {
        return this.layoutMgr.findNextTokenForSearchRegex(text, startLocation, forwardDirection);
    }

    public void setSearchResults(SearchLocation searchLocation) {
        this.currentSearchLocation = searchLocation;
        this.repaint();
    }

    public Color getCurrentVariableHighlightColor() {
        return this.currentVariableHighlightColor;
    }

    public Color getMiddleMouseHighlightColor() {
        return this.middleMouseHighlightColor;
    }

    public Color getSpecialHighlightColor() {
        return SPECIAL_COLOR_DEF;
    }

    public String getHighlightedText() {
        return this.highlightController.getHighlightedText();
    }

    public FieldLocation getCursorPosition() {
        return this.fieldPanel.getCursorLocation();
    }

    public void setCursorPosition(FieldLocation fieldLocation) {
        this.fieldPanel.setCursorPosition(fieldLocation.getIndex(), fieldLocation.getFieldNum(), fieldLocation.getRow(), fieldLocation.getCol());
        this.fieldPanel.scrollToCursor();
    }

    public ClangToken getSelectedToken() {
        FieldSelection selection = this.fieldPanel.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Field[] lines = this.layoutMgr.getFields();
        List<ClangToken> tokens = DecompilerUtils.getTokensInSelection(selection, lines);
        long count = tokens.stream().filter(t -> !t.getText().trim().isEmpty()).count();
        if (count == 1L) {
            return tokens.get(0);
        }
        return null;
    }

    public String getTextSelection() {
        FieldSelection selection = this.fieldPanel.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return FieldSelectionHelper.getFieldSelectionText((FieldSelection)selection, (FieldPanel)this.fieldPanel);
    }

    public ClangToken getTokenAtCursor() {
        FieldLocation cursorPosition = this.fieldPanel.getCursorLocation();
        Field field = this.fieldPanel.getCurrentField();
        if (field == null) {
            return null;
        }
        return ((ClangTextField)field).getToken(cursorPosition);
    }

    public DecompileOptions getOptions() {
        return this.options;
    }

    public void addHoverService(DecompilerHoverService hoverService) {
        this.decompilerHoverProvider.addHoverService(hoverService);
    }

    public void removeHoverService(DecompilerHoverService hoverService) {
        this.decompilerHoverProvider.removeHoverService(hoverService);
    }

    public void setHoverMode(boolean enabled) {
        this.decompilerHoverProvider.setHoverEnabled(enabled);
        if (enabled) {
            this.fieldPanel.setHoverProvider((HoverProvider)this.decompilerHoverProvider);
        } else {
            this.fieldPanel.setHoverProvider(null);
        }
    }

    public boolean isHoverShowing() {
        return this.decompilerHoverProvider.isShowing();
    }

    public void clearPrimaryHighlights() {
        this.highlightController.clearPrimaryHighlights();
    }

    public void addVarnodeHighlights(Set<Varnode> varnodes, TokenHighlightColorProvider colorProvider) {
        ClangTokenGroup root = this.layoutMgr.getRoot();
        this.highlightController.addPrimaryHighlights(root, colorProvider);
    }

    public void addPcodeOpHighlights(Set<PcodeOp> ops, Color hlColor) {
        ClangTokenGroup root = this.layoutMgr.getRoot();
        this.highlightController.addPrimaryHighlights(root, ops, hlColor);
    }

    public List<ClangToken> findTokensByName(String name) {
        ArrayList<ClangToken> tokens = new ArrayList<ClangToken>();
        this.doFindTokensByName(tokens, this.layoutMgr.getRoot(), name);
        return tokens;
    }

    private void doFindTokensByName(List<ClangToken> tokens, ClangTokenGroup group, String name) {
        for (int i = 0; i < group.numChildren(); ++i) {
            ClangToken token;
            ClangNode child = group.Child(i);
            if (child instanceof ClangTokenGroup) {
                this.doFindTokensByName(tokens, (ClangTokenGroup)child, name);
                continue;
            }
            if (!(child instanceof ClangToken) || !name.equals((token = (ClangToken)child).getText())) continue;
            tokens.add(token);
        }
    }

    public ViewerPosition getViewerPosition() {
        return this.fieldPanel.getViewerPosition();
    }

    public void setViewerPosition(ViewerPosition viewerPosition) {
        this.fieldPanel.setViewerPosition(viewerPosition.getIndex(), viewerPosition.getXOffset(), viewerPosition.getYOffset());
    }

    @Override
    public void requestFocus() {
        this.fieldPanel.requestFocus();
    }

    public void selectAll() {
        BigInteger numIndexes = this.layoutMgr.getNumIndexes();
        FieldSelection selection = new FieldSelection();
        selection.addRange(BigInteger.ZERO, numIndexes);
        this.fieldPanel.setSelection(selection);
        this.selectionChanged(selection, EventTrigger.GUI_ACTION);
    }

    public void optionsChanged(DecompileOptions decompilerOptions) {
        this.setBackground(decompilerOptions.getCodeViewerBackgroundColor());
        this.currentVariableHighlightColor = this.options.getCurrentVariableHighlightColor();
        this.middleMouseHighlightColor = decompilerOptions.getMiddleMouseHighlightColor();
        this.middleMouseHighlightButton = decompilerOptions.getMiddleMouseHighlightButton();
        this.searchHighlightColor = decompilerOptions.getSearchHighlightColor();
        this.highlightController.setHighlightColor(this.currentVariableHighlightColor);
    }

    public void setHighlightController(ClangHighlightController highlightController) {
        if (this.highlightController != null) {
            this.highlightController.removeListener(this);
        }
        this.highlightController = ClangHighlightController.dummyIfNull(highlightController);
        highlightController.setHighlightColor(this.currentVariableHighlightColor);
        highlightController.addListener(this);
    }

    @Override
    public void tokenHighlightsChanged() {
        this.repaint();
    }

    public void tokenRenamed(ClangToken token, String newName) {
        if (!this.highlightController.hasSecondaryHighlight(token)) {
            return;
        }
        TokenHighlightColors colors = this.highlightController.getSecondaryHighlightColors();
        String oldName = token.getText();
        Color hlColor = colors.getColor(oldName);
        this.highlightController.removeSecondaryHighlights(token);
        this.controller.doWhenNotBusy(() -> {
            Supplier<List> lazyTokens = () -> this.findTokensByName(newName);
            this.highlightController.addSecondaryHighlights(lazyTokens, hlColor);
        });
    }

    public ClangHighlightController getHighlightController() {
        return this.highlightController;
    }

    private class PendingHighlightUpdate {
        private FieldLocation location;
        private Field field;
        private EventTrigger trigger;
        private long updateId;

        PendingHighlightUpdate(FieldLocation location, Field field, EventTrigger trigger) {
            this.location = location;
            this.field = field;
            this.trigger = trigger;
            this.updateId = DecompilerPanel.this.highlightController.getUpdateId();
        }

        void doUpdate() {
            long lastUpdateId = DecompilerPanel.this.highlightController.getUpdateId();
            if (this.updateId == lastUpdateId) {
                DecompilerPanel.this.highlightController.fieldLocationChanged(this.location, this.field, this.trigger);
            }
        }
    }

    private class DecompilerFieldPanel
    extends FieldPanel {
        public DecompilerFieldPanel(LayoutModel model) {
            super(model);
        }

        void navigateTo(int lineNumber, int column) {
            DecompilerPanel.this.fieldPanel.goTo(BigInteger.valueOf(lineNumber), 0, 0, column, false, EventTrigger.GUI_ACTION);
        }
    }

    private class ScrollingCallback
    implements SwingAnimationCallback {
        private int startLine;
        private int endLine;
        private int endColumn;
        private int duration;

        ScrollingCallback(FieldLocation start, int endLineNumber, int endColumn, int distance) {
            this.startLine = start.getIndex().intValue();
            this.endLine = endLineNumber;
            this.endColumn = endColumn;
            double rate = Math.pow(distance, 0.8);
            int ms = (int)rate * 100;
            this.duration = Math.min(1000, ms);
        }

        public int getDuration() {
            return this.duration;
        }

        public void progress(double percentComplete) {
            int length = Math.abs(this.endLine - this.startLine);
            long offset = Math.round((double)length * percentComplete);
            int current = 0;
            current = this.startLine > this.endLine ? (int)((long)this.startLine - offset) : (int)((long)this.startLine + offset);
            FieldLocation location = new FieldLocation(BigInteger.valueOf(current));
            DecompilerPanel.this.fieldPanel.scrollTo(location);
        }

        public void done() {
            DecompilerPanel.this.fieldPanel.goTo(BigInteger.valueOf(this.endLine), 0, 0, this.endColumn, false);
        }
    }

    private class SearchHighlightFactory
    implements HighlightFactory {
        private SearchHighlightFactory() {
        }

        public Highlight[] getHighlights(Field field, String text, int cursorTextOffset) {
            FieldLocation searchCursorLocation;
            int searchLineNumber;
            if (DecompilerPanel.this.currentSearchLocation == null) {
                return new Highlight[0];
            }
            ClangTextField cField = (ClangTextField)field;
            int highlightLine = cField.getLineNumber();
            if (highlightLine != (searchLineNumber = (searchCursorLocation = ((FieldBasedSearchLocation)DecompilerPanel.this.currentSearchLocation).getFieldLocation()).getIndex().intValue() + 1)) {
                return new Highlight[0];
            }
            return new Highlight[]{new Highlight(DecompilerPanel.this.currentSearchLocation.getStartIndexInclusive(), DecompilerPanel.this.currentSearchLocation.getEndIndexInclusive(), DecompilerPanel.this.searchHighlightColor)};
        }
    }
}

