/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class RetypeFieldAction
extends AbstractDecompilerAction {
    public RetypeFieldAction() {
        super("Retype Field");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeField"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Field"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            Structure dt = RetypeFieldAction.getStructDataType(tokenAtCursor);
            return dt != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DataType originalDataType;
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        Structure struct = RetypeFieldAction.getStructDataType(tokenAtCursor);
        int offset = ((ClangFieldToken)tokenAtCursor).getOffset();
        if (struct == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)"Failed to re-type structure");
            return;
        }
        if (offset < 0 || offset >= struct.getLength()) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure field at offset " + offset + ": " + struct.getName()));
            return;
        }
        DataTypeComponent comp = struct.getComponentContaining(offset);
        if (comp != null && comp.getOffset() != offset) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)"Retype offset does not correspond to start of component");
            return;
        }
        DataType dataType = originalDataType = comp != null ? comp.getDataType() : DataType.DEFAULT;
        if (originalDataType instanceof BitFieldDataType) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)"Retype of defind bit-field is not supported.");
            return;
        }
        DataType dataType2 = this.chooseDataType(tool, program, originalDataType);
        if (dataType2 == null || dataType2.isEquivalent(originalDataType)) {
            return;
        }
        if (dataType2 instanceof FactoryDataType || dataType2.getLength() <= 0) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Retype field with \"" + dataType2.getName() + "\" data type is not allowed."));
        }
        int transaction = program.startTransaction("Retype Structure Field");
        try {
            int nextOffset;
            dataType2 = dataTypeManager.resolve(dataType2, null);
            int newDtLength = dataType2.getLength();
            if (DataTypeComponent.usesZeroLengthComponent((DataType)dataType2)) {
                Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Retype field with \"" + dataType2.getName() + "\" zero-length component is not allowed."));
            }
            if (originalDataType != DataType.DEFAULT && newDtLength == originalDataType.getLength()) {
                struct.replace(comp.getOrdinal(), dataType2, -1);
                return;
            }
            String fieldName = null;
            String comment = null;
            if (comp == null) {
                nextOffset = offset + 1;
            } else {
                fieldName = comp.getFieldName();
                comment = comp.getComment();
                nextOffset = comp.getEndOffset() + 1;
            }
            int available = nextOffset - offset;
            if (newDtLength > available) {
                int endOffset;
                DataTypeComponent nextComp = struct.getDefinedComponentAtOrAfterOffset(nextOffset);
                int n = endOffset = nextComp == null ? struct.getLength() : nextComp.getOffset();
                if (newDtLength > (available += endOffset - nextOffset)) {
                    Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure '" + struct.getName() + "': Datatype will not fit"));
                    return;
                }
            }
            if (struct.isPackingEnabled() && !this.isAlignmentMaintained(comp, dataType2, offset)) {
                int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Disable Structure Packing", (String)"Containing structure currently has packing enabled.  Packing will be disabled if you continue.", (String)"Continue", (int)2);
                if (choice != 1) {
                    return;
                }
                int alignment = struct.getAlignment();
                struct.setPackingEnabled(false);
                struct.setExplicitMinimumAlignment(alignment);
            }
            struct.replaceAtOffset(offset, dataType2, -1, fieldName, comment);
        }
        catch (IllegalArgumentException e) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type structure: " + e.getMessage()));
        }
        finally {
            program.endTransaction(transaction, true);
        }
    }

    private boolean isAlignmentMaintained(DataTypeComponent comp, DataType dataType, int offset) {
        if (comp == null) {
            return false;
        }
        int align = comp.getDataType().getAlignment();
        if (align != dataType.getAlignment()) {
            return false;
        }
        return offset % align == 0;
    }
}

