/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import generic.concurrent.QItemListener;
import generic.concurrent.QResult;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import utility.function.Dummy;

public class DecompilerConcurrentQ<I, R> {
    private ConcurrentQ<I, R> queue;
    private Consumer<R> resultConsumer = Dummy.consumer();

    public DecompilerConcurrentQ(QCallback<I, R> callback, TaskMonitor monitor) {
        this(callback, AutoAnalysisManager.getSharedAnalsysThreadPool(), monitor);
    }

    public DecompilerConcurrentQ(QCallback<I, R> callback, String threadPoolName, TaskMonitor monitor) {
        this(callback, GThreadPool.getSharedThreadPool((String)threadPoolName), monitor);
    }

    private DecompilerConcurrentQ(QCallback<I, R> callback, GThreadPool pool, TaskMonitor monitor) {
        this.queue = new ConcurrentQBuilder().setCollectResults(true).setThreadPool(pool).setMonitor(monitor).setListener((QItemListener)new InternalResultListener()).build(callback);
    }

    public void addAll(Collection<I> collection) {
        this.queue.add(collection);
    }

    public void addAll(Iterator<I> iterator) {
        this.queue.add(iterator);
    }

    public void add(I i) {
        this.queue.add(i);
    }

    public void process(Iterator<I> functions, Consumer<R> consumer) {
        this.resultConsumer = Objects.requireNonNull(consumer);
        this.addAll(functions);
    }

    public Collection<QResult<I, R>> waitForResults() throws InterruptedException {
        try {
            Collection collection = this.queue.waitForResults();
            return collection;
        }
        finally {
            this.queue.dispose();
        }
    }

    public void waitUntilDone() throws InterruptedException, Exception {
        try {
            this.queue.waitUntilDone();
        }
        finally {
            this.queue.dispose();
        }
    }

    public void dispose() {
        this.queue.dispose();
    }

    public void dispose(long timeoutSeconds) {
        this.queue.dispose();
        boolean finished = false;
        try {
            finished = this.queue.waitUntilDone(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished) {
            Msg.debug((Object)this, (Object)("Unable to shutdown all tasks in " + timeoutSeconds + " " + TimeUnit.SECONDS));
        }
    }

    private class InternalResultListener
    implements QItemListener<I, R> {
        private InternalResultListener() {
        }

        public void itemProcessed(QResult<I, R> result) {
            try {
                Object r = result.getResult();
                if (r != null) {
                    DecompilerConcurrentQ.this.resultConsumer.accept(r);
                }
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)"Unexpected exception getting Decompiler result", (Throwable)t);
                DecompilerConcurrentQ.this.queue.dispose();
            }
        }
    }
}

