/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.InstructionDecoder;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.SleighInstructionDecoder;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.AnnotatedSleighUseropLibrary;
import ghidra.pcode.exec.InterruptPcodeExecutionException;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.pcode.exec.SuspendedPcodeExecutionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.util.ProgramContextImpl;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPcodeThread<T>
implements PcodeThread<T> {
    private final String name;
    private final AbstractPcodeMachine<T> machine;
    protected final SleighLanguage language;
    protected final PcodeArithmetic<T> arithmetic;
    protected final ThreadPcodeExecutorState<T> state;
    protected final InstructionDecoder decoder;
    protected final SleighUseropLibrary<T> library;
    protected final PcodeThreadExecutor executor;
    protected final Register pc;
    protected final Register contextreg;
    private Address counter;
    private RegisterValue context;
    protected Instruction instruction;
    protected PcodeFrame frame;
    protected final ProgramContextImpl defaultContext;
    protected final Map<Address, PcodeProgram> injects = new HashMap<Address, PcodeProgram>();

    public DefaultPcodeThread(String name, AbstractPcodeMachine<T> machine) {
        this.name = name;
        this.machine = machine;
        this.language = machine.language;
        this.arithmetic = machine.arithmetic;
        PcodeExecutorState<T> sharedState = machine.getSharedState();
        PcodeExecutorState<T> localState = machine.createLocalState(this);
        this.state = new ThreadPcodeExecutorState<T>(sharedState, localState);
        this.decoder = this.createInstructionDecoder(sharedState);
        this.library = this.createUseropLibrary();
        this.executor = this.createExecutor();
        this.pc = this.language.getProgramCounter();
        this.contextreg = this.language.getContextBaseRegister();
        if (this.contextreg != Register.NO_CONTEXT) {
            this.defaultContext = new ProgramContextImpl((Language)this.language);
            this.language.applyContextSettings((DefaultProgramContext)this.defaultContext);
            this.context = this.defaultContext.getDefaultDisassemblyContext();
        } else {
            this.defaultContext = null;
        }
        this.reInitialize();
    }

    protected SleighInstructionDecoder createInstructionDecoder(PcodeExecutorState<T> sharedState) {
        return new SleighInstructionDecoder((Language)this.language, sharedState);
    }

    protected SleighUseropLibrary<T> createUseropLibrary() {
        return new SleighEmulationLibrary(this).compose(this.machine.library);
    }

    protected PcodeThreadExecutor createExecutor() {
        return new PcodeThreadExecutor(this.language, this.arithmetic, this.state);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractPcodeMachine<T> getMachine() {
        return this.machine;
    }

    @Override
    public void setCounter(Address counter) {
        this.counter = counter;
    }

    @Override
    public Address getCounter() {
        return this.counter;
    }

    @Override
    public void overrideCounter(Address counter) {
        this.setCounter(counter);
        this.state.setVar(this.pc, this.arithmetic.fromConst(counter.getAddressableWordOffset(), this.pc.getMinimumByteSize()));
    }

    @Override
    public void assignContext(RegisterValue context) {
        if (!context.getRegister().isProcessorContext()) {
            throw new IllegalArgumentException("context must be the contextreg value");
        }
        this.context = this.context.assign(context.getRegister(), context);
    }

    @Override
    public RegisterValue getContext() {
        return this.context;
    }

    @Override
    public void overrideContext(RegisterValue context) {
        this.assignContext(context);
        this.state.setVar(this.contextreg, this.arithmetic.fromConst(this.context.getUnsignedValueIgnoreMask(), this.contextreg.getMinimumByteSize(), true));
    }

    @Override
    public void overrideContextWithDefault() {
        if (this.contextreg != Register.NO_CONTEXT) {
            this.overrideContext(this.defaultContext.getDefaultValue(this.contextreg, this.counter));
        }
    }

    protected void doPluggableInitialization() {
        if (this.machine.initializer != null) {
            this.machine.initializer.initializeThread(this);
        }
    }

    @Override
    public void reInitialize() {
        long offset = this.arithmetic.toConcrete(this.state.getVar(this.pc)).longValue();
        this.setCounter(this.language.getDefaultSpace().getAddress(offset, true));
        if (this.contextreg != Register.NO_CONTEXT) {
            try {
                BigInteger ctx = this.arithmetic.toConcrete(this.state.getVar(this.contextreg), true);
                this.assignContext(new RegisterValue(this.contextreg, ctx));
            }
            catch (AccessPcodeExecutionException e) {
                Msg.info((Object)this, (Object)"contextreg not recorded in trace. This is pretty normal.");
            }
        }
        this.doPluggableInitialization();
    }

    @Override
    public void stepInstruction() {
        PcodeProgram inj = this.getInject(this.counter);
        if (inj != null) {
            this.instruction = null;
            try {
                this.executor.execute(inj, this.library);
            }
            catch (PcodeExecutionException e) {
                this.frame = e.getFrame();
                throw e;
            }
        } else {
            this.executeInstruction();
        }
    }

    @Override
    public void stepPcodeOp() {
        if (this.frame == null) {
            this.beginInstructionOrInject();
        } else if (!this.frame.isFinished()) {
            this.executor.step(this.frame, this.library);
        } else {
            this.advanceAfterFinished();
        }
    }

    protected void beginInstructionOrInject() {
        PcodeProgram inj = this.injects.get(this.counter);
        if (inj != null) {
            this.instruction = null;
            this.frame = this.executor.begin(inj);
        } else {
            this.instruction = this.decoder.decodeInstruction(this.counter, this.context);
            PcodeProgram pcode = PcodeProgram.fromInstruction(this.instruction);
            this.frame = this.executor.begin(pcode);
        }
    }

    protected void advanceAfterFinished() {
        if (this.instruction == null) {
            this.frame = null;
            return;
        }
        if (this.frame.isFallThrough()) {
            this.overrideCounter(this.counter.addWrap((long)this.decoder.getLastLengthWithDelays()));
        }
        if (this.contextreg != Register.NO_CONTEXT) {
            this.overrideContext(this.instruction.getRegisterValue(this.contextreg));
        }
        this.postExecuteInstruction();
        this.frame = null;
    }

    @Override
    public PcodeFrame getFrame() {
        return this.frame;
    }

    protected void assertCompletedInstruction() {
        if (this.frame != null) {
            throw new IllegalStateException("The current instruction or inject has not finished.");
        }
    }

    protected void assertMidInstruction() {
        if (this.frame == null) {
            throw new IllegalStateException("There is no current instruction to finish.");
        }
    }

    protected void preExecuteInstruction() {
    }

    protected void postExecuteInstruction() {
    }

    @Override
    public void executeInstruction() {
        this.assertCompletedInstruction();
        this.instruction = this.decoder.decodeInstruction(this.counter, this.context);
        PcodeProgram insProg = PcodeProgram.fromInstruction(this.instruction);
        this.preExecuteInstruction();
        try {
            this.frame = this.executor.execute(insProg, this.library);
        }
        catch (PcodeExecutionException e) {
            this.frame = e.getFrame();
            throw e;
        }
        this.advanceAfterFinished();
    }

    @Override
    public void finishInstruction() {
        this.assertMidInstruction();
        this.executor.finish(this.frame, this.library);
        this.advanceAfterFinished();
    }

    @Override
    public void skipInstruction() {
        this.assertCompletedInstruction();
        this.instruction = this.decoder.decodeInstruction(this.counter, this.context);
        this.overrideCounter(this.counter.addWrap((long)this.decoder.getLastLengthWithDelays()));
    }

    @Override
    public void dropInstruction() {
        this.frame = null;
    }

    @Override
    public void run() {
        this.executor.suspended = false;
        if (this.frame != null) {
            this.finishInstruction();
        }
        while (true) {
            this.stepInstruction();
        }
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.executor.suspended = suspended;
    }

    @Override
    public PcodeExecutor<T> getExecutor() {
        return this.executor;
    }

    @Override
    public SleighUseropLibrary<T> getUseropLibrary() {
        return this.library;
    }

    @Override
    public ThreadPcodeExecutorState<T> getState() {
        return this.state;
    }

    protected PcodeProgram getInject(Address address) {
        PcodeProgram inj = this.injects.get(address);
        if (inj != null) {
            return inj;
        }
        return this.machine.getInject(address);
    }

    @Override
    public void inject(Address address, List<String> sleigh) {
        PcodeProgram pcode = SleighProgramCompiler.compileProgram(this.language, "thread_inject:" + address, sleigh, this.library);
        this.injects.put(address, pcode);
    }

    @Override
    public void clearInject(Address address) {
        this.injects.remove(address);
    }

    @Override
    public void clearAllInjects() {
        this.injects.clear();
    }

    protected class PcodeThreadExecutor
    extends PcodeExecutor<T> {
        volatile boolean suspended;

        public PcodeThreadExecutor(SleighLanguage language, PcodeArithmetic<T> arithmetic, PcodeExecutorStatePiece<T, T> state) {
            super(language, arithmetic, state);
            this.suspended = false;
        }

        @Override
        public void stepOp(PcodeOp op, PcodeFrame frame, SleighUseropLibrary<T> library) {
            if (this.suspended) {
                throw new SuspendedPcodeExecutionException(frame, null);
            }
            super.stepOp(op, frame, library);
        }

        @Override
        protected void branchToAddress(Address target) {
            DefaultPcodeThread.this.overrideCounter(target);
        }
    }

    protected static class SleighEmulationLibrary<T>
    extends AnnotatedSleighUseropLibrary<T> {
        private final DefaultPcodeThread<T> thread;

        public SleighEmulationLibrary(DefaultPcodeThread<T> thread) {
            this.thread = thread;
        }

        @AnnotatedSleighUseropLibrary.SleighUserop
        public void emu_exec_decoded() {
            PcodeFrame saved = this.thread.frame;
            this.thread.dropInstruction();
            this.thread.executeInstruction();
            this.thread.frame = saved;
        }

        @AnnotatedSleighUseropLibrary.SleighUserop
        public void emu_skip_decoded() {
            PcodeFrame saved = this.thread.frame;
            this.thread.dropInstruction();
            this.thread.skipInstruction();
            this.thread.frame = saved;
        }

        @AnnotatedSleighUseropLibrary.SleighUserop
        public void emu_swi() {
            throw new InterruptPcodeExecutionException(null, null);
        }
    }
}

