/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class FourPassImageShaper {
    public static Shape getShape(BufferedImage image) {
        Area area = new Area(FourPassImageShaper.leftEdge(image));
        area.intersect(new Area(FourPassImageShaper.bottomEdge(image)));
        area.intersect(new Area(FourPassImageShaper.rightEdge(image)));
        area.intersect(new Area(FourPassImageShaper.topEdge(image)));
        return area;
    }

    private static Point2D detectLine(Point2D p1, Point2D p2, Point2D p, Line2D line, GeneralPath path) {
        if (line.ptLineDistSq(p) == 0.0) {
            p2.setLocation(p);
        } else {
            p1.setLocation(p2);
            p2.setLocation(p);
            line.setLine(p1, p2);
            path.lineTo((float)p1.getX(), (float)p1.getY());
        }
        return p2;
    }

    private static Shape leftEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = null;
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        int foundPointY = -1;
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                if ((image.getRGB(j, i) & 0xFF000000) == 0) continue;
                p = new Point2D.Float(j, i);
                foundPointY = i;
                break;
            }
            if (foundPointY < 0) continue;
            if (p2 == null) {
                p1 = new Point2D.Float(image.getWidth() - 1, foundPointY);
                path.moveTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
                p2 = new Point2D.Float();
                p2.setLocation(p);
                continue;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        path.lineTo(((Point2D)p).getX(), ((Point2D)p).getY());
        if (foundPointY >= 0) {
            path.lineTo(image.getWidth() - 1, foundPointY);
        }
        path.closePath();
        return path;
    }

    private static Shape bottomEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = null;
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        int foundPointX = -1;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = image.getHeight() - 1; j >= 0; --j) {
                if ((image.getRGB(i, j) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(i, j);
                foundPointX = i;
                break;
            }
            if (foundPointX < 0) continue;
            if (p2 == null) {
                p1 = new Point2D.Float(foundPointX, 0.0f);
                path.moveTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
                p2 = new Point2D.Float();
                p2.setLocation(p);
                continue;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        path.lineTo(((Point2D)p).getX(), ((Point2D)p).getY());
        if (foundPointX >= 0) {
            path.lineTo(foundPointX, 0.0f);
        }
        path.closePath();
        return path;
    }

    private static Shape rightEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = null;
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        int foundPointY = -1;
        for (int i = image.getHeight() - 1; i >= 0; --i) {
            for (int j = image.getWidth() - 1; j >= 0; --j) {
                if ((image.getRGB(j, i) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(j, i);
                foundPointY = i;
                break;
            }
            if (foundPointY < 0) continue;
            if (p2 == null) {
                p1 = new Point2D.Float(0.0f, foundPointY);
                path.moveTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
                p2 = new Point2D.Float();
                p2.setLocation(p);
                continue;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        path.lineTo(((Point2D)p).getX(), ((Point2D)p).getY());
        if (foundPointY >= 0) {
            path.lineTo(0.0f, foundPointY);
        }
        path.closePath();
        return path;
    }

    private static Shape topEdge(BufferedImage image) {
        GeneralPath path = new GeneralPath();
        Point2D.Float p1 = null;
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        Point2D.Float p = new Point2D.Float();
        int foundPointX = -1;
        for (int i = image.getWidth() - 1; i >= 0; --i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                if ((image.getRGB(i, j) & 0xFF000000) == 0) continue;
                ((Point2D)p).setLocation(i, j);
                foundPointX = i;
                break;
            }
            if (foundPointX < 0) continue;
            if (p2 == null) {
                p1 = new Point2D.Float(foundPointX, image.getHeight() - 1);
                path.moveTo(((Point2D)p1).getX(), ((Point2D)p1).getY());
                p2 = new Point2D.Float();
                p2.setLocation(p);
                continue;
            }
            p2 = FourPassImageShaper.detectLine(p1, p2, p, line, path);
        }
        path.lineTo(((Point2D)p).getX(), ((Point2D)p).getY());
        if (foundPointX >= 0) {
            path.lineTo(foundPointX, image.getHeight() - 1);
        }
        path.closePath();
        return path;
    }
}

