/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.ArrayBuilder;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.GPTEntry;
import org.catacombae.hfsexplorer.partitioning.GPTHeader;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.io.ReadableRandomAccessStream;

public class GUIDPartitionTable
implements PartitionSystem,
StructElements {
    private static final int BLOCK_SIZE = 512;
    protected GPTHeader header;
    protected GPTEntry[] entries;
    protected GPTEntry[] backupEntries;
    protected GPTHeader backupHeader;
    private final LinkedList<GPTEntry> tempList = new LinkedList();

    public GUIDPartitionTable(ReadableRandomAccessStream llf, int offset) {
        byte[] headerData = new byte[512];
        byte[] currentEntryData = new byte[128];
        llf.seek(offset + 512);
        llf.readFully(headerData);
        this.header = new GPTHeader(headerData, 0, 512);
        if (this.header.isValid()) {
            GPTEntry[] tBackupEntries;
            GPTHeader tBackupHeader;
            llf.seek((long)offset + this.header.getPartitionEntryLBA() * 512L);
            this.entries = new GPTEntry[this.header.getNumberOfPartitionEntries()];
            for (int i = 0; i < this.entries.length; ++i) {
                llf.readFully(currentEntryData);
                this.entries[i] = new GPTEntry(currentEntryData, 0, 512);
            }
            try {
                llf.seek((long)offset + 512L * this.header.getBackupLBA());
                llf.readFully(headerData);
                tBackupHeader = new GPTHeader(headerData, 0, 512);
                if (tBackupHeader.isValid()) {
                    llf.seek((long)offset + tBackupHeader.getPartitionEntryLBA() * 512L);
                    tBackupEntries = new GPTEntry[tBackupHeader.getNumberOfPartitionEntries()];
                    for (int i = 0; i < tBackupEntries.length; ++i) {
                        llf.readFully(currentEntryData);
                        tBackupEntries[i] = new GPTEntry(currentEntryData, 0, 512);
                    }
                } else {
                    tBackupEntries = new GPTEntry[]{};
                }
            }
            catch (Exception e) {
                tBackupHeader = new GPTHeader(new byte[GPTHeader.getSize()], 0, 512);
                tBackupEntries = new GPTEntry[]{};
            }
            this.backupHeader = tBackupHeader;
            this.backupEntries = tBackupEntries;
        } else {
            this.entries = new GPTEntry[0];
            this.backupHeader = new GPTHeader(new byte[GPTHeader.getSize()], 0, 512);
            this.backupEntries = new GPTEntry[0];
        }
    }

    protected GUIDPartitionTable(GUIDPartitionTable source) {
        int i;
        this.header = new GPTHeader(source.header);
        this.entries = new GPTEntry[source.entries.length];
        for (i = 0; i < this.entries.length; ++i) {
            this.entries[i] = new GPTEntry(source.entries[i]);
        }
        this.backupHeader = new GPTHeader(source.backupHeader);
        this.backupEntries = new GPTEntry[source.backupEntries.length];
        for (i = 0; i < this.backupEntries.length; ++i) {
            this.backupEntries[i] = new GPTEntry(source.backupEntries[i]);
        }
    }

    protected GUIDPartitionTable(GPTHeader header, GPTHeader backupHeader, int numberOfPrimaryEntries, int numberOfBackupEntries) {
        this.header = header;
        this.backupHeader = backupHeader;
        this.entries = new GPTEntry[numberOfPrimaryEntries];
        this.backupEntries = new GPTEntry[numberOfBackupEntries];
    }

    public GPTHeader getHeader() {
        return this.header;
    }

    public GPTHeader getBackupHeader() {
        return this.backupHeader;
    }

    public GPTEntry getEntry(int index) {
        return this.entries[index];
    }

    public GPTEntry[] getEntries() {
        return Util.arrayCopy(this.entries, new GPTEntry[this.entries.length]);
    }

    public GPTEntry getBackupEntry(int index) {
        return this.backupEntries[index];
    }

    public GPTEntry[] getBackupEntries() {
        return Util.arrayCopy(this.backupEntries, new GPTEntry[this.backupEntries.length]);
    }

    public int getPartitionCount() {
        return this.entries.length;
    }

    public int getUsedPartitionCount() {
        int count = 0;
        for (GPTEntry ge : this.entries) {
            if (!ge.isUsed()) continue;
            ++count;
        }
        return count;
    }

    public Partition getPartitionEntry(int index) {
        return this.getEntry(index);
    }

    public Partition[] getPartitionEntries() {
        return this.getEntries();
    }

    public Partition[] getUsedPartitionEntries() {
        this.tempList.clear();
        for (GPTEntry ge : this.entries) {
            if (!ge.isUsed()) continue;
            this.tempList.addLast(ge);
        }
        return this.tempList.toArray(new GPTEntry[this.tempList.size()]);
    }

    public boolean isValid() {
        boolean primaryTableValid = this.header.isValid() && this.header.getCRC32Checksum() == this.calculatePrimaryHeaderChecksum() && this.header.getPartitionEntryArrayCRC32() == this.calculatePrimaryEntriesChecksum();
        boolean backupTableValid = this.backupHeader.isValid() && this.backupHeader.getCRC32Checksum() == this.calculateBackupHeaderChecksum() && this.backupHeader.getPartitionEntryArrayCRC32() == this.calculateBackupEntriesChecksum();
        boolean entryTablesEqual = true;
        if (this.backupEntries.length != this.entries.length) {
            entryTablesEqual = false;
        } else {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].equals(this.backupEntries[i])) continue;
                entryTablesEqual = false;
                break;
            }
        }
        boolean validBackupHeader = this.header.isValidBackup(this.backupHeader) && this.backupHeader.isValidBackup(this.header);
        return primaryTableValid && backupTableValid && entryTablesEqual && validBackupHeader;
    }

    public int calculatePrimaryHeaderChecksum() {
        return this.header.calculateCRC32();
    }

    public int calculatePrimaryEntriesChecksum() {
        CRC32 checksum = new CRC32();
        for (GPTEntry entry : this.entries) {
            checksum.update(entry.getBytes());
        }
        return (int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public int calculateBackupHeaderChecksum() {
        return this.backupHeader.calculateCRC32();
    }

    public int calculateBackupEntriesChecksum() {
        CRC32 checksum = new CRC32();
        for (GPTEntry entry : this.backupEntries) {
            checksum.update(entry.getBytes());
        }
        return (int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    public String getLongName() {
        return "GUID Partition Table";
    }

    public String getShortName() {
        return "GPT";
    }

    public void printFields(PrintStream ps, String prefix) {
        this.printPrimaryFields(ps, prefix);
        this.printBackupFields(ps, prefix);
    }

    public void printPrimaryFields(PrintStream ps, String prefix) {
        ps.println(prefix + " header:");
        this.header.print(ps, prefix + "  ");
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.entries[i].isUsed()) continue;
            ps.println(prefix + " entries[" + i + "]:");
            this.entries[i].print(ps, prefix + "  ");
        }
    }

    public void printBackupFields(PrintStream ps, String prefix) {
        for (int i = 0; i < this.backupEntries.length; ++i) {
            if (!this.backupEntries[i].isUsed()) continue;
            ps.println(prefix + " backupEntries[" + i + "]:");
            this.backupEntries[i].print(ps, prefix + "  ");
        }
        ps.println(prefix + " backupHeader:");
        this.backupHeader.print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "GUIDPartitionTable:");
        this.printFields(ps, prefix);
    }

    public long getPrimaryTableBytesOffset() {
        return 512L;
    }

    public long getBackupTableBytesOffset() {
        return this.backupHeader.getPartitionEntryLBA() * 512L;
    }

    public byte[] getPrimaryTableBytes() {
        int offset = 0;
        byte[] result = new byte[GPTHeader.getSize() + GPTEntry.getSize() * this.entries.length];
        byte[] headerData = this.header.getBytes();
        System.arraycopy(headerData, 0, result, offset, GPTHeader.getSize());
        offset += GPTHeader.getSize();
        for (GPTEntry ge : this.entries) {
            byte[] entryData = ge.getBytes();
            System.arraycopy(entryData, 0, result, offset, entryData.length);
            offset += GPTEntry.getSize();
        }
        return result;
    }

    public byte[] getBackupTableBytes() {
        int offset = 0;
        byte[] result = new byte[GPTEntry.getSize() * this.entries.length + GPTHeader.getSize()];
        for (GPTEntry ge : this.backupEntries) {
            byte[] entryData = ge.getBytes();
            System.arraycopy(entryData, 0, result, offset, entryData.length);
            offset += GPTEntry.getSize();
        }
        byte[] headerData = this.backupHeader.getBytes();
        System.arraycopy(headerData, 0, result, offset, GPTHeader.getSize());
        offset += GPTHeader.getSize();
        return result;
    }

    public Dictionary getStructElements() {
        GPTEntry ge;
        int i;
        StructElements.DictionaryBuilder dbStruct = new StructElements.DictionaryBuilder(this.getClass().getSimpleName());
        dbStruct.add("header", this.header.getStructElements());
        ArrayBuilder ab = new ArrayBuilder(GPTEntry.class.getSimpleName());
        for (i = 0; i < this.entries.length; ++i) {
            ge = this.entries[i];
            ab.add(ge.getStructElements());
        }
        dbStruct.add("entries", ab.getResult());
        dbStruct.add("backupHeader", this.backupHeader.getStructElements());
        ab = new ArrayBuilder(GPTEntry.class.getSimpleName());
        for (i = 0; i < this.backupEntries.length; ++i) {
            ge = this.backupEntries[i];
            ab.add(ge.getStructElements());
        }
        dbStruct.add("backupEntries", ab.getResult());
        return dbStruct.getResult();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GUIDPartitionTable) {
            GUIDPartitionTable gpt = (GUIDPartitionTable)obj;
            return Util.arraysEqual(this.getPrimaryTableBytes(), gpt.getPrimaryTableBytes()) && Util.arraysEqual(this.getBackupTableBytes(), gpt.getBackupTableBytes());
        }
        return false;
    }
}

