/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.microsoft.MicrosoftDemangler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;

public class MicrosoftDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    private static final String NAME = "Demangler Microsoft";
    private static final String DESCRIPTION = "After a function is created, this analyzer will attempt to demangle the name and apply datatypes to parameters.";
    private static final String OPTION_NAME_APPLY_SIGNATURE = "Apply Function Signatures";
    private static final String OPTION_DESCRIPTION_APPLY_SIGNATURE = "Apply any recovered function signature, in addition to the function name";
    private boolean applyFunctionSignature = true;
    private MicrosoftDemangler demangler = new MicrosoftDemangler();

    public MicrosoftDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_APPLY_SIGNATURE, (Object)this.applyFunctionSignature, null, OPTION_DESCRIPTION_APPLY_SIGNATURE);
    }

    public void optionsChanged(Options options, Program program) {
        this.applyFunctionSignature = options.getBoolean(OPTION_NAME_APPLY_SIGNATURE, this.applyFunctionSignature);
    }

    protected DemangledObject doDemangle(String mangled, DemanglerOptions options, MessageLog log) throws DemangledException {
        DemangledObject demangled = this.demangler.demangle(mangled, options);
        return demangled;
    }
}

