/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.parsing;

import agent.gdb.manager.parsing.GdbParsingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringEscapeUtils;

public class GdbMiParser
extends GdbParsingUtils.AbstractGdbParser {
    public static final String UNNAMED = "<unnamed>";
    protected static final Pattern COMMA = Pattern.compile(",");
    protected static final Pattern LBRACKET = Pattern.compile("\\[");
    protected static final Pattern RBRACKET = Pattern.compile("\\]");
    protected static final Pattern FIELD_ID = Pattern.compile("([0-9A-Za-z_]|-)+");
    protected static final Pattern EQUALS = Pattern.compile("=");
    protected static final Pattern LBRACE = Pattern.compile("\\{");
    protected static final Pattern RBRACE = Pattern.compile("\\}");

    public GdbMiParser(CharSequence text) {
        super(text);
    }

    public static Object parseObject(CharSequence text) throws GdbParsingUtils.GdbParseError {
        GdbMiParser parser = new GdbMiParser(text);
        Object result = parser.parseObject();
        parser.checkEmpty(true);
        return result;
    }

    public static String parseString(CharSequence text) throws GdbParsingUtils.GdbParseError {
        GdbMiParser parser = new GdbMiParser(text);
        String result = parser.parseString();
        parser.checkEmpty(true);
        return result;
    }

    public static GdbMiFieldList parseFields(CharSequence text) throws GdbParsingUtils.GdbParseError {
        GdbMiParser parser = new GdbMiParser(text);
        GdbMiFieldList result = parser.parseFields(false);
        parser.checkEmpty(true);
        return result;
    }

    public Object parseObject() throws GdbParsingUtils.GdbParseError {
        switch (this.peek(true)) {
            case '\"': {
                return this.parseString();
            }
            case '[': {
                return this.parseList();
            }
            case '{': {
                return this.parseMap();
            }
        }
        return this.parseFields(false);
    }

    public String parseString() throws GdbParsingUtils.GdbParseError {
        char c;
        int start = this.buf.position();
        if ('\"' != this.peek(false)) {
            throw new GdbParsingUtils.GdbParseError("\"", this.buf);
        }
        this.buf.get();
        while ((c = this.buf.get()) != '\"') {
            if (c != '\\') continue;
            this.buf.get();
        }
        int end = this.buf.position();
        this.buf.position(0);
        String result = this.buf.subSequence(start + 1, end - 1).toString();
        this.buf.position(end);
        return StringEscapeUtils.unescapeJava((String)result);
    }

    public Object parseList() throws GdbParsingUtils.GdbParseError {
        Object maybeFieldList;
        this.match(LBRACKET, true);
        ArrayList<Object> result = new ArrayList<Object>();
        while (this.buf.hasRemaining()) {
            char c = this.peek(true);
            if (c == ']') {
                this.match(RBRACKET, false);
                break;
            }
            if (c == ',') {
                this.match(COMMA, false);
            }
            result.add(this.parseObject());
        }
        if (result.size() == 1 && (maybeFieldList = result.get(0)) instanceof GdbMiFieldList) {
            GdbMiFieldList fieldList = (GdbMiFieldList)maybeFieldList;
            if (!fieldList.enclosed) {
                return maybeFieldList;
            }
        }
        return Collections.unmodifiableList(result);
    }

    public GdbMiFieldList parseMap() throws GdbParsingUtils.GdbParseError {
        this.match(LBRACE, true);
        GdbMiFieldList result = this.parseFields(true);
        this.match(RBRACE, true);
        return result;
    }

    public GdbMiFieldList parseFields(boolean enclosed) throws GdbParsingUtils.GdbParseError {
        char c;
        GdbMiFieldList result = new GdbMiFieldList(enclosed);
        while (this.buf.hasRemaining() && (c = this.peek(true)) != ']' && c != '}') {
            if (c == ',') {
                this.match(COMMA, false);
            }
            if ((c = this.peek(true)) == '{') {
                Object fieldVal = this.parseObject();
                result.add(UNNAMED, fieldVal);
                continue;
            }
            String fieldId = this.match(FIELD_ID, true);
            this.match(EQUALS, true);
            Object fieldVal = this.parseObject();
            result.add(fieldId, fieldVal);
        }
        return result;
    }

    public static class GdbMiFieldList {
        private MultiValuedMap<String, Object> map = new HashSetValuedHashMap<String, Object>(){

            protected HashSet<Object> createCollection() {
                return new LinkedHashSet<Object>();
            }
        };
        private MultiValuedMap<String, Object> unmodifiableMap = MultiMapUtils.unmodifiableMultiValuedMap(this.map);
        private final List<Entry> entryList = new ArrayList<Entry>();
        private final List<Entry> unmodifiableEntries = Collections.unmodifiableList(this.entryList);
        private final boolean enclosed;

        public static Builder builder() {
            return new Builder();
        }

        private GdbMiFieldList(boolean enclosed) {
            this.enclosed = enclosed;
        }

        private void add(String key, Object value) {
            this.entryList.add(new Entry(key, value));
            this.map.put((Object)key, value);
        }

        public List<Entry> entries() {
            return this.unmodifiableEntries;
        }

        public Collection<Object> get(String key) {
            return this.unmodifiableMap.get((Object)key);
        }

        public Object getSingleton(String key) {
            Collection col = this.map.get((Object)key);
            if (col.size() == 0) {
                return null;
            }
            if (col.size() != 1) {
                throw new IllegalStateException("Key " + key + " is multi-valued: " + col);
            }
            return col.iterator().next();
        }

        public String getString(String key) {
            return (String)this.getSingleton(key);
        }

        public <T> List<T> getListOf(Class<T> cls, String key) {
            return (List)this.getSingleton(key);
        }

        public GdbMiFieldList getFieldList(String key) {
            Object obj = this.getSingleton(key);
            if (obj instanceof List && ((List)obj).isEmpty()) {
                return GdbMiFieldList.builder().build();
            }
            return (GdbMiFieldList)obj;
        }

        public boolean containsKey(String key) {
            return this.map.containsKey((Object)key);
        }

        public int size() {
            return this.entryList.size();
        }

        public String toString() {
            return this.map.toString();
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GdbMiFieldList)) {
                return false;
            }
            GdbMiFieldList that = (GdbMiFieldList)obj;
            return Objects.equals(this.map, that.map);
        }

        public static class Entry {
            private final String key;
            private final Object value;

            private Entry(String key, Object value) {
                this.key = key;
                this.value = value;
            }

            public String getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private final GdbMiFieldList list = new GdbMiFieldList(false);

            private Builder() {
            }

            public Builder add(String key, Object value) {
                this.list.add(key, value);
                return this;
            }

            public GdbMiFieldList build() {
                return this.list;
            }
        }
    }
}

