/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBBreakpoint;
import SWIG.SBProcess;
import SWIG.SBTarget;
import SWIG.SBThread;
import SWIG.StopReason;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.model.iface2.LldbModelTargetBreakpointContainer;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.iface2.LldbModelTargetBreakpointSpec;
import agent.lldb.model.iface2.LldbModelTargetDebugContainer;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetThread;
import agent.lldb.model.impl.LldbModelImpl;
import agent.lldb.model.impl.LldbModelTargetAbstractXpointSpec;
import agent.lldb.model.impl.LldbModelTargetBreakpointSpecImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetWatchpointSpecImpl;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="BreakpointContainer", elements={@TargetElementType(type=LldbModelTargetAbstractXpointSpec.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class LldbModelTargetBreakpointContainerImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetBreakpointContainer {
    protected static final TargetBreakpointSpecContainer.TargetBreakpointKindSet SUPPORTED_KINDS = TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE, TargetBreakpointSpec.TargetBreakpointKind.READ, TargetBreakpointSpec.TargetBreakpointKind.WRITE});
    private final SBTarget session;

    public LldbModelTargetBreakpointContainerImpl(LldbModelTargetDebugContainer debug, SBTarget session) {
        super(debug.getModel(), (TargetObject)debug, "Breakpoints", "BreakpointContainer");
        this.session = session;
        this.getManager().addEventsListener(this);
        this.changeAttributes(List.of(), List.of(), Map.of("_supported_breakpoint_kinds", SUPPORTED_KINDS), "Initialized");
    }

    @Override
    public void breakpointCreated(Object info, LldbCause cause) {
        LldbModelTargetBreakpointSpec spec = this.getTargetBreakpointSpec(info);
        spec.updateInfo(info, "Created");
        this.changeElements(List.of(), List.of(this.getTargetBreakpointSpec(info)), Map.of(), "Created");
    }

    @Override
    public void breakpointModified(Object info, LldbCause cause) {
        this.getTargetBreakpointSpec(info).updateInfo(info, "Modified");
    }

    @Override
    public void breakpointDeleted(Object info, LldbCause cause) {
        LldbModelImpl impl = (LldbModelImpl)this.model;
        impl.deleteModelObject(info);
        this.changeElements(List.of(DebugClient.getId(this.getModelObject())), List.of(), Map.of(), "Deleted");
    }

    @Override
    public void breakpointHit(Object obj, LldbCause cause) {
        SBBreakpoint bpt = (SBBreakpoint)obj;
        SBProcess eventProcess = this.getManager().getEventProcess();
        long nthreads = eventProcess.GetNumThreads();
        int i = 0;
        while ((long)i < nthreads) {
            SBThread t = eventProcess.GetThreadAtIndex((long)i);
            StopReason reason = t.GetStopReason();
            if (reason.equals(StopReason.eStopReasonBreakpoint)) {
                BigInteger bptId = t.GetStopReasonDataAtIndex(0L);
                BigInteger locId = t.GetStopReasonDataAtIndex(1L);
                if (bpt.GetID() == bptId.intValue()) {
                    LldbModelTargetProcess targetProcess = (LldbModelTargetProcess)this.getModel().getModelObject(eventProcess);
                    LldbModelTargetThread targetThread = targetProcess.getThreads().getTargetThread(t);
                    LldbModelTargetBreakpointSpec spec = this.getTargetBreakpointSpec(bpt);
                    if (spec == null) {
                        Msg.error((Object)this, (Object)("Stopped for breakpoint unknown to the agent: " + bpt + " (pc=" + targetThread + ")"));
                        return;
                    }
                    LldbModelTargetBreakpointLocation loc = spec.findLocation(locId);
                    if (loc == null) {
                        Msg.warn((Object)this, (Object)("Stopped for a breakpoint whose location is unknown to the agent: " + spec));
                    }
                    ((DebuggerModelListener)this.listeners.fire).breakpointHit((TargetObject)this, (TargetObject)targetThread, null, (TargetBreakpointSpec)spec, (TargetBreakpointLocation)loc);
                }
            }
            ++i;
        }
    }

    public LldbModelTargetBreakpointSpec getTargetBreakpointSpec(Object bpt) {
        TargetObject targetObject = this.getMapObject(bpt);
        if (targetObject != null) {
            LldbModelTargetBreakpointSpec spec = (LldbModelTargetBreakpointSpec)targetObject;
            spec.setModelObject(bpt);
            return spec;
        }
        if (bpt instanceof SBBreakpoint) {
            return new LldbModelTargetBreakpointSpecImpl(this, bpt);
        }
        return new LldbModelTargetWatchpointSpecImpl(this, bpt);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listBreakpoints(this.getSession()).thenAccept(byNumber -> {
            List specs;
            LldbModelTargetBreakpointContainerImpl lldbModelTargetBreakpointContainerImpl = this;
            synchronized (lldbModelTargetBreakpointContainerImpl) {
                specs = byNumber.values().stream().map(this::getTargetBreakpointSpec).collect(Collectors.toList());
            }
            this.setElements(specs, Map.of(), "Refreshed");
        });
    }

    @Override
    public SBTarget getSession() {
        return this.session;
    }
}

