/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBMemoryRegionInfo;
import SWIG.SBStream;
import agent.lldb.model.iface2.LldbModelTargetMemoryContainer;
import agent.lldb.model.iface2.LldbModelTargetMemoryRegion;
import agent.lldb.model.impl.LldbModelTargetMemoryContainerImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="MemoryRegion", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="_memory", type=LldbModelTargetMemoryContainerImpl.class), @TargetAttributeType(name="RegionBase", type=Address.class), @TargetAttributeType(name="RegionEnd", type=Address.class), @TargetAttributeType(name="RegionSize", type=String.class), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetMemoryRegionImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetMemoryRegion {
    protected AddressRange range;
    protected List<String> protect;
    protected List<String> allocProtect;
    private boolean isRead;
    private boolean isWrite;
    private boolean isExec;

    protected static String keySection(SBMemoryRegionInfo region) {
        return PathUtils.makeKey((String)region.GetRegionBase().toString(16));
    }

    public LldbModelTargetMemoryRegionImpl(LldbModelTargetMemoryContainer memory, SBMemoryRegionInfo region) {
        super(memory.getModel(), (TargetObject)memory, LldbModelTargetMemoryRegionImpl.keySection(region), region, "Region");
        this.changeAttributes(List.of(), List.of(), Map.of("_memory", memory, "_readable", region.IsReadable(), "_writable", region.IsWritable(), "_executable", region.IsExecutable()), "Initialized");
        this.range = this.doGetRange(region);
        if (this.range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_range", this.range, "RegionBase", this.range.getMinAddress(), "RegionEnd", this.range.getMaxAddress(), "RegionSize", Long.toHexString(this.range.getMaxAddress().subtract(this.range.getMinAddress()) + 1L)), "Initialized");
        }
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBMemoryRegionInfo region = (SBMemoryRegionInfo)this.getModelObject();
        region.GetDescription(stream);
        return stream.GetData();
    }

    protected AddressRange doGetRange(SBMemoryRegionInfo s) {
        AddressSpace addressSpace = this.getModel().getAddressSpace("ram");
        Address min = addressSpace.getAddress(s.GetRegionBase().longValue());
        Address max = addressSpace.getAddress(s.GetRegionEnd().longValue() - 1L);
        return max.getOffset() > min.getOffset() ? new AddressRangeImpl(min, max) : new AddressRangeImpl(min, min);
    }

    @Override
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    public boolean isReadable() {
        return this.isRead;
    }

    @Override
    public boolean isWritable() {
        return this.isWrite;
    }

    @Override
    public boolean isExecutable() {
        return this.isExec;
    }

    public boolean isSame(SBMemoryRegionInfo section) {
        return this.range.equals(this.doGetRange(section));
    }
}

