/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class AbstractMsfFreePageMap {
    private List<Integer> map = new ArrayList<Integer>();
    protected static final int MAP_FIELD_SIZE = 4;
    protected AbstractMsf msf;

    AbstractMsfFreePageMap(AbstractMsf msf) {
        this.msf = msf;
    }

    String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("------------------------------------------------------------");
        builder.append("\npageSize: ");
        builder.append(this.msf.getPageSize());
        builder.append("\nMSFHeaderBig: ");
        builder.append(this.isBig());
        for (int i = 0; i < this.map.size(); ++i) {
            builder.append(String.format("\n[%d]: ", i));
            builder.append(this.map.get(i));
        }
        builder.append("\n------------------------------------------------------------");
        return builder.toString();
    }

    abstract void deserialize(TaskMonitor var1) throws IOException, CancelledException;

    abstract boolean isBig();

    protected void addMap(byte[] bytes, TaskMonitor monitor) throws CancelledException {
        for (int index = 0; index < bytes.length - 4; index += 4) {
            monitor.checkCanceled();
            byte[] selectedBytes = Arrays.copyOfRange(bytes, index, index + 4);
            this.map.add(LittleEndianDataConverter.INSTANCE.getInt(selectedBytes));
        }
    }
}

