/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractMsfStreamTable {
    protected AbstractMsf msf;
    protected List<MsfStream> mapStreamNumberToStream;

    AbstractMsfStreamTable(AbstractMsf msf) {
        this.msf = msf;
        this.mapStreamNumberToStream = new ArrayList<MsfStream>();
    }

    int getNumStreams() {
        return this.mapStreamNumberToStream.size();
    }

    MsfStream getStream(int streamNumber) {
        return this.mapStreamNumberToStream.get(streamNumber);
    }

    void deserialize(MsfStream directoryStream, TaskMonitor monitor) throws IOException, PdbException, CancelledException {
        int streamNum;
        int length = directoryStream.getLength();
        byte[] bytes = directoryStream.read(0, length, monitor);
        PdbByteReader reader = new PdbByteReader(bytes);
        int numStreams = reader.parseInt();
        this.checkMaxStreamsExceeded(numStreams);
        for (streamNum = 0; streamNum < numStreams; ++streamNum) {
            monitor.checkCanceled();
            int streamLength = reader.parseInt();
            this.parseExtraField(reader);
            MsfStream stream = new MsfStream(this.msf, streamLength);
            this.mapStreamNumberToStream.add(stream);
        }
        for (streamNum = 0; streamNum < numStreams; ++streamNum) {
            monitor.checkCanceled();
            MsfStream stream = this.mapStreamNumberToStream.get(streamNum);
            if (stream == null) continue;
            stream.deserializePageNumbers(reader, monitor);
        }
        this.setStream(this.msf.getDirectoryStreamNumber(), directoryStream, monitor);
    }

    void setStream(int index, MsfStream stream, TaskMonitor monitor) throws CancelledException {
        if (index < this.mapStreamNumberToStream.size()) {
            this.mapStreamNumberToStream.set(index, stream);
        } else {
            for (int i = this.mapStreamNumberToStream.size(); i < index; ++i) {
                monitor.checkCanceled();
                this.mapStreamNumberToStream.add(null);
            }
            this.mapStreamNumberToStream.add(stream);
        }
    }

    private void checkMaxStreamsExceeded(int numStreams) throws PdbException {
        if (numStreams >= this.getMaxNumStreamsAllowed()) {
            throw new PdbException(String.format("Maximum number of MsfStream exceeded (0X%X >= 0X%X)", numStreams, this.getMaxNumStreamsAllowed()));
        }
    }

    protected abstract void parseExtraField(PdbByteReader var1) throws PdbException;

    protected abstract int getMaxNumStreamsAllowed();
}

