/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.HLSLRegisterType;

public abstract class DataHighLevelShaderLanguageSymbolInternals
extends AbstractSymbolInternals {
    protected RecordNumber typeRecordNumber;
    protected long dataOffset;
    protected HLSLRegisterType registerType;
    protected String name;

    public static DataHighLevelShaderLanguageSymbolInternals parse(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        DataHighLevelShaderLanguageSymbolInternals32 result = new DataHighLevelShaderLanguageSymbolInternals32(pdb);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.registerType = HLSLRegisterType.fromValue(reader.parseUnsignedShortVal());
        result.dataSlot = reader.parseUnsignedShortVal();
        result.dataOffset = reader.parseUnsignedShortVal();
        result.textureSlotStart = reader.parseUnsignedShortVal();
        result.samplerSlotStart = reader.parseUnsignedShortVal();
        result.uavSlotStart = reader.parseUnsignedShortVal();
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        return result;
    }

    public static DataHighLevelShaderLanguageSymbolInternals parse32(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        DataHighLevelShaderLanguageSymbolInternals32 result = new DataHighLevelShaderLanguageSymbolInternals32(pdb);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.dataSlot = reader.parseUnsignedIntVal();
        result.dataOffset = reader.parseUnsignedIntVal();
        result.textureSlotStart = reader.parseUnsignedIntVal();
        result.samplerSlotStart = reader.parseUnsignedIntVal();
        result.uavSlotStart = reader.parseUnsignedIntVal();
        result.registerType = HLSLRegisterType.fromValue(reader.parseUnsignedShortVal());
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        return result;
    }

    public static DataHighLevelShaderLanguageSymbolInternals parse32Ext(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        DataHighLevelShaderLanguageSymbolInternals32Extended result = new DataHighLevelShaderLanguageSymbolInternals32Extended(pdb);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.registerIndex = reader.parseUnsignedIntVal();
        result.dataOffset = reader.parseUnsignedIntVal();
        result.bindSpace = reader.parseUnsignedIntVal();
        result.bindSlot = reader.parseUnsignedIntVal();
        result.registerType = HLSLRegisterType.fromValue(reader.parseUnsignedShortVal());
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        return result;
    }

    public DataHighLevelShaderLanguageSymbolInternals(AbstractPdb pdb) {
        super(pdb);
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public HLSLRegisterType getRegisterType() {
        return this.registerType;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public String getName() {
        return this.name;
    }

    public static class DataHighLevelShaderLanguageSymbolInternals32Extended
    extends DataHighLevelShaderLanguageSymbolInternals {
        protected long registerIndex;
        protected long bindSpace;
        protected long bindSlot;

        public DataHighLevelShaderLanguageSymbolInternals32Extended(AbstractPdb pdb) {
            super(pdb);
        }

        public long getRegisterIndex() {
            return this.registerIndex;
        }

        public long getBindSpace() {
            return this.bindSpace;
        }

        public long getBindSlot() {
            return this.bindSlot;
        }

        @Override
        public void emit(StringBuilder builder) {
            builder.append(String.format(": Type: %s. %s\n", this.pdb.getTypeRecord(this.typeRecordNumber), this.getRegisterType().toString()));
            builder.append(String.format("   register index = %d, base data offset start = %d, bind space = %d, bind slot = %d\n", this.registerIndex, this.dataOffset, this.bindSpace, this.bindSlot));
        }
    }

    public static class DataHighLevelShaderLanguageSymbolInternals32
    extends DataHighLevelShaderLanguageSymbolInternals {
        protected long dataSlot;
        protected long textureSlotStart;
        protected long samplerSlotStart;
        protected long uavSlotStart;

        public DataHighLevelShaderLanguageSymbolInternals32(AbstractPdb pdb) {
            super(pdb);
        }

        public long getDataSlot() {
            return this.dataSlot;
        }

        public long getTextureSlotStart() {
            return this.textureSlotStart;
        }

        public long getSamplerSlotStart() {
            return this.samplerSlotStart;
        }

        public long getUavSlotStart() {
            return this.uavSlotStart;
        }

        @Override
        public void emit(StringBuilder builder) {
            builder.append(String.format(": Type: %s. %s\n", this.pdb.getTypeRecord(this.typeRecordNumber), this.getRegisterType().toString()));
            builder.append(String.format("   base data: slot = %d offset = %d, texture slot = %d, sampler slot = %d, UAV slot = %d\n", this.dataSlot, this.dataOffset, this.textureSlotStart, this.samplerSlotStart, this.uavSlotStart));
        }
    }
}

