/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import db.BinaryField;
import db.ByteField;
import db.DBRecord;
import db.StringField;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStoreFactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public enum DBTraceUtils {


    public static long lowerEndpoint(Range<Long> range) {
        if (!range.hasLowerBound()) {
            return Long.MIN_VALUE;
        }
        if (range.lowerBoundType() == BoundType.CLOSED) {
            return (Long)range.lowerEndpoint();
        }
        return (Long)range.lowerEndpoint() + 1L;
    }

    public static long upperEndpoint(Range<Long> range) {
        if (!range.hasUpperBound()) {
            return Long.MAX_VALUE;
        }
        if (range.upperBoundType() == BoundType.CLOSED) {
            return (Long)range.upperEndpoint();
        }
        return (Long)range.upperEndpoint() - 1L;
    }

    public static Range<Long> toRange(long lowerEndpoint, long upperEndpoint) {
        if (lowerEndpoint == Long.MIN_VALUE && upperEndpoint == Long.MAX_VALUE) {
            return Range.all();
        }
        if (lowerEndpoint == Long.MIN_VALUE) {
            return Range.atMost((Comparable)Long.valueOf(upperEndpoint));
        }
        if (upperEndpoint == Long.MAX_VALUE) {
            return Range.atLeast((Comparable)Long.valueOf(lowerEndpoint));
        }
        return Range.closed((Comparable)Long.valueOf(lowerEndpoint), (Comparable)Long.valueOf(upperEndpoint));
    }

    public static Range<Long> toRange(long snap) {
        return DBTraceUtils.toRange(snap, Long.MAX_VALUE);
    }

    public static <T extends Comparable<T>> boolean intersect(Range<T> a, Range<T> b) {
        return a.isConnected(b) && !a.intersection(b).isEmpty();
    }

    public static <C extends Comparable<C>> int compareRanges(Range<C> a, Range<C> b) {
        int result;
        if (!a.hasLowerBound() && b.hasLowerBound()) {
            return -1;
        }
        if (!b.hasLowerBound() && a.hasLowerBound()) {
            return 1;
        }
        if (a.hasLowerBound()) {
            result = a.lowerEndpoint().compareTo(b.lowerEndpoint());
            if (result != 0) {
                return result;
            }
            if (a.lowerBoundType() == BoundType.CLOSED && b.lowerBoundType() == BoundType.OPEN) {
                return -1;
            }
            if (b.lowerBoundType() == BoundType.CLOSED && a.lowerBoundType() == BoundType.OPEN) {
                return 1;
            }
        }
        if (!a.hasUpperBound() && b.hasUpperBound()) {
            return 1;
        }
        if (!b.hasUpperBound() && a.hasUpperBound()) {
            return -1;
        }
        if (a.hasUpperBound()) {
            result = a.upperEndpoint().compareTo(b.upperEndpoint());
            if (result != 0) {
                return result;
            }
            if (a.upperBoundType() == BoundType.CLOSED && b.upperBoundType() == BoundType.OPEN) {
                return 1;
            }
            if (b.upperBoundType() == BoundType.CLOSED && a.upperBoundType() == BoundType.OPEN) {
                return -1;
            }
        }
        return 0;
    }

    public static String tableName(String baseName, AddressSpace space, long threadKey, int frameLevel) {
        if (space.isRegisterSpace()) {
            if (frameLevel == 0) {
                return baseName + "_" + space.getName() + "_" + threadKey;
            }
            return baseName + "_" + space.getName() + "_" + threadKey + "_" + frameLevel;
        }
        return baseName + "_" + space.getName();
    }

    public static <DR extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<?>> void makeWay(DR data, Range<Long> span, BiConsumer<? super DR, Range<Long>> lifespanSetter, Consumer<? super DR> deleter) {
        if (span.contains((Comparable)data.getY1())) {
            deleter.accept(data);
            return;
        }
        lifespanSetter.accept(data, DBTraceUtils.toRange(data.getY1(), DBTraceUtils.lowerEndpoint(span) - 1L));
    }

    public static <T> Iterator<T> covariantIterator(Iterator<? extends T> it) {
        return it;
    }

    public static Iterator<Long> iterateSpan(final Range<Long> span) {
        return new Iterator<Long>(){
            final long end;
            long val;
            {
                this.end = DBTraceUtils.upperEndpoint((Range<Long>)span);
                this.val = DBTraceUtils.lowerEndpoint((Range<Long>)span);
            }

            @Override
            public boolean hasNext() {
                return this.val <= this.end;
            }

            @Override
            public Long next() {
                long next = this.val++;
                return next;
            }
        };
    }

    public static AddressSetView getAddressSet(AddressFactory factory, Address start, boolean forward) {
        AddressSet all = factory.getAddressSet();
        if (forward) {
            Address max = all.getMaxAddress();
            return factory.getAddressSet(start, max);
        }
        Address min = all.getMinAddress();
        return factory.getAddressSet(min, start);
    }

    public static AddressRange toRange(Address min, Address max) {
        if (min.compareTo((Object)max) > 0) {
            throw new IllegalArgumentException("min must precede max");
        }
        return new AddressRangeImpl(min, max);
    }

    public static class RefTypeDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<RefType, OT, ByteField> {
        public RefTypeDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(RefType.class, objectType, ByteField.class, field, column);
        }

        protected byte encode(RefType value) {
            return value == null ? (byte)-128 : (byte)value.getValue();
        }

        protected RefType decode(byte enc) {
            return enc == -128 ? null : RefTypeFactory.get((byte)enc);
        }

        public void store(RefType value, ByteField f) {
            f.setByteValue(this.encode(value));
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setByteValue(this.column, this.encode((RefType)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue((DBAnnotatedObject)obj, this.decode(record.getByteValue(this.column)));
        }
    }

    public static class OffsetThenSnapDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractOffsetSnapDBFieldCodec<OT> {
        public OffsetThenSnapDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(objectType, field, column);
        }

        @Override
        protected byte[] encode(OffsetSnap value) {
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.putLong(value.offset);
            buf.putLong(value.snap ^ Long.MIN_VALUE);
            return buf.array();
        }

        @Override
        protected OffsetSnap decode(byte[] arr) {
            ByteBuffer buf = ByteBuffer.wrap(arr);
            long offset = buf.getLong();
            long snap = buf.getLong() ^ Long.MIN_VALUE;
            return new OffsetSnap(offset, snap);
        }
    }

    public static abstract class AbstractOffsetSnapDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<OffsetSnap, OT, BinaryField> {
        public AbstractOffsetSnapDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(OffsetSnap.class, objectType, BinaryField.class, field, column);
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            OffsetSnap value = (OffsetSnap)this.getValue((DBAnnotatedObject)obj);
            if (value == null) {
                record.setBinaryData(this.column, null);
            } else {
                record.setBinaryData(this.column, this.encode(value));
            }
        }

        public void store(OffsetSnap value, BinaryField f) {
            if (value == null) {
                f.setBinaryData(null);
            } else {
                f.setBinaryData(this.encode(value));
            }
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            byte[] data = record.getBinaryData(this.column);
            if (data == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            } else {
                this.setValue((DBAnnotatedObject)obj, this.decode(data));
            }
        }

        protected abstract byte[] encode(OffsetSnap var1);

        protected abstract OffsetSnap decode(byte[] var1);
    }

    public static class LanguageIDDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<LanguageID, OT, StringField> {
        public LanguageIDDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(LanguageID.class, objectType, StringField.class, field, column);
        }

        public void store(LanguageID value, StringField f) {
            f.setString(value == null ? null : value.getIdAsString());
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            LanguageID id = (LanguageID)this.getValue((DBAnnotatedObject)obj);
            if (id == null) {
                record.setString(this.column, null);
            } else {
                record.setString(this.column, id.getIdAsString());
            }
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            String id = record.getString(this.column);
            if (id == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            } else {
                this.setValue((DBAnnotatedObject)obj, new LanguageID(id));
            }
        }
    }

    public static class URLDBFieldCodec<OT extends DBAnnotatedObject>
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<URL, OT, StringField> {
        public URLDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(URL.class, objectType, StringField.class, field, column);
        }

        protected String encode(URL url) {
            if (url == null) {
                return null;
            }
            return url.toString();
        }

        public void store(URL value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setString(this.column, this.encode((URL)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            try {
                String data = record.getString(this.column);
                if (data == null) {
                    this.setValue((DBAnnotatedObject)obj, null);
                } else {
                    this.setValue((DBAnnotatedObject)obj, new URL(data));
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class OffsetSnap {
        public final long offset;
        public final long snap;

        public OffsetSnap(long offset, long snap) {
            this.offset = offset;
            this.snap = snap;
        }

        public String toString() {
            return String.format("%d,%08x", this.snap, this.offset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OffsetSnap)) {
                return false;
            }
            OffsetSnap that = (OffsetSnap)obj;
            if (this.offset != that.offset) {
                return false;
            }
            return this.snap == that.snap;
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.snap);
        }
    }
}

