/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.listing;

import com.google.common.collect.Range;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.listing.TraceBaseDefinedRegisterView;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceDefinedDataView;
import ghidra.trace.util.TraceRegisterUtils;

public interface TraceDefinedDataRegisterView
extends TraceDefinedDataView,
TraceBaseDefinedRegisterView<TraceData> {
    default public TraceData create(Range<Long> lifespan, Register register, DataType dataType) throws CodeUnitInsertionException {
        Trace trace = this.getThread().getTrace();
        if (register.getAddressSpace() != trace.getBaseLanguage().getAddressFactory().getRegisterSpace()) {
            return trace.getCodeManager().definedData().create(lifespan, register.getAddress(), dataType, register.getNumBytes());
        }
        TraceRegisterUtils.requireByteBound(register);
        return this.create(lifespan, register.getAddress(), dataType, register.getNumBytes());
    }
}

