/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CaptureFunctionDataTypesListener;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class CaptureFunctionDataTypesCmd
extends BackgroundCommand {
    private Program program;
    private DataTypeManager dtm;
    private AddressSetView set;
    private CaptureFunctionDataTypesListener listener;

    public CaptureFunctionDataTypesCmd(DataTypeManager dtm, AddressSetView set, CaptureFunctionDataTypesListener listener) {
        super("Capture Function Data Types", true, false, false);
        this.dtm = dtm;
        this.set = set;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        monitor.setMessage("Capturing Function Data Types");
        boolean success = false;
        int transactionID = this.dtm.startTransaction("Capture function data types");
        CategoryPath category = new CategoryPath(CategoryPath.ROOT, new String[]{"_CAPTURED_FROM_" + this.program.getName()});
        try {
            FunctionManager functionManager = this.program.getFunctionManager();
            FunctionIterator functions = functionManager.getFunctions(this.set, true);
            while (functions.hasNext()) {
                monitor.checkCanceled();
                Function function = (Function)functions.next();
                FunctionSignature signature = function.getSignature(true);
                FunctionDefinitionDataType functionDef = new FunctionDefinitionDataType(category, signature.getName(), signature);
                this.dtm.resolve((DataType)functionDef, null);
            }
            success = true;
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.dtm.endTransaction(transactionID, success);
        }
        return success;
    }

    public void taskCompleted() {
        this.listener.captureFunctionDataTypesCompleted(this);
        super.taskCompleted();
    }
}

