/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import ghidra.app.plugin.core.compositeeditor.BitFieldEditorDialog;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;

public class EditBitFieldAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Edit Bitfield";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Edit an existing bitfield";
    private static String[] POPUP_PATH = new String[]{"Edit Bitfield"};

    public EditBitFieldAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Edit Bitfield", GROUP_NAME, POPUP_PATH, null, null);
        this.setDescription(DESCRIPTION);
        if (!(this.model instanceof CompEditorModel)) {
            throw new AssertException("unsupported use");
        }
        this.adjustEnablement();
    }

    private DataTypeComponent getUnalignedBitFieldComponent() {
        DataTypeComponent dtComponent;
        int rowIndex;
        CompEditorModel editorModel = (CompEditorModel)this.model;
        if (editorModel.viewComposite instanceof Structure && !editorModel.viewComposite.isPackingEnabled() && editorModel.getNumSelectedRows() == 1 && (rowIndex = this.model.getSelectedRows()[0]) < this.model.getNumComponents() && (dtComponent = this.model.getComponent(rowIndex)).isBitFieldComponent()) {
            return dtComponent;
        }
        return null;
    }

    public void actionPerformed(ActionContext context) {
        CompEditorModel editorModel = (CompEditorModel)this.model;
        DataTypeComponent dtComponent = this.getUnalignedBitFieldComponent();
        if (dtComponent == null) {
            return;
        }
        BitFieldEditorDialog dlg = new BitFieldEditorDialog(editorModel.viewComposite, this.provider.dtmService, dtComponent.getOrdinal(), this.model.showHexNumbers, ordinal -> this.refreshTableAndSelection(editorModel, ordinal));
        JComponent c = this.provider.getComponent();
        DockingWindowManager.showDialog((Component)c, (DialogComponentProvider)dlg);
        this.requestTableFocus();
    }

    private void refreshTableAndSelection(CompEditorModel editorModel, int ordinal) {
        editorModel.fireTableDataChanged();
        editorModel.compositeInfoChanged();
        JTable editorTable = this.provider.getTable();
        editorTable.getSelectionModel().setSelectionInterval(ordinal, ordinal);
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.getUnalignedBitFieldComponent() != null);
    }
}

