/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.event.mouse.GMouseListenerAdapter;
import docking.menu.MultiActionDockingAction;
import docking.widgets.OptionDialog;
import docking.widgets.PopupWindow;
import docking.widgets.textpane.GHtmlTextPane;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.support.GTreeSelectionEvent;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.NextPreviousDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.ApplyEnumsAsLabelsAction;
import ghidra.app.plugin.core.datamgr.actions.ApplyFunctionDataTypesAction;
import ghidra.app.plugin.core.datamgr.actions.CaptureFunctionDataTypesAction;
import ghidra.app.plugin.core.datamgr.actions.ClearCutAction;
import ghidra.app.plugin.core.datamgr.actions.CloseArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.CollapseAllArchivesAction;
import ghidra.app.plugin.core.datamgr.actions.CommitSingleDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.ConflictHandlerModesAction;
import ghidra.app.plugin.core.datamgr.actions.CopyAction;
import ghidra.app.plugin.core.datamgr.actions.CreateArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.CreateCategoryAction;
import ghidra.app.plugin.core.datamgr.actions.CreateDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.CreateEnumAction;
import ghidra.app.plugin.core.datamgr.actions.CreateEnumFromSelectionAction;
import ghidra.app.plugin.core.datamgr.actions.CreateFunctionDefinitionAction;
import ghidra.app.plugin.core.datamgr.actions.CreatePointerAction;
import ghidra.app.plugin.core.datamgr.actions.CreateProjectArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.CreateStructureAction;
import ghidra.app.plugin.core.datamgr.actions.CreateTypeDefAction;
import ghidra.app.plugin.core.datamgr.actions.CreateTypeDefFromDialogAction;
import ghidra.app.plugin.core.datamgr.actions.CreateUnionAction;
import ghidra.app.plugin.core.datamgr.actions.CutAction;
import ghidra.app.plugin.core.datamgr.actions.DeleteAction;
import ghidra.app.plugin.core.datamgr.actions.DeleteArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.DisassociateDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.DisplayTypeAsGraphAction;
import ghidra.app.plugin.core.datamgr.actions.EditAction;
import ghidra.app.plugin.core.datamgr.actions.EditArchivePathAction;
import ghidra.app.plugin.core.datamgr.actions.ExpandAllAction;
import ghidra.app.plugin.core.datamgr.actions.ExportToHeaderAction;
import ghidra.app.plugin.core.datamgr.actions.FilterArraysAction;
import ghidra.app.plugin.core.datamgr.actions.FilterPointersAction;
import ghidra.app.plugin.core.datamgr.actions.FindBaseDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.FindDataTypesByNameAction;
import ghidra.app.plugin.core.datamgr.actions.FindDataTypesBySizeAction;
import ghidra.app.plugin.core.datamgr.actions.FindReferencesToDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.FindReferencesToFieldAction;
import ghidra.app.plugin.core.datamgr.actions.FindStructuresByOffsetAction;
import ghidra.app.plugin.core.datamgr.actions.FindStructuresBySizeAction;
import ghidra.app.plugin.core.datamgr.actions.IncludeDataTypesInFilterAction;
import ghidra.app.plugin.core.datamgr.actions.LockArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.OpenArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.OpenProjectArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.PasteAction;
import ghidra.app.plugin.core.datamgr.actions.PreviewWindowAction;
import ghidra.app.plugin.core.datamgr.actions.RemoveInvalidArchiveFromProgramAction;
import ghidra.app.plugin.core.datamgr.actions.RenameAction;
import ghidra.app.plugin.core.datamgr.actions.RevertDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.SaveArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.SetFavoriteDataTypeAction;
import ghidra.app.plugin.core.datamgr.actions.UnlockArchiveAction;
import ghidra.app.plugin.core.datamgr.actions.UpdateSingleDataTypeAction;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.datatype.DataTypeUrl;
import ghidra.framework.main.datatree.ArchiveProvider;
import ghidra.framework.main.datatree.VersionControlDataTypeArchiveUndoCheckoutAction;
import ghidra.framework.main.projectdata.actions.VersionControlAddAction;
import ghidra.framework.main.projectdata.actions.VersionControlCheckInAction;
import ghidra.framework.main.projectdata.actions.VersionControlCheckOutAction;
import ghidra.framework.main.projectdata.actions.VersionControlShowHistoryAction;
import ghidra.framework.main.projectdata.actions.VersionControlUpdateAction;
import ghidra.framework.main.projectdata.actions.VersionControlViewCheckOutAction;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import resources.ResourceManager;
import util.HistoryList;

public class DataTypesProvider
extends ComponentProviderAdapter {
    private static final String DATA_TYPES_ICON = "images/dataTypes.png";
    private static final String TITLE = "Data Type Manager";
    private static final String POINTER_FILTER_STATE = "PointerFilterState";
    private static final String ARRAY_FILTER_STATE = "ArrayFilterState";
    private static final String CONFLICT_RESOLUTION_MODE = "ConflictResolutionMode";
    private static final String PREVIEW_WINDOW_STATE = "PreviewWindowState";
    private static final String INCLUDE_DATA_MEMBERS_IN_SEARCH = "DataMembersInSearchState";
    private JSplitPane splitPane;
    private int defaultDividerSize;
    private JScrollPane previewScrollPane;
    private JTextPane previewPane;
    private GTreeNode lastPreviewNode;
    private SwingUpdateManager previewUpdateManager = new SwingUpdateManager(100, () -> this.updatePreviewPane());
    private DataTypeArchiveGTree archiveGTree;
    private HelpLocation helpLocation;
    private DataTypeManagerPlugin plugin;
    private HistoryList<DataTypeUrl> navigationHistory = new HistoryList(15, url -> {
        DataType dt = url.getDataType(this.plugin);
        this.setDataTypeSelected(dt);
    });
    private MultiActionDockingAction nextAction;
    private MultiActionDockingAction previousAction;
    private ConflictHandlerModesAction conflictHandlerModesAction;
    private ToggleDockingAction filterArraysAction;
    private ToggleDockingAction filterPointersAction;
    private ToggleDockingAction previewWindowAction;
    private ToggleDockingAction includeDataMembersInSearchAction;
    private boolean includeDataMembersInFilter;

    public DataTypesProvider(DataTypeManagerPlugin plugin, String providerName) {
        super(plugin.getTool(), providerName, plugin.getName(), DataTypesActionContext.class);
        this.plugin = plugin;
        this.setTitle(TITLE);
        this.setIcon(ResourceManager.loadImage((String)DATA_TYPES_ICON));
        this.addToToolbar();
        this.navigationHistory.setAllowDuplicates(true);
        this.buildComponent();
        this.helpLocation = new HelpLocation(plugin.getName(), "Data_Type_Manager");
        this.addToTool();
        this.createLocalActions();
    }

    private void createLocalActions() {
        this.tool.setMenuGroup(new String[]{"New"}, "Create");
        this.addLocalAction((DockingActionIf)new CreateCategoryAction(this.plugin));
        CreateDataTypeAction action = new CreateStructureAction(this.plugin);
        action.setEnabled(false);
        this.addLocalAction((DockingActionIf)action);
        action = new CreateUnionAction(this.plugin);
        action.setEnabled(false);
        this.addLocalAction((DockingActionIf)action);
        action = new CreateEnumAction(this.plugin);
        action.setEnabled(false);
        this.addLocalAction((DockingActionIf)action);
        action = new CreateFunctionDefinitionAction(this.plugin);
        action.setEnabled(false);
        this.addLocalAction((DockingActionIf)action);
        this.addLocalAction((DockingActionIf)new CreateTypeDefAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CreateTypeDefFromDialogAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CreatePointerAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CutAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CopyAction(this.plugin));
        this.addLocalAction((DockingActionIf)new PasteAction(this.plugin));
        this.addLocalAction((DockingActionIf)new DeleteAction(this.plugin));
        this.addLocalAction((DockingActionIf)new DeleteArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new RenameAction(this.plugin));
        this.addLocalAction((DockingActionIf)new EditAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CreateEnumFromSelectionAction(this.plugin));
        this.addLocalAction((DockingActionIf)new SaveArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CloseArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new RemoveInvalidArchiveFromProgramAction(this.plugin));
        this.addLocalAction((DockingActionIf)new LockArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new UnlockArchiveAction(this.plugin));
        this.addVersionControlActions();
        this.addLocalAction((DockingActionIf)new CollapseAllArchivesAction(this.plugin));
        this.addLocalAction((DockingActionIf)new ExpandAllAction(this.plugin));
        this.addLocalAction((DockingActionIf)new FindDataTypesByNameAction(this.plugin, "1"));
        this.addLocalAction((DockingActionIf)new FindDataTypesBySizeAction(this.plugin, "2"));
        this.addLocalAction((DockingActionIf)new FindStructuresByOffsetAction(this.plugin, "3"));
        this.addLocalAction((DockingActionIf)new FindStructuresBySizeAction(this.plugin, "4"));
        this.includeDataMembersInSearchAction = new IncludeDataTypesInFilterAction(this.plugin, this, "5");
        this.addLocalAction((DockingActionIf)this.includeDataMembersInSearchAction);
        this.addLocalAction((DockingActionIf)new ApplyFunctionDataTypesAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CaptureFunctionDataTypesAction(this.plugin));
        this.addLocalAction((DockingActionIf)new SetFavoriteDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new ExportToHeaderAction(this.plugin));
        this.addLocalAction((DockingActionIf)new ApplyEnumsAsLabelsAction(this.plugin));
        this.addLocalAction((DockingActionIf)new FindReferencesToDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new FindReferencesToFieldAction(this.plugin));
        this.addLocalAction((DockingActionIf)new FindBaseDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new DisplayTypeAsGraphAction(this.plugin));
        this.previousAction = new NextPreviousDataTypeAction(this, this.plugin.getName(), false);
        this.addLocalAction((DockingActionIf)this.previousAction);
        this.nextAction = new NextPreviousDataTypeAction(this, this.plugin.getName(), true);
        this.addLocalAction((DockingActionIf)this.nextAction);
        this.filterArraysAction = this.getFilterArraysAction();
        this.addLocalAction((DockingActionIf)this.filterArraysAction);
        this.filterPointersAction = this.getFilterPointersAction();
        this.addLocalAction((DockingActionIf)this.filterPointersAction);
        this.conflictHandlerModesAction = this.getConflictHandlerModesAction();
        this.addLocalAction((DockingActionIf)this.conflictHandlerModesAction);
        this.addLocalAction((DockingActionIf)new OpenArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new OpenProjectArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CreateArchiveAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CreateProjectArchiveAction(this.plugin));
        ToggleDockingAction previewAction = this.getPreviewWindowAction();
        this.addLocalAction((DockingActionIf)previewAction);
        this.addLocalAction((DockingActionIf)new ClearCutAction(this.plugin));
        this.addLocalAction((DockingActionIf)new CommitSingleDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new UpdateSingleDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new RevertDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new DisassociateDataTypeAction(this.plugin));
        this.addLocalAction((DockingActionIf)new EditArchivePathAction(this.plugin));
    }

    private void addVersionControlActions() {
        ArchiveProvider archiveProvider = () -> {
            TreePath[] selectionPaths = this.archiveGTree.getSelectionPaths();
            ArrayList<ProjectArchive> selectedArchives = new ArrayList<ProjectArchive>();
            for (TreePath path : selectionPaths) {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof ProjectArchiveNode)) continue;
                ProjectArchiveNode node = (ProjectArchiveNode)((Object)((Object)lastPathComponent));
                ProjectArchive archive = (ProjectArchive)node.getArchive();
                selectedArchives.add(archive);
            }
            return selectedArchives;
        };
        VersionControlAddAction addAction = new VersionControlAddAction((Plugin)this.plugin);
        addAction.setEnabled(false);
        VersionControlCheckOutAction checkOutAction = new VersionControlCheckOutAction((Plugin)this.plugin);
        checkOutAction.setEnabled(false);
        VersionControlUpdateAction updateAction = new VersionControlUpdateAction((Plugin)this.plugin);
        updateAction.setEnabled(false);
        VersionControlCheckInAction checkInAction = new VersionControlCheckInAction((Plugin)this.plugin, (Component)((Object)this.archiveGTree));
        checkInAction.setEnabled(false);
        VersionControlDataTypeArchiveUndoCheckoutAction undoCheckOutAction = new VersionControlDataTypeArchiveUndoCheckoutAction(this.plugin, archiveProvider);
        undoCheckOutAction.setEnabled(false);
        VersionControlShowHistoryAction showHistoryAction = new VersionControlShowHistoryAction((Plugin)this.plugin);
        showHistoryAction.setEnabled(false);
        VersionControlViewCheckOutAction viewCheckOutsAction = new VersionControlViewCheckOutAction((Plugin)this.plugin);
        viewCheckOutsAction.setEnabled(false);
        addAction.setToolBarData(null);
        checkOutAction.setToolBarData(null);
        updateAction.setToolBarData(null);
        checkInAction.setToolBarData(null);
        this.addLocalAction((DockingActionIf)addAction);
        this.addLocalAction((DockingActionIf)checkOutAction);
        this.addLocalAction((DockingActionIf)updateAction);
        this.addLocalAction((DockingActionIf)checkInAction);
        this.addLocalAction((DockingActionIf)undoCheckOutAction);
        this.addLocalAction((DockingActionIf)showHistoryAction);
        this.addLocalAction((DockingActionIf)viewCheckOutsAction);
    }

    private boolean hasFilter() {
        return this.archiveGTree.isFiltered();
    }

    public boolean isFilteringPointers() {
        return this.filterPointersAction.isSelected();
    }

    public boolean isFilteringArrays() {
        return this.filterArraysAction.isSelected();
    }

    private ToggleDockingAction getFilterPointersAction() {
        if (this.filterPointersAction == null) {
            this.filterPointersAction = new FilterPointersAction(this.plugin);
        }
        return this.filterPointersAction;
    }

    private ToggleDockingAction getFilterArraysAction() {
        if (this.filterArraysAction == null) {
            this.filterArraysAction = new FilterArraysAction(this.plugin);
        }
        return this.filterArraysAction;
    }

    private ConflictHandlerModesAction getConflictHandlerModesAction() {
        if (this.conflictHandlerModesAction == null) {
            this.conflictHandlerModesAction = new ConflictHandlerModesAction(this.plugin);
        }
        return this.conflictHandlerModesAction;
    }

    private ToggleDockingAction getPreviewWindowAction() {
        if (this.previewWindowAction == null) {
            this.previewWindowAction = new PreviewWindowAction(this.plugin, this);
        }
        return this.previewWindowAction;
    }

    public ActionContext getActionContext(MouseEvent event) {
        GTreeNode clickedNode = null;
        boolean isToolbarAction = true;
        if (event != null) {
            Object source = event.getSource();
            if (source instanceof JTextField || source instanceof JTextPane) {
                Component component = (Component)source;
                return new ActionContext((ComponentProvider)this, source, component);
            }
            Point point = event.getPoint();
            clickedNode = this.archiveGTree.getNodeForLocation(point.x, point.y);
            isToolbarAction = false;
        } else {
            TreePath path = this.archiveGTree.getSelectionPath();
            if (path != null) {
                clickedNode = (GTreeNode)path.getLastPathComponent();
            }
        }
        return new DataTypesActionContext(this, this.plugin.getProgram(), this.archiveGTree, clickedNode, isToolbarAction);
    }

    public void closeComponent() {
        this.plugin.closeProvider(this);
    }

    private void buildComponent() {
        this.splitPane = new JSplitPane(0);
        this.archiveGTree = new DataTypeArchiveGTree(this.plugin);
        this.archiveGTree.addMouseListener((MouseListener)new GMouseListenerAdapter(){
            private GTreeNode lastClickedNode;

            public void doubleClickTriggered(MouseEvent e) {
                Point point = e.getPoint();
                GTreeNode clickedNode = DataTypesProvider.this.archiveGTree.getNodeForLocation(point.x, point.y);
                if (clickedNode == null) {
                    return;
                }
                if (clickedNode != this.lastClickedNode) {
                    return;
                }
                DataTypesProvider.this.editNode(clickedNode);
            }

            public void mouseClicked(MouseEvent e) {
                GTreeNode clickedNode;
                super.mouseClicked(e);
                Point point = e.getPoint();
                this.lastClickedNode = clickedNode = DataTypesProvider.this.archiveGTree.getNodeForLocation(point.x, point.y);
            }
        });
        this.archiveGTree.addGTModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DataTypesProvider.this.previewUpdateManager.update();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                DataTypesProvider.this.previewUpdateManager.update();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                DataTypesProvider.this.previewUpdateManager.update();
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DataTypesProvider.this.previewUpdateManager.update();
            }
        });
        this.archiveGTree.addGTreeSelectionListener(e -> {
            TreePath path = e.getNewLeadSelectionPath();
            DataType dataType = this.getDataTypeFrom(path);
            this.dataTypeSelected(e.getEventOrigin(), dataType);
        });
        this.buildPreviewPane();
        this.archiveGTree.addGTreeSelectionListener(e -> this.previewUpdateManager.update());
        this.splitPane.setLeftComponent((Component)((Object)this.archiveGTree));
        this.splitPane.setRightComponent(null);
        this.splitPane.setResizeWeight(0.5);
        this.defaultDividerSize = this.splitPane.getDividerSize();
        this.splitPane.setDividerSize(0);
    }

    private void buildPreviewPane() {
        this.previewPane = new GHtmlTextPane();
        this.previewPane.setEditable(false);
        this.previewPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.previewPane.addHyperlinkListener(event -> {
            HyperlinkEvent.EventType type = event.getEventType();
            DataType dt = this.locateDataType(event);
            if (dt == null) {
                Msg.debug((Object)((Object)this), (Object)("Could not find data type for " + event.getDescription()));
                this.plugin.setStatus("Could not find data type for " + event.getDescription());
                return;
            }
            if (type == HyperlinkEvent.EventType.ACTIVATED) {
                this.setDataTypeSelected(dt);
            } else if (type == HyperlinkEvent.EventType.ENTERED) {
                JToolTip toolTip = new JToolTip();
                CategoryPath path = dt.getCategoryPath();
                toolTip.setTipText(path.toString());
                PopupWindow popup = new PopupWindow((JComponent)toolTip);
                popup.setCloseWindowDelay(10000);
                popup.showPopup((MouseEvent)event.getInputEvent());
            }
        });
        this.previewScrollPane = new JScrollPane(this.previewPane);
        DockingWindowManager.getHelpService().registerHelp((Object)this.previewScrollPane, new HelpLocation("DataTypeManagerPlugin", "Preview_Window"));
    }

    private DataType locateDataType(HyperlinkEvent event) {
        String href = event.getDescription();
        DataTypeUrl url = null;
        try {
            url = new DataTypeUrl(href);
        }
        catch (IllegalArgumentException e) {
            Msg.debug((Object)((Object)this), (Object)("Could not parse Data Type URL '" + href + "'"), (Throwable)e);
            return null;
        }
        return url.getDataType(this.plugin);
    }

    private void updatePreviewPane() {
        if (!this.previewPane.isShowing()) {
            return;
        }
        TreePath path = this.archiveGTree.getSelectionPath();
        GTreeNode node = null;
        if (path == null) {
            if (this.lastPreviewNode == null) {
                return;
            }
            node = this.lastPreviewNode;
        } else {
            this.lastPreviewNode = node = (GTreeNode)path.getLastPathComponent();
        }
        if (node instanceof DataTypeNode) {
            this.showDataTypePreview((DataTypeNode)node);
            return;
        }
        Object toolTip = node.getToolTip();
        if (toolTip != null) {
            toolTip = "<html><font size=\"5\">" + (String)toolTip + "</font>";
        }
        this.previewPane.setText((String)toolTip);
        this.previewPane.setCaretPosition(0);
    }

    private void showDataTypePreview(DataTypeNode dataTypeNode) {
        DataType dataType = dataTypeNode.getDataType();
        if (dataType.isDeleted()) {
            this.lastPreviewNode = null;
            return;
        }
        String toolTipText = ToolTipUtils.getFullToolTipText(dataType);
        String updated = HTMLUtilities.convertLinkPlaceholdersToHyperlinks((String)toolTipText);
        this.previewPane.setText(updated);
        this.previewPane.setCaretPosition(0);
    }

    void dispose() {
        this.previewUpdateManager.dispose();
        this.archiveGTree.dispose();
        this.navigationHistory.clear();
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    private static DataType updateDataType(CategoryPath path, String dataTypeName, ArchiveNode archiveNode) {
        DataTypeManager dataTypeManager = archiveNode.getArchive().getDataTypeManager();
        Category category = dataTypeManager.getCategory(path);
        return category.getDataType(dataTypeName);
    }

    private boolean getWriteLock(DataTypeManagerPlugin dataTypePlugin, ArchiveNode archiveNode) {
        if (!this.isOkToLock()) {
            return false;
        }
        DataTypeArchiveGTree tree = dataTypePlugin.getProvider().getGTree();
        GTreeState state = tree.getTreeState();
        if (!ArchiveUtils.lockArchive((FileArchive)archiveNode.getArchive())) {
            return false;
        }
        tree.restoreTreeState(state);
        return true;
    }

    private boolean needsWriteLock(ArchiveNode archiveNode) {
        if (archiveNode instanceof FileArchiveNode) {
            FileArchiveNode fileArchiveNode = (FileArchiveNode)archiveNode;
            return !fileArchiveNode.hasWriteLock();
        }
        return false;
    }

    private boolean isOkToLock() {
        return OptionDialog.showYesNoDialog((Component)((Object)this.archiveGTree), (String)"Open Archive for Edit?", (String)"Archive file is not modifiable.\nDo you want to open for edit?") == 1;
    }

    public void editNode(GTreeNode node) {
        if (!(node instanceof DataTypeNode)) {
            return;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        if (!dataTypeNode.hasCustomEditor()) {
            return;
        }
        DataType dataType = dataTypeNode.getDataType();
        dataType = DataTypeUtils.getBaseDataType(dataType);
        CategoryPath path = dataType.getCategoryPath();
        String dataTypeName = dataType.getName();
        ArchiveNode archiveNode = dataTypeNode.getArchiveNode();
        if (archiveNode instanceof ProjectArchiveNode && !archiveNode.isModifiable()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)((Object)this.archiveGTree), (String)"Archive Not Checked Out", (Object)"You must checkout this archive before you may edit data types.");
            return;
        }
        if (this.needsWriteLock(archiveNode)) {
            if (!this.getWriteLock(this.plugin, archiveNode)) {
                return;
            }
            dataType = DataTypesProvider.updateDataType(path, dataTypeName, archiveNode);
        }
        this.plugin.getEditorManager().edit(dataType);
    }

    void restore(SaveState saveState) {
        DataTypeConflictHandler.ConflictResolutionPolicy conflictMode;
        boolean filterPointers = saveState.getBoolean(POINTER_FILTER_STATE, true);
        boolean filterArrays = saveState.getBoolean(ARRAY_FILTER_STATE, true);
        try {
            conflictMode = DataTypeConflictHandler.ConflictResolutionPolicy.valueOf((String)saveState.getString(CONFLICT_RESOLUTION_MODE, DataTypeConflictHandler.ConflictResolutionPolicy.RENAME_AND_ADD.toString()));
        }
        catch (IllegalArgumentException e) {
            conflictMode = DataTypeConflictHandler.ConflictResolutionPolicy.RENAME_AND_ADD;
        }
        this.getFilterPointersAction().setSelected(filterPointers);
        this.getFilterArraysAction().setSelected(filterArrays);
        this.getConflictHandlerModesAction().setCurrentActionStateByUserData(conflictMode);
        this.archiveGTree.enableArrayFilter(filterArrays);
        this.archiveGTree.enablePointerFilter(filterPointers);
        boolean previewWindowVisible = saveState.getBoolean(PREVIEW_WINDOW_STATE, false);
        this.getPreviewWindowAction().setSelected(previewWindowVisible);
        boolean dataMembersInSearch = saveState.getBoolean(INCLUDE_DATA_MEMBERS_IN_SEARCH, false);
        this.includeDataMembersInSearchAction.setSelected(dataMembersInSearch);
    }

    void save(SaveState saveState) {
        saveState.putBoolean(POINTER_FILTER_STATE, this.getFilterPointersAction().isSelected());
        saveState.putBoolean(ARRAY_FILTER_STATE, this.getFilterArraysAction().isSelected());
        saveState.putString(CONFLICT_RESOLUTION_MODE, ((DataTypeConflictHandler.ConflictResolutionPolicy)this.getConflictHandlerModesAction().getCurrentUserData()).toString());
        saveState.putBoolean(PREVIEW_WINDOW_STATE, this.getPreviewWindowAction().isSelected());
        saveState.putBoolean(INCLUDE_DATA_MEMBERS_IN_SEARCH, this.includeDataMembersInSearchAction.isSelected());
    }

    public DataTypeArchiveGTree getGTree() {
        if (this.archiveGTree == null) {
            this.buildComponent();
        }
        return this.archiveGTree;
    }

    void domainObjectRestored(DataTypeManagerDomainObject domainObject) {
        if (this.archiveGTree == null) {
            return;
        }
        if (domainObject instanceof Program) {
            Program program = (Program)domainObject;
            Program programInTree = this.plugin.getProgram();
            if (program == programInTree) {
                DataTypeArchiveGTree gTree = this.getGTree();
                ArchiveNode node = this.getProgramArchiveNode();
                if (node != null) {
                    GTreeState state = gTree.getTreeState((GTreeNode)node);
                    node.structureChanged();
                    gTree.restoreTreeState(state);
                }
            }
        } else if (domainObject instanceof DataTypeArchive) {
            DataTypeArchive dataTypeArchive = (DataTypeArchive)domainObject;
            DataTypeArchiveGTree gTree = this.getGTree();
            ArchiveNode node = this.getDataTypeArchiveNode(dataTypeArchive);
            if (node != null) {
                GTreeState state = gTree.getTreeState((GTreeNode)node);
                node.structureChanged();
                gTree.restoreTreeState(state);
            }
        }
    }

    private ArchiveNode getProgramArchiveNode() {
        GTreeNode rootNode = this.getGTree().getModelRoot();
        List children = rootNode.getChildren();
        for (GTreeNode node : children) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            if (!(archive instanceof ProgramArchive)) continue;
            return archiveNode;
        }
        return null;
    }

    private ArchiveNode getDataTypeArchiveNode(DataTypeArchive dataTypeArchive) {
        GTreeNode rootNode = this.getGTree().getModelRoot();
        List children = rootNode.getChildren();
        for (GTreeNode node : children) {
            ProjectArchive projectArchive;
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            if (!(archive instanceof ProjectArchive) || (projectArchive = (ProjectArchive)archive).getDataTypeManager() != dataTypeArchive.getDataTypeManager()) continue;
            return archiveNode;
        }
        return null;
    }

    public void setFilterText(String text) {
        this.getGTree().setFilterText(text);
    }

    public void setDataTypeSelected(DataType dataType) {
        DataTypeArchiveGTree gTree = this.getGTree();
        if (dataType == null) {
            gTree.getSelectionModel().clearSelection();
            return;
        }
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            return;
        }
        Category category = dataTypeManager.getCategory(dataType.getCategoryPath());
        ArchiveRootNode rootNode = (ArchiveRootNode)gTree.getViewRoot();
        ArchiveNode archiveNode = rootNode.getNodeForManager(dataTypeManager);
        if (archiveNode == null) {
            this.plugin.setStatus("Cannot find archive '" + dataTypeManager.getName() + "'.  It may be filtered out of view or may have been closed (Data Type Manager)");
            return;
        }
        CategoryNode node = archiveNode.findCategoryNode(category, true);
        if (node == null) {
            return;
        }
        DataTypeNode dataTypeNode = node.getNode(dataType);
        if (dataTypeNode == null) {
            if (this.hasFilter()) {
                this.plugin.setStatus("Unable to find " + dataType.getName() + ".  It may be filtered out of view.  (Data Type Manager)");
            }
            return;
        }
        gTree.setSelectedNode((GTreeNode)dataTypeNode);
        gTree.scrollPathToVisible(dataTypeNode.getTreePath());
        this.contextChanged();
    }

    public void setIncludeDataTypeMembersInFilterCallback(boolean newValue) {
        this.includeDataMembersInFilter = newValue;
        this.archiveGTree.setIncludeDataTypeMembersInSearch(this.includeDataMembersInFilter);
    }

    public void setIncludeDataTypeMembersInFilter(boolean newValue) {
        this.includeDataMembersInFilter = newValue;
        this.archiveGTree.setIncludeDataTypeMembersInSearch(this.includeDataMembersInFilter);
        ToggleDockingAction action = this.includeDataMembersInSearchAction;
        boolean selected = action.isSelected();
        if (selected != this.includeDataMembersInFilter) {
            action.setSelected(this.includeDataMembersInFilter);
        }
    }

    boolean includeDataMembersInSearch() {
        return this.includeDataMembersInFilter;
    }

    public JComponent getComponent() {
        return this.splitPane;
    }

    public void setPreviewWindowVisible(boolean visible) {
        JScrollPane component = visible ? this.previewScrollPane : null;
        this.splitPane.setRightComponent(component);
        int size = visible ? this.defaultDividerSize : 0;
        this.splitPane.setDividerSize(size);
        if (!visible) {
            return;
        }
        TreePath path = this.archiveGTree.getSelectionPath();
        if (path == null) {
            return;
        }
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        this.previewPane.setText(node.getToolTip());
    }

    String getPreviewText() {
        return this.previewPane.getText();
    }

    void programClosed() {
        this.archiveGTree.cancelWork();
    }

    void archiveClosed(DataTypeManager dtm) {
        this.dataTypeManagerChanged(dtm);
    }

    void archiveChanged(Archive archive) {
        DataTypeManager dtm = archive.getDataTypeManager();
        this.dataTypeManagerChanged(dtm);
    }

    private void dataTypeManagerChanged(DataTypeManager dtm) {
        if (this.lastPreviewNode == null || !(this.lastPreviewNode instanceof DataTypeNode)) {
            return;
        }
        DataTypeNode dtNode = (DataTypeNode)this.lastPreviewNode;
        DataType dt = dtNode.getDataType();
        DataTypeManager dtManager = dt.getDataTypeManager();
        if (dtm.getName().equals(dtManager.getName())) {
            this.lastPreviewNode = null;
        }
    }

    void programRenamed() {
        ArchiveRootNode rootNode = (ArchiveRootNode)this.archiveGTree.getModelRoot();
        List allChildren = rootNode.getChildren();
        for (GTreeNode node : allChildren) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            if (!(archiveNode.getArchive() instanceof ProgramArchive)) continue;
            archiveNode.nodeChanged();
            return;
        }
    }

    DataTypeConflictHandler getConflictHandler() {
        DataTypeConflictHandler.ConflictResolutionPolicy conflictMode = (DataTypeConflictHandler.ConflictResolutionPolicy)this.getConflictHandlerModesAction().getCurrentUserData();
        return conflictMode.getHandler();
    }

    DataTypeManagerPlugin getPlugin() {
        return this.plugin;
    }

    private DataType getDataTypeFrom(TreePath path) {
        if (path == null) {
            return null;
        }
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dtNode = (DataTypeNode)node;
        DataType dt = dtNode.getDataType();
        return dt;
    }

    HistoryList<DataTypeUrl> getNavigationHistory() {
        return this.navigationHistory;
    }

    MultiActionDockingAction getPreviousAction() {
        return this.previousAction;
    }

    MultiActionDockingAction getNextAction() {
        return this.nextAction;
    }

    JTextPane getPreviewPane() {
        return this.previewPane;
    }

    private void dataTypeSelected(GTreeSelectionEvent.EventOrigin eventOrigin, DataType dt) {
        if (eventOrigin == GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED) {
            return;
        }
        if (dt == null) {
            return;
        }
        this.navigationHistory.add((Object)new DataTypeUrl(dt));
        this.contextChanged();
    }
}

