/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableTextCellEditor;
import docking.widgets.textfield.GValidatedTextField;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorProvider;
import ghidra.app.plugin.core.datamgr.editor.EnumTableModel;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class EnumEditorPanel
extends JPanel {
    private JTable table;
    private JTextField nameField;
    private JTextField descField;
    private JLabel descLabel;
    private JTextField categoryField;
    private GhidraComboBox sizeComboBox;
    private EnumTableModel tableModel;
    private EnumEditorProvider provider;
    private DocumentListener docListener;
    private EnumDataType originalEnumDT;
    private EnumDataType editedEnumDT;

    EnumEditorPanel(EnumDataType enumDT, EnumEditorProvider provider) {
        super(new BorderLayout());
        this.originalEnumDT = enumDT;
        this.editedEnumDT = (EnumDataType)enumDT.copy(enumDT.getDataTypeManager());
        this.provider = provider;
        this.create(this.editedEnumDT);
        this.setFieldInfo(this.editedEnumDT);
        this.createDocumentListener();
        this.nameField.getDocument().addDocumentListener(this.docListener);
        this.descField.getDocument().addDocumentListener(this.docListener);
    }

    EnumDataType getEnum() {
        return this.editedEnumDT;
    }

    Class<?> getTableClass() {
        return EnumTable.class;
    }

    JTable getTable() {
        return this.table;
    }

    int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    boolean needsSave() {
        return this.originalEnumDT.getDataTypeManager() != this.editedEnumDT.getDataTypeManager() || !this.editedEnumDT.getCategoryPath().equals((Object)this.originalEnumDT.getCategoryPath()) || !this.editedEnumDT.getName().equals(this.originalEnumDT.getName()) || !this.editedEnumDT.isEquivalent((DataType)this.originalEnumDT) || !this.editedEnumDT.getDescription().equals(this.originalEnumDT.getDescription());
    }

    void restoreSelection(String name, boolean modelChanged) {
        if (modelChanged) {
            this.tableModel.fireTableDataChanged();
        }
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.table.isEditing()) {
                    return;
                }
                int row = this.tableModel.getRow(name);
                if (row >= 0 && row < this.tableModel.getRowCount()) {
                    this.table.setRowSelectionInterval(row, row);
                    Rectangle rect = this.table.getCellRect(row, 0, false);
                    this.table.scrollRectToVisible(rect);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        });
    }

    void domainObjectRestored(DataTypeManagerDomainObject domainObject, EnumDataType enuum) {
        this.stopCellEditing();
        this.originalEnumDT = enuum;
        this.editedEnumDT = (EnumDataType)enuum.copy(enuum.getDataTypeManager());
        DataTypeManager objectDataTypeManager = domainObject.getDataTypeManager();
        DataTypeManager providerDataTypeManager = this.provider.getDataTypeManager();
        if (objectDataTypeManager != providerDataTypeManager) {
            return;
        }
        String objectType = "domain object";
        if (domainObject instanceof Program) {
            objectType = "program";
        } else if (domainObject instanceof DataTypeArchive) {
            objectType = "data type archive";
        }
        if (this.tableModel.hasChanges() && OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)"Reload Enum Editor?", (String)("The " + objectType + " \"" + objectDataTypeManager.getName() + "\" has been restored.\n\"" + this.tableModel.getEnum().getDisplayName() + "\" may have changed outside this editor.\nDo you want to discard edits and reload the Enum?")) == 2) {
            this.categoryField.setText(this.provider.getCategoryText());
            return;
        }
        this.setFieldInfo(this.editedEnumDT);
        this.tableModel.setEnum(this.editedEnumDT, false);
    }

    String getDescription() {
        String desc = this.descField.getText();
        if (desc.length() == 0) {
            desc = null;
        }
        return desc;
    }

    String getEnumName() {
        return this.nameField.getText();
    }

    void stateChanged(ChangeEvent e) {
        this.provider.stateChanged(e);
    }

    void setStatusMessage(String msg) {
        this.provider.setStatusMessage(msg);
    }

    void setEnum(EnumDataType enumDT) {
        this.originalEnumDT = enumDT;
        this.editedEnumDT = (EnumDataType)enumDT.copy(enumDT.getDataTypeManager());
        this.tableModel.setEnum(this.editedEnumDT, false);
    }

    void enumChanged(EnumDataType enuum) {
        this.originalEnumDT = enuum;
        EnumDataType myEnum = this.editedEnumDT;
        if (!enuum.getName().equals(myEnum.getName())) {
            this.updateNameField(enuum.getName());
        }
        this.updateDescription(enuum);
        this.sizeComboBox.setSelectedItem((Object)enuum.getLength());
        if (!enuum.isEquivalent((DataType)myEnum)) {
            myEnum.replaceWith((DataType)enuum);
            this.tableModel.setEnum(myEnum, true);
        }
    }

    private void updateDescription(EnumDataType enuum) {
        String descr = this.editedEnumDT.getDescription();
        String otherDesc = enuum.getDescription();
        boolean doUpdate = false;
        if (descr != null && !descr.equals(otherDesc)) {
            doUpdate = true;
        } else if (otherDesc != null && !otherDesc.equals(descr)) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.editedEnumDT.setDescription(otherDesc);
            this.descField.getDocument().removeDocumentListener(this.docListener);
            this.descField.setText(otherDesc != null ? otherDesc : "");
            this.descField.getDocument().addDocumentListener(this.docListener);
        }
    }

    void deleteSelectedEntries() {
        int[] rows;
        EnumDataType enuum = this.getEnum();
        for (int row : rows = this.getSelectedRows()) {
            String name = this.tableModel.getNameAt(row);
            enuum.remove(name);
        }
        this.tableModel.setEnum(enuum, true);
        this.provider.stateChanged(null);
        Arrays.sort(rows);
        int row = rows[rows.length - 1] + 1 - rows.length;
        int count = enuum.getCount();
        if (row >= count) {
            row = count - 1;
        }
        if (row >= 0) {
            this.table.setRowSelectionInterval(row, row);
        }
    }

    void addEntry() {
        this.stopCellEditing();
        int newRow = this.tableModel.addEntry(this.table.getSelectedRow());
        if (newRow < 0) {
            Msg.showError((Object)this, (Component)this, (String)"Enum is full", (Object)"All possible Enum values have already been used");
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.table.setRowSelectionInterval(newRow, newRow);
            this.table.editCellAt(newRow, 0);
            Rectangle r = this.table.getCellRect(newRow, 0, true);
            this.table.scrollRectToVisible(r);
            this.provider.stateChanged(null);
        });
    }

    void dispose() {
        this.tableModel.dispose();
    }

    void updateNameField(String newName) {
        try {
            this.originalEnumDT.setName(newName);
            this.editedEnumDT.setName(newName);
            this.provider.setTitle(newName);
            this.nameField.getDocument().removeDocumentListener(this.docListener);
            this.nameField.setText(newName);
            this.nameField.getDocument().addDocumentListener(this.docListener);
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    void updateCategoryField(String categoryPath) {
        this.categoryField.setText(categoryPath);
    }

    void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private void create(EnumDataType enumDT) {
        this.tableModel = new EnumTableModel(enumDT, this);
        this.table = new EnumTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 120));
        this.table.setSelectionMode(2);
        this.add((Component)sp, "Center");
        EnumCellRenderer cellRenderer = new EnumCellRenderer();
        this.table.setRowHeight(this.table.getRowHeight() + 4);
        this.table.setDefaultEditor(String.class, (TableCellEditor)((Object)new EnumStringCellEditor()));
        this.table.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)((Object)new EnumLongCellEditor()));
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)cellRenderer));
        this.add((Component)this.createInfoPanel(), "South");
    }

    private void createDocumentListener() {
        this.docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                String description;
                String name = EnumEditorPanel.this.nameField.getText().trim();
                if (name.length() == 0) {
                    return;
                }
                if (!name.equals(EnumEditorPanel.this.editedEnumDT.getName())) {
                    try {
                        EnumEditorPanel.this.editedEnumDT.setName(name);
                    }
                    catch (InvalidNameException e) {
                        EnumEditorPanel.this.setStatusMessage("'" + name + "' is not a valid name");
                    }
                }
                if (!(description = EnumEditorPanel.this.descField.getText()).equals(EnumEditorPanel.this.editedEnumDT.getDescription())) {
                    EnumEditorPanel.this.editedEnumDT.setDescription(description);
                }
                EnumEditorPanel.this.provider.stateChanged(null);
            }
        };
    }

    private JPanel createInfoPanel() {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel descPanel = this.createDescriptionPanel();
        outerPanel.add(this.createNamePanel());
        outerPanel.add(Box.createVerticalStrut(2));
        outerPanel.add(descPanel);
        outerPanel.add(Box.createVerticalStrut(2));
        outerPanel.add(this.createCategoryPanel());
        return outerPanel;
    }

    private JPanel createNamePanel() {
        this.nameField = new JTextField(20);
        this.nameField.setName("Name");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        GLabel label = new GLabel("Name:", 4);
        label.setPreferredSize(new Dimension(this.descLabel.getPreferredSize()));
        panel.add((Component)label);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.nameField);
        return panel;
    }

    private JPanel createDescriptionPanel() {
        this.descField = new JTextField(20);
        this.descField.setName("Description");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.descLabel = new GDLabel("Description:", 4);
        panel.add(this.descLabel);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.descField);
        return panel;
    }

    private JPanel createCategoryPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.categoryField = new JTextField(24);
        this.categoryField.setEditable(false);
        this.categoryField.setName("Category");
        this.sizeComboBox = new GhidraComboBox((Object[])new Integer[]{1, 2, 4, 8});
        this.sizeComboBox.setName("Size");
        this.sizeComboBox.addItemListener(e -> {
            Integer length = (Integer)this.sizeComboBox.getSelectedItem();
            if (!this.validateNewLength(length)) {
                return;
            }
            this.setStatusMessage("");
            this.tableModel.setLength(length);
            this.provider.stateChanged(null);
        });
        GLabel label = new GLabel("Category:", 4);
        label.setPreferredSize(new Dimension(this.descLabel.getPreferredSize()));
        panel.add((Component)label);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.categoryField);
        panel.add(Box.createHorizontalStrut(20));
        panel.add((Component)new GLabel("Size:"));
        panel.add(Box.createHorizontalStrut(5));
        panel.add((Component)this.sizeComboBox);
        return panel;
    }

    private boolean validateNewLength(Integer length) {
        String[] names;
        EnumDataType enuum = this.tableModel.getEnum();
        for (String name : names = enuum.getNames()) {
            long value = enuum.getValue(name);
            if (!this.tableModel.isValueTooBigForLength(value, length)) continue;
            this.vetoSizeChange(length, enuum.getLength(), value);
            return false;
        }
        return true;
    }

    private boolean validateNewValue(Long value) {
        EnumDataType enuum = this.tableModel.getEnum();
        int length = enuum.getLength();
        return !this.tableModel.isValueTooBigForLength(value, length);
    }

    private void vetoSizeChange(int newLength, int currentLength, long badValue) {
        SwingUtilities.invokeLater(() -> {
            this.setStatusMessage("Enum size of " + newLength + " cannot contain the value 0x" + Long.toHexString(badValue));
            this.sizeComboBox.setSelectedItem((Object)new Integer(currentLength));
        });
    }

    public String getValidValuesMessage() {
        EnumDataType enuum = this.tableModel.getEnum();
        int length = enuum.getLength();
        long maxValue = length == 8 ? -1L : (1L << 8 * length) - 1L;
        return "Valid values are from 0x0 to 0x" + Long.toHexString(maxValue);
    }

    private void setFieldInfo(EnumDataType enuum) {
        this.nameField.setText(enuum.getDisplayName());
        this.sizeComboBox.setSelectedItem((Object)enuum.getLength());
        String description = enuum.getDescription();
        if (description == null) {
            description = "";
        }
        this.descField.setText(description);
        this.categoryField.setText(this.provider.getCategoryText());
    }

    private void focus(JTextField field) {
        SwingUtilities.invokeLater(() -> {
            field.requestFocusInWindow();
            field.selectAll();
        });
    }

    private class EnumCellRenderer
    extends GTableCellRenderer {
        private EnumCellRenderer() {
        }
    }

    private class EnumLongCellEditor
    extends EnumCellEditor {
        public EnumLongCellEditor() {
            super((JTextField)new GValidatedTextField.LongField(8));
            GValidatedTextField f = (GValidatedTextField)this.getComponent();
            f.addValidator((GValidatedTextField.TextValidator)new RangeValidator());
            f.addValidationMessageListener((GValidatedTextField.ValidationMessageListener)new StatusBarValidationMessageListener());
        }
    }

    private class EnumStringCellEditor
    extends EnumCellEditor {
        public EnumStringCellEditor() {
            super(new JTextField());
        }
    }

    private abstract class EnumCellEditor
    extends GTableTextCellEditor {
        private KeyListener editingKeyListener;

        public EnumCellEditor(JTextField textField) {
            super(textField);
            this.editingKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int keycode = e.getKeyCode();
                    if (!EnumEditorPanel.this.table.isEditing()) {
                        return;
                    }
                    int row = EnumEditorPanel.this.table.getEditingRow();
                    int col = EnumEditorPanel.this.table.getEditingColumn();
                    int rowCount = EnumEditorPanel.this.table.getRowCount();
                    int columnCount = EnumEditorPanel.this.table.getColumnCount();
                    switch (keycode) {
                        case 9: {
                            if (e.isShiftDown()) {
                                if (--col >= 0) break;
                                col = columnCount - 1;
                                if (--row >= 0) break;
                                row = rowCount - 1;
                                col = columnCount - 1;
                                break;
                            }
                            if (++col != columnCount) break;
                            col = 0;
                            if (++row != rowCount) break;
                            row = 0;
                            break;
                        }
                        case 40: {
                            if (++row != rowCount) break;
                            row = 0;
                            break;
                        }
                        case 38: {
                            if (--row >= 0) break;
                            row = rowCount - 1;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    e.consume();
                    EnumEditorPanel.this.table.setRowSelectionInterval(row, row);
                    EnumEditorPanel.this.table.editCellAt(row, col);
                }
            };
            textField.addKeyListener(this.editingKeyListener);
            textField.addActionListener(e -> EnumEditorPanel.this.table.editingStopped(null));
        }

        public Component getTableCellEditorComponent(JTable table1, Object value, boolean isSelected, int row, int column) {
            EnumEditorPanel.this.setStatusMessage("");
            EnumEditorPanel.this.focus((JTextField)this.getComponent());
            return super.getTableCellEditorComponent(table1, value, isSelected, row, column);
        }

        public boolean isCellEditable(EventObject e) {
            KeyEvent ke;
            if (e instanceof KeyEvent && (ke = (KeyEvent)e).getKeyCode() == 113) {
                return true;
            }
            return super.isCellEditable(e);
        }
    }

    public class StatusBarValidationMessageListener
    implements GValidatedTextField.ValidationMessageListener {
        public void message(String msg) {
            EnumEditorPanel.this.setStatusMessage(msg);
        }
    }

    public class RangeValidator
    extends GValidatedTextField.LongField.LongValidator {
        public void validateLong(long oldLong, long newLong) throws GValidatedTextField.ValidationFailedException {
            if (!EnumEditorPanel.this.validateNewValue(newLong)) {
                throw new GValidatedTextField.ValidationFailedException(EnumEditorPanel.this.getValidValuesMessage());
            }
        }
    }

    private class EnumTable
    extends GhidraTable {
        EnumTable(TableModel model) {
            super(model);
            this.setAutoEditEnabled(true);
        }
    }
}

