/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingActionIf;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.HintTextField;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.plugin.core.disassembler.AutoTableDisassemblerModel;
import ghidra.app.plugin.core.disassembler.AutoTableDisassemblerPlugin;
import ghidra.app.services.GoToService;
import ghidra.app.util.PseudoDisassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddressTableDialog
extends DialogComponentProvider {
    private static final int DEFAULT_MINIMUM_TABLE_SIZE = 3;
    private static final String DIALOG_NAME = "Search For Address Tables";
    private JPanel mainPanel;
    private String[] blockData;
    private AutoTableDisassemblerPlugin plugin;
    private GhidraTable resultsTable;
    private JButton disassembleTableButton;
    private JButton makeTableButton;
    private JTextField offsetField;
    private HintTextField viewOffset;
    private JLabel offsetLabel;
    private JCheckBox autoLabelCB;
    private JTextField minLengthField;
    private JLabel skipLabel;
    private JTextField skipField;
    private JLabel alignLabel;
    private JTextField alignField;
    private JCheckBox selectionButton;
    private JCheckBox shiftedAddressButton;
    private JButton searchButton;
    private SelectionNavigationAction selectionNavigationAction;
    private GhidraThreadedTablePanel<AddressTable> resultsTablePanel;

    public AddressTableDialog(AutoTableDisassemblerPlugin plugin) {
        super(DIALOG_NAME, false, true, true, true);
        this.setHelpLocation(new HelpLocation("Search", "Search for Address Tables"));
        this.plugin = plugin;
        this.blockData = new String[0];
        this.addWorkPanel(this.buildMainPanel());
        this.addDismissButton();
        this.createAction();
        this.setDefaultButton(this.searchButton);
    }

    protected JPanel buildMainPanel() {
        boolean allowShiftedAddresses;
        this.mainPanel = new JPanel(new BorderLayout());
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(e -> this.searchSelection());
        JPanel resultsPanel = new JPanel(new BorderLayout());
        resultsPanel.setPreferredSize(new Dimension(600, 300));
        resultsPanel.setBorder(BorderFactory.createTitledBorder("Possible Address Tables"));
        this.resultsTablePanel = new GhidraThreadedTablePanel<AddressTable>(this.plugin.getModel());
        this.resultsTable = this.resultsTablePanel.getTable();
        GoToService goToService = (GoToService)this.plugin.getTool().getService(GoToService.class);
        this.resultsTable.installNavigation(goToService, goToService.getDefaultNavigatable());
        ListSelectionModel selModel = this.resultsTable.getSelectionModel();
        selModel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateMakeTableOptionsEnabledState();
        });
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AddressTableDialog.this.clearStatusText();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AddressTableDialog.this.plugin.updateOffsetString(AddressTableDialog.this.resultsTable.getSelectedRows());
            }
        });
        resultsPanel.add((Component)((Object)this.resultsTablePanel), "Center");
        JPanel makeTablePanel = new JPanel(new FlowLayout());
        this.makeTableButton = new JButton("Make Table");
        this.makeTableButton.setToolTipText("Make a table of addresses at the selected location(s).");
        makeTablePanel.add(this.makeTableButton);
        this.makeTableButton.setEnabled(false);
        this.makeTableButton.addActionListener(e -> this.plugin.makeTable(this.resultsTable.getSelectedRows()));
        JPanel disassemblePanel = new JPanel(new FlowLayout());
        this.disassembleTableButton = new JButton("Disassemble");
        this.disassembleTableButton.setToolTipText("Disassemble at all locations pointed to by the selected address table(s) members.");
        this.disassembleTableButton.setEnabled(false);
        disassemblePanel.add(this.disassembleTableButton);
        this.disassembleTableButton.addActionListener(e -> this.plugin.disassembleTable(this.resultsTable.getSelectedRows()));
        JPanel myButtonPanel = new JPanel(new FlowLayout());
        myButtonPanel.add(makeTablePanel);
        myButtonPanel.add(disassemblePanel);
        JPanel searchOptionsPanel = new JPanel(new BorderLayout());
        searchOptionsPanel.setBorder(BorderFactory.createTitledBorder("Search Options"));
        GLabel minLengthLabel = new GLabel("Minimum Length: ");
        minLengthLabel.setToolTipText("The minimum number of consecutive addresses that will make an address table.");
        this.minLengthField = new JTextField(5);
        this.minLengthField.setName("Minimum Length");
        this.minLengthField.setText(Integer.toString(3));
        JPanel minLengthPanel = new JPanel(new FlowLayout(0));
        minLengthPanel.add((Component)minLengthLabel);
        minLengthPanel.add(this.minLengthField);
        this.alignLabel = new GDLabel("Alignment: ");
        this.alignField = new JTextField(5);
        this.alignField.setName("Alignment");
        this.alignLabel.setToolTipText("Alignment that address tables and what they are pointing to must satisfy.");
        int align = this.plugin.getProgram().getLanguage().getInstructionAlignment();
        if (PseudoDisassembler.hasLowBitCodeModeInAddrValues((Program)this.plugin.getProgram())) {
            align = 1;
        }
        this.alignField.setText("" + align);
        this.skipLabel = new GDLabel("Skip Length: ");
        this.skipField = new JTextField(5);
        this.skipField.setName("Skip");
        this.skipLabel.setToolTipText("Number of bytes to skip between found addresses in a table.");
        this.skipField.setText("0");
        JPanel alignPanel = new JPanel(new FlowLayout(2));
        alignPanel.add(this.alignLabel);
        alignPanel.add(this.alignField);
        JPanel skipPanel = new JPanel(new FlowLayout(2));
        skipPanel.add(this.skipLabel);
        skipPanel.add(this.skipField);
        JPanel optPanel = new JPanel(new GridLayout(3, 1));
        optPanel.add(minLengthPanel);
        optPanel.add(alignPanel);
        optPanel.add(skipPanel);
        this.selectionButton = new GCheckBox("Search Selection");
        this.selectionButton.setSelected(false);
        this.selectionButton.setToolTipText("If checked, search only the current selection.");
        JPanel searchOptionsWestPanel = new JPanel(new GridLayout(2, 1));
        searchOptionsWestPanel.add(this.selectionButton);
        this.shiftedAddressButton = new GCheckBox("Shifted Addresses");
        boolean bl = allowShiftedAddresses = this.plugin.getProgram().getDataTypeManager().getDataOrganization().getPointerShift() != 0;
        if (allowShiftedAddresses) {
            this.shiftedAddressButton.setSelected(true);
            this.shiftedAddressButton.setVisible(true);
        } else {
            this.shiftedAddressButton.setSelected(false);
            this.shiftedAddressButton.setVisible(false);
        }
        this.shiftedAddressButton.setToolTipText("Search for tables of four byte values that when shifted left by two, are valid addresses in the current program.");
        searchOptionsWestPanel.add(this.shiftedAddressButton);
        searchOptionsPanel.add((Component)optPanel, "East");
        searchOptionsPanel.add((Component)searchOptionsWestPanel, "West");
        JPanel findPanel = new JPanel(new FlowLayout());
        findPanel.add(this.searchButton);
        searchOptionsPanel.add((Component)findPanel, "South");
        JPanel makeOptionsPanel = new JPanel(new BorderLayout());
        makeOptionsPanel.setBorder(BorderFactory.createTitledBorder("Make Table Options"));
        this.autoLabelCB = new GCheckBox("Auto Label");
        this.autoLabelCB.setSelected(true);
        this.autoLabelCB.setEnabled(false);
        this.autoLabelCB.setToolTipText("Label the top of the address table and all members of the table.");
        this.offsetLabel = new GDLabel("Offset: ");
        this.offsetLabel.setToolTipText("Offset from the beginning of the selected table(s)");
        this.offsetLabel.setEnabled(false);
        GDLabel viewOffsetLabel = new GDLabel("  ");
        viewOffsetLabel.setEnabled(false);
        this.viewOffset = new HintTextField("<table start address>");
        this.viewOffset.setName("viewOffset");
        this.viewOffset.setToolTipText("Address of the selected table starting at the given offset");
        this.viewOffset.setColumns(20);
        this.viewOffset.setEnabled(false);
        this.offsetField = new JTextField(2);
        this.offsetField.setName("offset");
        this.offsetField.setToolTipText("Offset from the beginning of the selected table(s)");
        this.offsetField.setText("0");
        this.offsetField.setEnabled(false);
        this.offsetField.addActionListener(e -> this.plugin.updateOffsetString(this.resultsTable.getSelectedRows()));
        this.offsetField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddressTableDialog.this.plugin.updateOffsetString(AddressTableDialog.this.resultsTable.getSelectedRows());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddressTableDialog.this.plugin.updateOffsetString(AddressTableDialog.this.resultsTable.getSelectedRows());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddressTableDialog.this.plugin.updateOffsetString(AddressTableDialog.this.resultsTable.getSelectedRows());
            }
        });
        JPanel offsetPanel = new JPanel();
        offsetPanel.setLayout(new BoxLayout(offsetPanel, 2));
        offsetPanel.add(this.autoLabelCB);
        offsetPanel.add(this.offsetLabel);
        offsetPanel.add(this.offsetField);
        offsetPanel.add((Component)viewOffsetLabel);
        offsetPanel.add((Component)this.viewOffset);
        makeOptionsPanel.add((Component)offsetPanel, "North");
        makeOptionsPanel.add((Component)myButtonPanel, "South");
        JPanel optionsPanel = new JPanel(new GridLayout(1, 2));
        optionsPanel.add(searchOptionsPanel);
        optionsPanel.add(makeOptionsPanel);
        this.mainPanel.add((Component)resultsPanel, "Center");
        this.mainPanel.add((Component)optionsPanel, "South");
        return this.mainPanel;
    }

    void clearMakeTableOptions() {
        this.setOffsetText(" ");
        this.setDialogText("");
        this.setEnableMakeTableOptions(false);
    }

    void setDialogText(String text) {
        this.setStatusText(text);
    }

    private void searchSelection() {
        if (this.selectionButton.isSelected()) {
            this.setStatusText("Searching selected area...");
            this.plugin.findTablesInSet(this.resultsTable, true);
            return;
        }
        this.searchAll();
    }

    private void searchAll() {
        this.setStatusText("Searching entire program...");
        this.plugin.findTablesInSet(this.resultsTable, false);
    }

    void setBlockData(String[] data) {
        this.blockData = data;
    }

    void refresh(Program currentProgram) {
        MemoryBlock[] currentBlocks = currentProgram.getMemory().getBlocks();
        this.blockData = new String[currentBlocks.length];
        for (int i = 0; i < currentBlocks.length; ++i) {
            this.blockData[i] = currentBlocks[i].getName();
        }
    }

    public void close() {
        if (!this.isShowing()) {
            return;
        }
        this.cancelCurrentTask();
        super.close();
        this.resultsTablePanel.dispose();
        this.plugin.dialogDismissed();
    }

    boolean getAutomaticLabel() {
        return this.autoLabelCB.isSelected();
    }

    int getMinTableSize() {
        try {
            Integer ilen = Integer.decode(this.minLengthField.getText());
            int len = ilen;
            return len;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    int getAlignment() {
        try {
            Integer ilen = Integer.decode(this.alignField.getText());
            int len = ilen;
            return len;
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    int getSkipLength() {
        try {
            Integer ilen = Integer.decode(this.skipField.getText());
            int len = ilen;
            return len;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    boolean getShiftedAddresses() {
        return this.shiftedAddressButton.isSelected();
    }

    int getOffset() {
        try {
            Integer ilen = Integer.decode(this.offsetField.getText());
            int len = ilen;
            return len;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    boolean isSearchSelection() {
        return this.selectionButton.isSelected();
    }

    void setOffsetText(String str) {
        this.viewOffset.setText(str);
    }

    void clearOffset() {
        this.offsetField.setText("0");
        this.setOffsetText(" ");
    }

    void setHasSelection(boolean b) {
        this.selectionButton.setSelected(b);
        this.selectionButton.setEnabled(b);
    }

    void enableSearchButton(boolean enabled) {
        this.searchButton.setEnabled(enabled);
    }

    void setEnableMakeTableOptions(boolean b) {
        this.autoLabelCB.setEnabled(b);
        this.setEnableOffsetField(b);
        this.setEnableMakeTableButtons(b);
    }

    void setEnableOffsetField(boolean b) {
        this.offsetLabel.setEnabled(b);
        this.offsetField.setEnabled(b);
    }

    void setEnableMakeTableButtons(boolean b) {
        this.makeTableButton.setEnabled(b);
        this.disassembleTableButton.setEnabled(b);
    }

    protected void executeProgressTask(Task task, int delay) {
        super.executeProgressTask(task, delay);
    }

    private void searchComplete() {
        this.stopProgressTimer();
        this.searchButton.setEnabled(true);
        this.resultsTable.requestFocusInWindow();
    }

    void searchComplete(boolean wasCancelled) {
        int resultCount;
        this.searchComplete();
        if (wasCancelled) {
            this.setStatusText("Find address tables was cancelled");
        }
        if ((resultCount = this.resultsTable.getRowCount()) > 0) {
            this.setStatusText(this.selectionButton.isSelected() ? "Finished searching current selection" : "Finished Searching Entire Program");
        } else {
            this.setStatusText(this.selectionButton.isSelected() ? "No address tables found in this selection!" : "No address tables found in the entire program!");
        }
    }

    void makeTablesCompleted() {
        this.stopProgressTimer();
        this.updateMakeTableOptionsEnabledState();
    }

    private void updateMakeTableOptionsEnabledState() {
        boolean hasSelection = this.resultsTable.getSelectedRowCount() > 0;
        this.setEnableMakeTableOptions(hasSelection);
    }

    int[] getSelectedRows() {
        return this.resultsTable.getSelectedRows();
    }

    public void setSelectedRows(int[] selectedRows) {
        this.resultsTable.clearSelection();
        boolean wasEnabled = this.selectionNavigationAction.isEnabled();
        this.selectionNavigationAction.setEnabled(false);
        for (int element : selectedRows) {
            this.resultsTable.addRowSelectionInterval(element, element);
        }
        this.selectionNavigationAction.setEnabled(wasEnabled);
    }

    public void taskCancelled(Task task) {
        super.taskCancelled(task);
        this.searchComplete();
    }

    public void taskCompleted(Task task) {
        super.taskCompleted(task);
        this.searchComplete();
    }

    protected void cancelCurrentTask() {
        super.cancelCurrentTask();
    }

    private void createAction() {
        MakeProgramSelectionAction selectAction = new MakeProgramSelectionAction(this.plugin, this.resultsTable){

            @Override
            protected ProgramSelection makeSelection(ActionContext context) {
                int[] selectedRows;
                Program program = AddressTableDialog.this.plugin.getProgram();
                AddressSet set = new AddressSet();
                AutoTableDisassemblerModel model = AddressTableDialog.this.plugin.getModel();
                for (int selectedRow : selectedRows = AddressTableDialog.this.resultsTable.getSelectedRows()) {
                    Address selectedAddress = model.getAddress(selectedRow);
                    AddressTable addrTab = model.get(selectedAddress);
                    if (addrTab == null) continue;
                    set.addRange(selectedAddress, selectedAddress.add((long)(addrTab.getByteLength() - 1)));
                }
                ProgramSelection selection = new ProgramSelection((AddressSetView)set);
                if (!set.isEmpty()) {
                    AddressTableDialog.this.plugin.firePluginEvent(new ProgramSelectionPluginEvent(AddressTableDialog.this.plugin.getName(), selection, program));
                }
                return selection;
            }
        };
        this.selectionNavigationAction = new SelectionNavigationAction(this.plugin, this.resultsTable);
        this.selectionNavigationAction.setHelpLocation(new HelpLocation("Search", "AddressTables_Selection_Navigation"));
        this.addAction((DockingActionIf)this.selectionNavigationAction);
        this.addAction((DockingActionIf)selectAction);
    }
}

