/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.hover;

import ghidra.app.plugin.core.hover.AbstractHover;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Disposable;

public abstract class AbstractConfigurableHover
extends AbstractHover
implements Disposable,
OptionsChangeListener {
    protected ToolOptions options;

    public AbstractConfigurableHover(PluginTool tool, int priority) {
        super(tool, priority);
        this.initializeOptions();
    }

    protected abstract String getName();

    protected abstract String getDescription();

    protected abstract String getOptionsCategory();

    public void dispose() {
        if (this.options != null) {
            this.options.removeOptionsChangeListener((OptionsChangeListener)this);
            this.options = null;
        }
    }

    public void optionsChanged(ToolOptions theOptions, String optionName, Object oldValue, Object newValue) {
        this.setOptions((Options)theOptions, optionName);
    }

    public void initializeOptions() {
        this.options = this.tool.getOptions(this.getOptionsCategory());
        String hoverName = this.getName();
        this.options.registerOption(hoverName, (Object)true, null, this.getDescription());
        this.setOptions((Options)this.options, hoverName);
        this.options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void setOptions(Options options, String optionName) {
        String hoverName = this.getName();
        if (optionName.equals(hoverName)) {
            this.enabled = options.getBoolean(hoverName, true);
        }
    }
}

