/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.app.plugin.core.stackeditor.StackEditorOptionManager;
import ghidra.app.plugin.core.stackeditor.StackEditorProvider;
import ghidra.app.plugin.core.stackeditor.StackFrameDataType;
import ghidra.app.plugin.core.stackeditor.StackPieceDataType;
import ghidra.app.util.datatype.EmptyCompositeException;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class StackEditorModel
extends CompositeEditorModel {
    private static final long serialVersionUID = 1L;
    public static final int OFFSET = 0;
    public static final int LENGTH = 1;
    public static final int DATATYPE = 2;
    public static final int NAME = 3;
    public static final int COMMENT = 4;
    private static final int MAX_LOCAL_SIZE = Integer.MAX_VALUE;
    private static final int MAX_PARAM_SIZE = Integer.MAX_VALUE;
    private StackFrame originalStack;
    private DataTypeManager dtm;
    private boolean stackChangedExternally;

    StackEditorModel(StackEditorProvider provider) {
        super(provider);
        this.headers = new String[]{"Offset", "Length", "DataType", "Name", "Comment"};
        this.columnWidths = new int[]{40, 40, 100, 100, 150};
        this.columnOffsets = new int[this.headers.length];
        this.adjustOffsets();
        this.dtm = provider.getProgram().getDataTypeManager();
        Plugin plugin = provider.getPlugin();
        this.showHexNumbers = plugin instanceof StackEditorOptionManager ? ((StackEditorOptionManager)plugin).showStackNumbersInHex() : true;
    }

    @Override
    protected boolean allowsZeroLengthComponents() {
        return false;
    }

    @Override
    protected boolean allowsBitFields() {
        return false;
    }

    void stackChangedExcternally(boolean changed) {
        this.stackChangedExternally = changed;
    }

    void load(Function function) {
        this.originalStack = function.getStackFrame();
        StackFrameDataType stackFrameDataType = new StackFrameDataType(this.originalStack, this.dtm);
        stackFrameDataType.setCategoryPath(this.dtm.getRootCategory().getCategoryPath());
        this.load((Composite)stackFrameDataType, false);
    }

    @Override
    public void load(Composite dataType, boolean useOffLineCategory) {
        this.stackChangedExcternally(false);
        super.load(dataType, useOffLineCategory);
    }

    StackFrameDataType getViewComposite() {
        return (StackFrameDataType)this.viewComposite;
    }

    @Override
    public boolean updateAndCheckChangeState() {
        if (this.originalIsChanging) {
            return false;
        }
        StackFrameDataType sfdt = (StackFrameDataType)this.viewComposite;
        int editFrameSize = sfdt.getLength();
        int editReturnAddressOffset = sfdt.getReturnAddressOffset();
        int editLocalSize = sfdt.getLocalSize();
        int editParamOffset = sfdt.getParameterOffset();
        int editParamSize = sfdt.getParameterSize();
        int stackFrameSize = sfdt.getLength();
        int stackReturnAddressOffset = sfdt.getReturnAddressOffset();
        int stackLocalSize = sfdt.getLocalSize();
        int stackParamOffset = sfdt.getParameterOffset();
        int stackParamSize = sfdt.getParameterSize();
        this.hadChanges = editFrameSize != stackFrameSize || editReturnAddressOffset != stackReturnAddressOffset || editLocalSize != stackLocalSize || editParamOffset != stackParamOffset || editParamSize != stackParamSize || super.updateAndCheckChangeState();
        return this.hadChanges;
    }

    @Override
    protected String getTypeName() {
        if (this.viewComposite instanceof StackFrameDataType) {
            return "Stack";
        }
        return super.getTypeName();
    }

    @Override
    public int getOffsetColumn() {
        return 0;
    }

    @Override
    public int getLengthColumn() {
        return 1;
    }

    @Override
    public int getMnemonicColumn() {
        return -1;
    }

    @Override
    public int getDataTypeColumn() {
        return 2;
    }

    @Override
    public int getNameColumn() {
        return 3;
    }

    @Override
    public int getCommentColumn() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.viewComposite == null || rowIndex >= this.viewComposite.getNumComponents() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return "";
        }
        DataTypeComponent element = this.viewComposite.getComponent(rowIndex);
        switch (columnIndex) {
            case 0: {
                int offset = this.viewComposite.getComponent(rowIndex).getOffset();
                return this.showHexNumbers ? StackEditorModel.getHexString(offset, true) : Integer.toString(offset);
            }
            case 1: {
                String compHexLen;
                DataType dt = element.getDataType();
                int dtLen = dt.getLength();
                String dtHexLen = this.showHexNumbers ? StackEditorModel.getHexString(dtLen, true) : Integer.toString(dtLen);
                int compLen = element.getLength();
                String string = compHexLen = this.showHexNumbers ? StackEditorModel.getHexString(compLen, true) : Integer.toString(compLen);
                if (dtLen >= 0 && dtLen != compLen) {
                    return compHexLen + " (needs " + dtHexLen + ")";
                }
                return compHexLen;
            }
            case 2: {
                DataType dt = element.getDataType();
                int dtLen = dt.getLength();
                return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)(dtLen > 0 ? dtLen : element.getLength()));
            }
            case 3: {
                String fieldName = this.getFieldNameAtRow(rowIndex, (StackFrameDataType)this.viewComposite);
                if (fieldName == null) {
                    fieldName = "";
                }
                return fieldName;
            }
            case 4: {
                return element.getComment();
            }
        }
        return null;
    }

    private String getFieldNameAtRow(int rowIndex, StackFrameDataType stackFrameDataType) {
        DataTypeComponentImpl dataType = stackFrameDataType.getComponent(rowIndex);
        String fieldName = dataType.getFieldName();
        if (fieldName == null && stackFrameDataType.isStackVariable(rowIndex)) {
            fieldName = stackFrameDataType.getDefaultName((DataTypeComponent)dataType);
        }
        return fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int modelColumnIndex) {
        try {
            this.settingValueAt = true;
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            Object originalValue = this.getValueAt(rowIndex, modelColumnIndex);
            if (SystemUtilities.isEqual((Object)originalValue, (Object)aValue)) {
                return;
            }
            if (this.fieldEdited(aValue, rowIndex, modelColumnIndex) && modelColumnIndex == 0) {
                int svOffset = Integer.decode((String)aValue);
                DataTypeComponent dtc = ((StackFrameDataType)this.viewComposite).getComponentAt(svOffset);
                offsetSelection = new OffsetPairs();
                offsetSelection.addPair(svOffset, dtc.getEndOffset());
            }
            this.setRelOffsetSelection(offsetSelection);
        }
        finally {
            this.settingValueAt = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean fieldEdited(Object value, int rowIndex, int columnIndex) {
        if (this.applyingFieldEdit) {
            return true;
        }
        try {
            this.applyingFieldEdit = true;
            switch (columnIndex) {
                case 0: {
                    this.setComponentOffset(rowIndex, (String)value);
                    break;
                }
                case 2: {
                    if (value instanceof StackPieceDataType) {
                        boolean bl = true;
                        return bl;
                    }
                    this.setComponentDataType(rowIndex, value);
                    break;
                }
                case 3: {
                    this.setComponentName(rowIndex, ((String)value).trim());
                    break;
                }
                case 4: {
                    this.setComponentComment(rowIndex, (String)value);
                    break;
                }
                default: {
                    boolean bl = false;
                    return bl;
                }
            }
            this.clearStatus();
            boolean bl = true;
            return bl;
        }
        catch (UsrException e) {
            this.setStatus(e.getMessage(), true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.applyingFieldEdit = false;
        }
    }

    @Override
    public void validateComponentOffset(int index, String offset) throws UsrException {
        try {
            DataTypeComponent existing;
            int newOffset = Integer.decode(offset);
            StackFrameDataType sfdt = (StackFrameDataType)this.viewComposite;
            if (newOffset < sfdt.getMinOffset() || newOffset > sfdt.getMaxOffset()) {
                throw new UsrException(offset + " is not an offset in this stack frame.");
            }
            DataTypeComponent comp = this.getComponent(index);
            int oldOffset = comp.getOffset();
            int compLength = comp.getLength();
            int start = newOffset;
            int checkLength = compLength;
            if (newOffset == oldOffset) {
                return;
            }
            if (newOffset < oldOffset) {
                if (newOffset + compLength > oldOffset) {
                    checkLength = oldOffset - newOffset;
                }
            } else if (newOffset < oldOffset + compLength) {
                start = oldOffset + compLength;
                checkLength = newOffset - oldOffset;
            }
            if ((existing = sfdt.getComponentAt(start)) == null) {
                if (start + compLength > sfdt.getMaxOffset()) {
                    throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit in the stack frame when placed at offset " + StackEditorModel.getHexString(newOffset, true) + ".");
                }
                throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit at offset " + StackEditorModel.getHexString(newOffset, true) + ".");
            }
            if (sfdt.isStackVariable(existing.getOrdinal())) {
                throw new InvalidInputException("There is already a stack variable at offset " + StackEditorModel.getHexString(newOffset, true) + ".");
            }
            int unavailable = newOffset - existing.getOffset();
            int mrl = sfdt.getMaxLength(newOffset) - unavailable;
            if (mrl != -1 && checkLength > mrl) {
                int available = mrl + (compLength - checkLength);
                throw new InvalidInputException(comp.getDataType().getDisplayName() + " doesn't fit at offset " + StackEditorModel.getHexString(newOffset, true) + ". It needs " + compLength + " bytes, but " + available + " bytes are available.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new UsrException("\"" + offset + "\" is not a valid offset.");
        }
    }

    public void setComponentOffset(int rowIndex, String value) throws UsrException {
        int svOffset;
        DataTypeComponent element = this.viewComposite.getComponent(rowIndex);
        int offset = element.getOffset();
        if (offset == (svOffset = Integer.decode(value).intValue())) {
            return;
        }
        DataTypeComponent newElement = ((StackFrameDataType)this.viewComposite).setOffset(rowIndex, svOffset);
        this.setSelection(new int[]{newElement.getOrdinal()});
        this.notifyCompositeChanged();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        StackFrameDataType stackDt = (StackFrameDataType)this.viewComposite;
        if (this.getNumSelectedRows() > 1) {
            return false;
        }
        if (columnIndex == 1) {
            return false;
        }
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return false;
        }
        DataTypeComponentImpl dtc = stackDt.getComponent(rowIndex);
        if (dtc == null) {
            return false;
        }
        boolean notDefined = stackDt.getDefinedComponentAtOrdinal(rowIndex) == null;
        return !notDefined || columnIndex != 0;
    }

    boolean hasVariableAtOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= this.viewComposite.getNumComponents()) {
            return false;
        }
        return ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(ordinal) != null;
    }

    boolean hasVariableAtOffset(int offset) {
        return ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOffset(offset) != null;
    }

    StackFrame getOriginalStack() {
        return this.originalStack;
    }

    StackFrameDataType getEditorStack() {
        return (StackFrameDataType)this.viewComposite;
    }

    @Override
    public void clearComponent(int ordinal) {
        ((StackFrameDataType)this.viewComposite).clearComponent(ordinal);
    }

    @Override
    public void clearSelectedComponents() throws UsrException {
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        super.clearSelectedComponents();
        this.setRelOffsetSelection(offsetSelection);
    }

    private OffsetPairs getRelOffsetSelection() {
        OffsetPairs offsets = new OffsetPairs();
        int num = this.selection.getNumRanges();
        int max = this.getNumComponents();
        for (int i = 0; i < num; ++i) {
            int endOffset;
            FieldRange range = this.selection.getFieldRange(i);
            int startOffset = this.getComponent(range.getStart().getIndex().intValue()).getOffset();
            if (range.getEnd().getIndex().intValue() < max) {
                endOffset = this.getComponent(range.getEnd().getIndex().intValue()).getOffset();
            } else {
                StackFrameDataType stf = (StackFrameDataType)this.viewComposite;
                endOffset = stf.getPositiveLength() + stf.getParameterOffset();
            }
            offsets.addPair(startOffset, endOffset);
        }
        return offsets;
    }

    private void setRelOffsetSelection(OffsetPairs offsets) {
        FieldSelection newSelection = new FieldSelection();
        int num = offsets.getNumPairs();
        int min = ((StackFrameDataType)this.viewComposite).getMinOffset();
        int max = ((StackFrameDataType)this.viewComposite).getMaxOffset();
        for (int i = 0; i < num; ++i) {
            int endIndex;
            XYPair pair = offsets.getPair(i);
            if (pair.y < min || pair.x > max) continue;
            int x = pair.x < min ? min : pair.x;
            int y = pair.y > max ? max + 1 : pair.y;
            DataTypeComponent startDtc = ((StackFrameDataType)this.viewComposite).getComponentAt(x);
            DataTypeComponent endDtc = ((StackFrameDataType)this.viewComposite).getComponentAt(y - 1);
            if (startDtc == null || endDtc == null) {
                return;
            }
            int startIndex = startDtc.getOrdinal();
            if (y <= max) {
                endIndex = endDtc.getOrdinal();
                if (endDtc.getOffset() != y) {
                    ++endIndex;
                }
            } else {
                endIndex = ((StackFrameDataType)this.viewComposite).getNumComponents();
            }
            newSelection.addRange(startIndex, endIndex);
        }
        this.setSelection(newSelection);
    }

    void setLocalSize(int size) throws UsrException {
        if (this.getLocalSize() == size) {
            return;
        }
        if (size > Integer.MAX_VALUE) {
            throw new UsrException("Local size cannot exceed 0x" + Integer.toHexString(Integer.MAX_VALUE) + ".");
        }
        ((StackFrameDataType)this.viewComposite).setLocalSize(size);
        this.notifyCompositeChanged();
    }

    void setParameterSize(int size) throws UsrException {
        if (this.getParameterSize() == size) {
            return;
        }
        if (size > Integer.MAX_VALUE) {
            throw new UsrException("Parameter size cannot exceed 0x" + Integer.toHexString(Integer.MAX_VALUE) + ".");
        }
        ((StackFrameDataType)this.viewComposite).setParameterSize(size);
        this.notifyCompositeChanged();
    }

    int getFrameSize() {
        return ((StackFrameDataType)this.viewComposite).getFrameSize();
    }

    int getLocalSize() {
        return ((StackFrameDataType)this.viewComposite).getLocalSize();
    }

    int getParameterSize() {
        return ((StackFrameDataType)this.viewComposite).getParameterSize();
    }

    int getParameterOffset() {
        return ((StackFrameDataType)this.viewComposite).getParameterOffset();
    }

    int getReturnAddressOffset() {
        return ((StackFrameDataType)this.viewComposite).getReturnAddressOffset();
    }

    @Override
    public int getMaxAddLength(int index) {
        return this.getMaxReplaceLength(index);
    }

    @Override
    public int getMaxReplaceLength(int currentIndex) {
        int offset = this.viewComposite.getComponent(currentIndex).getOffset();
        return ((StackFrameDataType)this.viewComposite).getMaxLength(offset);
    }

    @Override
    public int getMaxDuplicates(int rowIndex) {
        return 0;
    }

    @Override
    public boolean isAddAllowed(DataType dataType) {
        if (this.isSingleRowSelection()) {
            return this.isAddAllowed(this.getMinIndexSelected(), dataType);
        }
        return false;
    }

    @Override
    public boolean isAddAllowed(int currentIndex, DataType dataType) {
        int offset;
        int maxBytes;
        try {
            if (currentIndex < 0 || currentIndex >= this.getRowCount()) {
                return false;
            }
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        DataTypeComponent comp = this.getComponent(currentIndex);
        DataType compDt = comp.getDataType();
        boolean existingPointer = compDt instanceof Pointer;
        boolean isPointer = dataType instanceof Pointer || existingPointer;
        int newLength = dataType.getLength();
        if (!isPointer && newLength <= 0) {
            return false;
        }
        if (existingPointer) {
            newLength = compDt.getLength();
        }
        return newLength <= (maxBytes = ((StackFrameDataType)this.viewComposite).getMaxLength(offset = comp.getOffset()));
    }

    @Override
    public boolean isBitFieldAllowed() {
        return false;
    }

    @Override
    public boolean isArrayAllowed() {
        if (this.getNumSelectedRows() != 1 || this.viewComposite == null) {
            return false;
        }
        int index = this.getMinIndexSelected();
        if (index < 0 || index >= this.viewComposite.getNumComponents()) {
            return false;
        }
        return ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(index) != null;
    }

    @Override
    public boolean isClearAllowed() {
        return this.getNumSelectedRows() > 0;
    }

    @Override
    public boolean isCycleAllowed(CycleGroup cycleGroup) {
        return true;
    }

    @Override
    public boolean isDeleteAllowed() {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        if (range.getStart().getIndex().intValue() == 0 || range.getEnd().getIndex().intValue() == this.getRowCount()) {
            int startOffset = this.getComponent(range.getStart().getIndex().intValue()).getOffset();
            int endOffset = this.getComponent(range.getEnd().getIndex().intValue() - 1).getEndOffset();
            if (startOffset < 0 && endOffset >= 0) {
                return false;
            }
            int paramOffset = this.getParameterOffset();
            return !(paramOffset >= 0 ? startOffset < paramOffset && endOffset >= paramOffset : startOffset <= paramOffset && endOffset > paramOffset);
        }
        return false;
    }

    @Override
    public boolean isReplaceAllowed(int currentIndex, DataType dataType) {
        if (!(dataType instanceof Pointer) && dataType.getLength() <= 0) {
            return false;
        }
        try {
            if (currentIndex < 0 || currentIndex >= this.getRowCount()) {
                return false;
            }
            this.checkIsAllowableDataType(dataType);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        int offset = this.getComponent(currentIndex).getOffset();
        int maxBytes = ((StackFrameDataType)this.viewComposite).getMaxLength(offset);
        return dataType.getLength() <= maxBytes;
    }

    private void adjustComponents(DataType dataType) {
        StackFrameDataType stackDt = (StackFrameDataType)this.viewComposite;
        DataTypeComponent[] comps = stackDt.getDefinedComponents();
        Object msg = "";
        for (DataTypeComponent component : comps) {
            DataType compDt = component.getDataType();
            if (compDt != dataType) continue;
            int len = compDt.getLength();
            if (len <= 0) {
                len = component.getLength();
            }
            try {
                stackDt.replace(component.getOrdinal(), compDt, len, component.getFieldName(), component.getComment());
            }
            catch (IllegalArgumentException e) {
                msg = (String)msg + "Adjusting variable at offset " + StackEditorModel.getHexString(component.getOffset(), true) + ". " + e.getMessage() + "\n";
            }
        }
        if (((String)msg).length() > 0) {
            JOptionPane.showMessageDialog(this.provider.getComponent(), msg, "Stack Editor Adjustment Warning", 2);
        }
    }

    private void replaceComponents(DataType oldDataType, DataType newDataType) {
        StackFrameDataType stackDt = (StackFrameDataType)this.viewComposite;
        DataTypeComponent[] comps = stackDt.getDefinedComponents();
        Object msg = "";
        for (DataTypeComponent component : comps) {
            DataType compDt = component.getDataType();
            if (compDt != oldDataType) continue;
            int len = newDataType.getLength();
            if (len <= 0) {
                len = component.getLength();
            }
            try {
                stackDt.replace(component.getOrdinal(), newDataType, len, component.getFieldName(), component.getComment());
            }
            catch (IllegalArgumentException e) {
                msg = (String)msg + "Replacing variable at offset " + StackEditorModel.getHexString(component.getOffset(), true) + ". " + e.getMessage() + "\n";
            }
        }
        if (((String)msg).length() > 0) {
            JOptionPane.showMessageDialog(this.provider.getComponent(), msg, "Stack Editor Replacement Warning", 2);
        }
    }

    @Override
    public void setComponentDataTypeInstance(int index, DataType dt, int length) throws UsrException {
        this.checkIsAllowableDataType(dt);
        ((StackFrameDataType)this.viewComposite).setDataType(index, dt, length);
    }

    @Override
    public void validateComponentName(int currentIndex, String name) throws UsrException {
        if (SymbolUtilities.containsInvalidChars((String)name)) {
            throw new InvalidInputException("Symbol name \"" + name + "\"contains invalid characters.");
        }
    }

    @Override
    public void setComponentName(int rowIndex, String newName) throws InvalidInputException, InvalidNameException, DuplicateNameException {
        if (newName.trim().length() == 0) {
            newName = null;
        }
        String nameInEditor = (String)this.getValueAt(rowIndex, 3);
        StackFrameDataType stackFrameDataType = (StackFrameDataType)this.viewComposite;
        if (stackFrameDataType.isDefaultName(newName) && !this.isOriginalFieldName(newName, rowIndex)) {
            if (SystemUtilities.isEqual((Object)nameInEditor, (Object)newName)) {
                return;
            }
            throw new InvalidNameException("Cannot set a stack variable name to a default value");
        }
        if (stackFrameDataType.setName(rowIndex, newName)) {
            this.updateAndCheckChangeState();
            this.fireTableCellUpdated(rowIndex, this.getNameColumn());
            this.notifyCompositeChanged();
        }
    }

    private boolean isOriginalFieldName(String testName, int rowIndex) {
        StackFrameDataType dataType = (StackFrameDataType)this.getOriginalComposite();
        String fieldName = this.getFieldNameAtRow(rowIndex, dataType);
        return SystemUtilities.isEqual((Object)fieldName, (Object)testName);
    }

    @Override
    public void setComponentComment(int currentIndex, String comment) throws InvalidInputException {
        if (((StackFrameDataType)this.viewComposite).setComment(currentIndex, comment)) {
            this.updateAndCheckChangeState();
            this.fireTableRowsUpdated(currentIndex, currentIndex);
            this.componentDataChanged();
        }
    }

    @Override
    public DataTypeComponent add(DataType dataType) throws UsrException {
        return this.replace(dataType);
    }

    @Override
    public DataTypeComponent add(int index, DataType dt) throws UsrException {
        return this.replace(index, dt);
    }

    @Override
    public DataTypeComponent add(int index, DataType dt, int dtLength) throws UsrException {
        return this.replace(index, dt, dtLength);
    }

    private Variable getVariableContaining(int offset, List<Variable> sortedVariables) {
        Integer key = offset;
        int index = Collections.binarySearch(sortedVariables, key, StackVariableComparator.get());
        if (index >= 0) {
            return sortedVariables.get(index);
        }
        index = -index - 1;
        if (--index < 0) {
            return null;
        }
        Variable var = sortedVariables.get(index);
        int stackOffset = var.getStackOffset();
        if (stackOffset + var.getLength() > offset) {
            if (var.getDataType().isDeleted()) {
                sortedVariables.remove(index);
            } else {
                return var;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply() throws EmptyCompositeException, InvalidDataTypeException {
        if (this.isEditingField()) {
            this.endFieldEditing();
        }
        this.clearStatus();
        if (this.avoidApplyingConflictingData()) {
            return false;
        }
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        int transID = this.startTransaction("Apply \"" + this.getCompositeName() + "\" Stack Edits");
        try {
            int offset;
            Parameter p;
            if (!this.isValidName() || !this.hasChanges()) {
                boolean bl = false;
                return bl;
            }
            StackFrame original = this.getOriginalStack();
            Function function = original.getFunction();
            StackFrameDataType edited = this.getEditorStack();
            Variable[] newVars = edited.getStackVariables();
            List<Variable> newVarsList = Arrays.asList(newVars);
            Collections.sort(newVarsList, StackVariableComparator.get());
            original.setLocalSize(edited.getLocalSize());
            original.setReturnAddressOffset(edited.getReturnAddressOffset());
            Parameter[] origParams = function.getParameters();
            for (int i = origParams.length - 1; i >= 0 && (p = origParams[i]).hasStackStorage() && !p.isAutoParameter() && this.getVariableContaining(offset = (int)p.getVariableStorage().getLastVarnode().getAddress().getOffset(), newVarsList) == null; --i) {
                p.getSymbol().delete();
            }
            for (Variable var : function.getAllVariables()) {
                int offset2;
                if (!var.hasStackStorage() || var.getSymbol() == null || this.getVariableContaining(offset2 = (int)var.getVariableStorage().getLastVarnode().getAddress().getOffset(), newVarsList) != null) continue;
                if (var instanceof Parameter && !function.hasCustomVariableStorage()) {
                    function.setCustomVariableStorage(true);
                }
                var.getSymbol().delete();
            }
            for (Variable sv : newVars) {
                Variable newSv = null;
                try {
                    DataType dt = this.dtm.resolve(sv.getDataType(), null);
                    Variable var = original.getVariableContaining(sv.getStackOffset());
                    if (var != null && var.getStackOffset() == sv.getStackOffset() && var.getLength() == sv.getLength()) {
                        newSv = var;
                        if (!newSv.getName().equals(sv.getName())) {
                            newSv.setName(sv.getName(), SourceType.USER_DEFINED);
                        }
                        if (!dt.equals(newSv.getDataType())) {
                            newSv.setDataType(dt, SourceType.USER_DEFINED);
                        }
                    } else {
                        if (original.isParameterOffset(sv.getStackOffset()) || var instanceof Parameter) {
                            original.getFunction().setCustomVariableStorage(true);
                        }
                        if (var != null) {
                            original.clearVariable(var.getStackOffset());
                        }
                        newSv = original.createVariable(sv.getName(), sv.getStackOffset(), dt, SourceType.USER_DEFINED);
                    }
                    newSv.setComment(sv.getComment());
                }
                catch (DuplicateNameException e) {
                    Msg.showError((Object)this, null, (String)"Stack Edit Error", (Object)("Stack variable error at offset " + sv.getStackOffset() + ": " + e.getMessage()));
                    continue;
                }
                catch (InvalidInputException e) {
                    Msg.showError((Object)this, null, (String)"Stack Edit Error", (Object)("Stack variable error at offset " + sv.getStackOffset() + ": " + e.getMessage()));
                    continue;
                }
                String comment = sv.getComment();
                if (comment == null) continue;
                newSv.setComment(comment);
            }
            this.load((Composite)new StackFrameDataType(original, this.dtm), false);
            this.clearStatus();
            boolean bl = true;
            return bl;
        }
        finally {
            this.endTransaction(transID);
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    private boolean avoidApplyingConflictingData() {
        if (!this.hasChanges()) {
            return true;
        }
        if (!this.stackChangedExternally) {
            return false;
        }
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)this.provider.getComponent(), (String)"Overwrite Program Changes?", (String)"<html>The function's stack data has changed outside of this<br>Stack Editor Provider.<br><BR>Would you like to overwrite the external changes with your changes?", (String)"Overwrite", (int)2);
        return choice == 0;
    }

    protected int startTransaction(String startMsg) {
        Program program = ((StackEditorProvider)this.provider).getProgram();
        if (program != null) {
            return program.startTransaction(startMsg);
        }
        return -1;
    }

    protected void endTransaction(int transID) {
        Program program = ((StackEditorProvider)this.provider).getProgram();
        if (program != null) {
            program.endTransaction(transID, true);
        }
    }

    @Override
    public void duplicateMultiple(int index, int multiple, TaskMonitor monitor) throws UsrException {
    }

    @Override
    public DataTypeComponent insert(DataType dataType) throws UsrException {
        return null;
    }

    @Override
    public DataTypeComponent insert(int index, DataType dataType) throws UsrException {
        return null;
    }

    @Override
    public DataTypeComponent insert(int index, DataType dt, int dtLength) throws UsrException {
        return null;
    }

    @Override
    public boolean moveUp() {
        return false;
    }

    @Override
    public boolean moveDown() {
        return false;
    }

    public DataTypeComponent replace(DataType dataType) throws UsrException {
        int rowIndex = this.getMinIndexSelected();
        if (rowIndex < 0) {
            throw new UsrException("A component must be selected.");
        }
        return this.replace(rowIndex, dataType);
    }

    public DataTypeComponent replace(int index, DataType dataType) throws UsrException {
        try {
            DataTypeInstance dti = this.getDropDataType(index, dataType);
            return this.replace(index, dti.getDataType(), dti.getLength());
        }
        catch (CancelledException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replace(int index, DataType dt, int dtLength) throws UsrException {
        OffsetPairs offsetSelection = this.getRelOffsetSelection();
        int transID = this.startTransaction("Apply Data Type \"" + dt.getName() + "\"");
        try {
            this.fieldEdited(DataTypeInstance.getDataTypeInstance((DataType)dt, (int)dtLength), index, this.getDataTypeColumn());
            this.setRelOffsetSelection(offsetSelection);
        }
        finally {
            this.endTransaction(transID);
        }
        return this.getComponent(index);
    }

    @Override
    public int getMaxElements() {
        if (this.getNumSelectedComponentRows() != 1) {
            return 0;
        }
        int index = this.getMinIndexSelected();
        if (index < 0 || index >= this.viewComposite.getNumComponents()) {
            this.setStatus("Can only create arrays on a defined stack variable.", true);
            return 0;
        }
        DataTypeComponent dtc = ((StackFrameDataType)this.viewComposite).getDefinedComponentAtOrdinal(index);
        if (dtc == null) {
            this.setStatus("Can only create arrays on a defined stack variable.", true);
            return 0;
        }
        int max = this.getMaxReplaceLength(index);
        if (max == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return max / dtc.getLength();
    }

    @Override
    public void dataTypeChanged(DataTypeManager dataTypeManager, DataTypePath path) {
        if (this.isLoaded()) {
            DataType dataType = dataTypeManager.getDataType(path);
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            this.adjustComponents(dataType);
            this.fireTableDataChanged();
            this.componentDataChanged();
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    @Override
    public void dataTypeMoved(DataTypeManager dataTypeManager, DataTypePath oldPath, DataTypePath newPath) {
        if (!this.isLoaded()) {
            return;
        }
        if (this.originalDataTypePath != null && this.originalDataTypePath.getDataTypeName().equals(newPath.getDataTypeName()) && this.originalDataTypePath.getCategoryPath().equals((Object)oldPath.getCategoryPath())) {
            this.originalDataTypePath = newPath;
            this.originalCategoryChanged();
            this.compositeInfoChanged();
        }
    }

    @Override
    public void dataTypeRemoved(DataTypeManager dataTypeManager, DataTypePath path) {
        if (this.isLoaded()) {
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            DataType dataType = dataTypeManager.getDataType(path);
            this.replaceComponents(dataType, DataType.DEFAULT);
            this.fireTableDataChanged();
            this.componentDataChanged();
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    @Override
    public void dataTypeRenamed(DataTypeManager dataTypeManager, DataTypePath oldPath, DataTypePath newPath) {
        if (this.isLoaded()) {
            DataTypeManager originalDataTypeManager = this.getOriginalDataTypeManager();
            if (dataTypeManager != originalDataTypeManager) {
                return;
            }
            DataTypePath originalPath = this.getOriginalDataTypePath();
            if (originalDataTypeManager == null || originalPath == null) {
                return;
            }
            if (!oldPath.equals((Object)originalPath)) {
                return;
            }
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            this.fireTableDataChanged();
            this.componentDataChanged();
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    @Override
    public void dataTypeReplaced(DataTypeManager dataTypeManager, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        if (this.isLoaded()) {
            DataType oldDataType = this.viewDTM.getDataType(oldPath);
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            this.replaceComponents(oldDataType, newDataType);
            this.fireTableDataChanged();
            this.componentDataChanged();
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    @Override
    protected Composite getOriginalComposite() {
        return super.getOriginalComposite();
    }

    @Override
    protected DataTypeManager getOriginalDataTypeManager() {
        return super.getOriginalDataTypeManager();
    }

    @Override
    protected void fixupOriginalPath(Composite composite) {
        super.fixupOriginalPath(composite);
    }

    @Override
    protected long getCompositeID() {
        return super.getCompositeID();
    }

    protected void refresh() {
        if (this.isLoaded()) {
            OffsetPairs offsetSelection = this.getRelOffsetSelection();
            this.refreshComponents();
            this.fireTableDataChanged();
            this.componentDataChanged();
            this.compositeInfoChanged();
            this.setRelOffsetSelection(offsetSelection);
        }
    }

    private void refreshComponents() {
        StackFrameDataType stackDt = (StackFrameDataType)this.viewComposite;
        DataTypeComponent[] comps = stackDt.getDefinedComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            DataTypeComponent component = comps[i];
            DataType compDt = component.getDataType();
            if (!compDt.isDeleted()) continue;
            this.clearComponent(component.getOrdinal());
        }
    }

    @Override
    public DataType resolve(DataType dt) {
        if (dt instanceof StackPieceDataType) {
            return dt;
        }
        return DataTypeHelper.resolveDataType(dt, this.viewDTM, null);
    }

    @Override
    public DataType resolveDataType(DataType dt, DataTypeManager resolveDtm, DataTypeConflictHandler conflictHandler) {
        return DataTypeHelper.resolveDataType(dt, resolveDtm, conflictHandler);
    }

    @Override
    public DataTypeInstance validateComponentDataType(int index, String dtString) throws CancelledException, UsrException {
        DataTypeComponent element;
        DataType dt = null;
        String dtName = "";
        dtString = DataTypeHelper.stripWhiteSpace(dtString);
        if (index < this.getNumComponents() && dtString.equals(dtName = (dt = (element = this.viewComposite.getComponent(index)).getDataType()).getDisplayName())) {
            return DataTypeInstance.getDataTypeInstance((DataType)element.getDataType(), (int)element.getLength());
        }
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        DataType newDt = DataTypeHelper.parseDataType(index, dtString, this, originalDTM, this.provider.getDtmService());
        if (newDt == null) {
            if (dt != null) {
                throw new UsrException("No data type was specified.");
            }
            throw new CancelledException();
        }
        int newLength = newDt.getLength();
        this.checkIsAllowableDataType(newDt);
        newDt = DataTypeHelper.resolveDataType(newDt, this.viewDTM, null);
        int maxLength = this.getMaxReplaceLength(index);
        if (newLength <= 0) {
            throw new UsrException("Can't currently add this data type--not enough space.");
        }
        if (maxLength > 0 && newLength > maxLength) {
            throw new UsrException(newDt.getDisplayName() + " doesn't fit.");
        }
        return DataTypeInstance.getDataTypeInstance((DataType)newDt, (int)newLength);
    }

    @Override
    protected void deleteComponent(int rowIndex) {
        this.viewComposite.delete(rowIndex);
    }

    @Override
    public DataTypeComponent getComponent(int rowIndex) {
        if (this.viewComposite == null) {
            return null;
        }
        return this.viewComposite.getComponent(rowIndex);
    }

    @Override
    public int getNumComponents() {
        if (this.viewComposite == null) {
            return 0;
        }
        return this.viewComposite.getNumComponents();
    }

    @Override
    public boolean isShowingUndefinedBytes() {
        return true;
    }

    private class XYPair {
        int x;
        int y;

        XYPair(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    private class OffsetPairs {
        ArrayList<XYPair> pairs = new ArrayList();

        OffsetPairs() {
        }

        void addPair(int x, int y) {
            this.pairs.add(new XYPair(x, y));
        }

        int getNumPairs() {
            return this.pairs.size();
        }

        XYPair getPair(int i) {
            if (i >= 0 && i < this.pairs.size()) {
                return this.pairs.get(i);
            }
            return null;
        }
    }
}

