/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDataApplicationMode;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.SignedLeb128DataType;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.UnsignedLeb128DataType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.AddressTranslationException;

abstract class AbstractDwarfEHDecoder
implements DwarfEHDecoder {
    protected static ByteDataType BYTE_DATA_TYPE = ByteDataType.dataType;
    protected static WordDataType WORD_DATA_TYPE = WordDataType.dataType;
    protected static DWordDataType DWORD_DATA_TYPE = DWordDataType.dataType;
    protected static QWordDataType QWORD_DATA_TYPE = QWordDataType.dataType;
    protected static SignedLeb128DataType SLEB_DATA_TYPE = SignedLeb128DataType.dataType;
    protected static UnsignedLeb128DataType ULEB_DATA_TYPE = UnsignedLeb128DataType.dataType;
    protected final DwarfEHDataApplicationMode appMode;
    protected final boolean isIndirect;

    public AbstractDwarfEHDecoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
        if (mode == null) {
            mode = DwarfEHDataApplicationMode.DW_EH_PE_absptr;
        }
        this.appMode = mode;
        this.isIndirect = isIndirect;
    }

    @Override
    public DwarfEHDataApplicationMode getDataApplicationMode() {
        return this.appMode;
    }

    public String toString() {
        String repr = this.getDataFormat() + " | " + this.getDataApplicationMode();
        if (this.isIndirect) {
            repr = repr + " | " + DwarfEHDataApplicationMode.DW_EH_PE_indirect;
        }
        return repr;
    }

    protected long ptrval(Program program, Address addr) throws MemoryAccessException {
        switch (addr.getPointerSize()) {
            case 2: {
                return AbstractDwarfEHDecoder.readWord(program, addr);
            }
            case 4: {
                return AbstractDwarfEHDecoder.readDWord(program, addr);
            }
            case 8: {
                long base = AbstractDwarfEHDecoder.readDWord(program, addr);
                return base;
            }
        }
        throw new AddressTranslationException("Don't know how to make a " + addr.getPointerSize() + "-byte pointer");
    }

    protected long ptrval(MemBuffer buf, int ptrSize) throws MemoryAccessException {
        switch (ptrSize) {
            case 2: {
                return AbstractDwarfEHDecoder.readWord(buf);
            }
            case 4: {
                return AbstractDwarfEHDecoder.readDWord(buf);
            }
            case 8: {
                return AbstractDwarfEHDecoder.readQWord(buf);
            }
        }
        throw new AddressTranslationException("Don't know how to make a " + ptrSize + "-byte pointer");
    }

    protected static long readByte(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getByte(addr);
    }

    protected static long readByte(MemBuffer buf, int length) throws MemoryAccessException {
        return buf.getByte(0);
    }

    protected static long readWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getShort(addr);
    }

    protected static long readWord(MemBuffer buf) throws MemoryAccessException {
        return buf.getShort(0);
    }

    protected static long readDWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getInt(addr);
    }

    protected static long readDWord(MemBuffer buf) throws MemoryAccessException {
        return buf.getInt(0);
    }

    protected static long readQWord(Program program, Address addr) throws MemoryAccessException {
        return program.getMemory().getLong(addr);
    }

    protected static long readQWord(MemBuffer buf) throws MemoryAccessException {
        return buf.getLong(0);
    }

    protected static void readBytes(Program program, Address addr, byte[] buffer) throws MemoryAccessException {
        program.getMemory().getBytes(addr, buffer);
    }

    protected static int readBytes(MemBuffer buf, byte[] buffer) throws MemoryAccessException {
        return buf.getBytes(buffer, 0);
    }

    protected long read_leb128(Program program, Address addr) throws MemoryAccessException {
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
        Scalar scalar = (Scalar)uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), uleb.getLength((MemBuffer)buf, -1));
        return scalar.getUnsignedValue();
    }

    protected long read_leb128(MemBuffer buf, int length) throws MemoryAccessException {
        UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
        Scalar scalar = (Scalar)uleb.getValue(buf, uleb.getDefaultSettings(), uleb.getLength(buf, -1));
        return scalar.getUnsignedValue();
    }

    protected long read_sleb128(Program program, Address addr) throws MemoryAccessException {
        SignedLeb128DataType sleb = SignedLeb128DataType.dataType;
        DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
        Scalar scalar = (Scalar)sleb.getValue((MemBuffer)buf, sleb.getDefaultSettings(), sleb.getLength((MemBuffer)buf, -1));
        return scalar.getSignedValue();
    }

    protected long read_sleb128(MemBuffer buf, int length) throws MemoryAccessException {
        SignedLeb128DataType sleb = SignedLeb128DataType.dataType;
        Scalar scalar = (Scalar)sleb.getValue(buf, sleb.getDefaultSettings(), sleb.getLength(buf, -1));
        return scalar.getSignedValue();
    }

    @Override
    public Address decodeAddress(DwarfDecodeContext context) throws MemoryAccessException {
        Program prog = context.getProgram();
        AddressFactory addrFactory = prog.getAddressFactory();
        AddressSpace ram = addrFactory.getDefaultAddressSpace();
        long offset = this.decode(context);
        return addrFactory.getAddress(ram.getSpaceID(), offset);
    }

    @Override
    public final long decode(DwarfDecodeContext context) throws MemoryAccessException {
        long val = this.doDecode(context);
        return this.resolveRelativeOffset(val, context);
    }

    private long resolveRelativeOffset(long val, DwarfDecodeContext context) throws MemoryAccessException {
        Program prog = context.getProgram();
        Address addr = context.getAddress();
        AddressSpace ram = prog.getAddressFactory().getDefaultAddressSpace();
        if ((val == 0L || val == addr.getOffset()) && this.isIndirect) {
            return val;
        }
        switch (this.appMode) {
            case DW_EH_PE_absptr: {
                if (prog.getRelocationTable().getRelocation(addr) != null) break;
                long programBaseAddressFixup = context.getOriginalImageBaseOffset();
                val += programBaseAddressFixup;
                break;
            }
            case DW_EH_PE_aligned: {
                break;
            }
            case DW_EH_PE_datarel: {
                val = context.getEhBlock().getStart().add(val).getOffset();
                break;
            }
            case DW_EH_PE_funcrel: {
                val = context.getFunctionEntryPoint().add(val).getOffset();
                break;
            }
            case DW_EH_PE_pcrel: {
                val = addr.add(val).getOffset();
                break;
            }
            case DW_EH_PE_texrel: {
                MemoryBlock txt = prog.getMemory().getBlock(".text");
                val = txt.getStart().add(val).getOffset();
                break;
            }
        }
        if (this.isIndirect) {
            Address toDeref = prog.getAddressFactory().getAddress(ram.getSpaceID(), val);
            val = this.ptrval(prog, toDeref);
        }
        return val;
    }

    public abstract long doDecode(DwarfDecodeContext var1) throws MemoryAccessException;
}

