/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Implementation;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.SignedDWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_Method
extends ObjectiveC_Method {
    private String name;
    private String types;
    private ObjectiveC2_Implementation imp;
    private boolean isSmall;

    public ObjectiveC2_Method(ObjectiveC2_State state, BinaryReader reader, ObjectiveC_MethodType methodType, boolean isSmallList) throws IOException {
        super(state, reader, methodType);
        this.isSmall = isSmallList;
        if (isSmallList) {
            int nameOffset = (int)ObjectiveC1_Utilities.readNextIndex(reader, true);
            int namePtr = reader.readInt(this._index + (long)nameOffset);
            long imagebase = state.program.getImageBase().getOffset();
            this.name = reader.readAsciiString(imagebase + (long)namePtr);
            int typesOffset = (int)ObjectiveC1_Utilities.readNextIndex(reader, true);
            this.types = reader.readAsciiString(this._index + 4L + (long)typesOffset);
        } else {
            long nameIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
            this.name = reader.readAsciiString(nameIndex);
            long typesIndex = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
            this.types = reader.readAsciiString(typesIndex);
        }
        this.imp = new ObjectiveC2_Implementation(state, reader, isSmallList);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypes() {
        return this.types;
    }

    @Override
    public long getImplementation() {
        return this.imp.getImplementation();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("method_t", 0);
        if (this.isSmall) {
            SignedDWordDataType sdw = SignedDWordDataType.dataType;
            String comment = "offset from this address";
            struct.add((DataType)sdw, sdw.getLength(), "name", comment);
            struct.add((DataType)sdw, sdw.getLength(), "types", comment);
            struct.add((DataType)sdw, sdw.getLength(), "imp", comment);
        } else {
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this._state.pointerSize, "types", null);
            struct.add((DataType)new PointerDataType(VOID), this._state.pointerSize, "imp", null);
        }
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }
}

