/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import java.util.HashSet;
import java.util.Set;

public enum DllCharacteristics {
    IMAGE_DLLCHARACTERISTICS_HIGH_ENTROPY_VA("IMAGE_DLLCHARACTERISTICS_HIGH_ENTROPY_VA", 32, "Image can handle a high entropy 64-bit virtual address space."),
    IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE("IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE", 64, "DLL can be relocated at load time."),
    IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY("IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY", 128, "Code Integrity checks are enforced."),
    IMAGE_DLLCHARACTERISTICS_NX_COMPAT("IMAGE_DLLCHARACTERISTICS_NX_COMPAT", 256, "Image is NX compatible."),
    IMAGE_DLLCHARACTERISTICS_NO_ISOLATION("IMAGE_DLLCHARACTERISTICS_NO_ISOLATION", 512, "Isolation aware, but do not isolate the image."),
    IMAGE_DLLCHARACTERISTICS_NO_SEH("IMAGE_DLLCHARACTERISTICS_NO_SEH", 1024, "Does not use structured exception (SE) handling. No SE handler may be called in this image."),
    IMAGE_DLLCHARACTERISTICS_NO_BIND("IMAGE_DLLCHARACTERISTICS_NO_BIND", 2048, "Do not bind the image."),
    IMAGE_DLLCHARACTERISTICS_APPCONTAINER("IMAGE_DLLCHARACTERISTICS_APPCONTAINER", 4096, "Image must execute in an AppContainer."),
    IMAGE_DLLCHARACTERISTICS_WDM_DRIVER("IMAGE_DLLCHARACTERISTICS_WDM_DRIVER", 8192, "A WDM driver."),
    IMAGE_DLLCHARACTERISTICS_GUARD_CF("IMAGE_DLLCHARACTERISTICS_GUARD_CF", 16384, "Image supports Control Flow Guard."),
    IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE("IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE", 32768, "Terminal Server aware.");

    private final String alias;
    private final int mask;
    private final String description;

    private DllCharacteristics(String alias, int mask, String description) {
        this.alias = alias;
        this.mask = mask;
        this.description = description;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getMask() {
        return this.mask;
    }

    public String getDescription() {
        return this.description;
    }

    public static Set<DllCharacteristics> resolveCharacteristics(int value) {
        HashSet<DllCharacteristics> applied = new HashSet<DllCharacteristics>();
        for (DllCharacteristics ch : DllCharacteristics.values()) {
            if ((ch.getMask() & value) != ch.getMask()) continue;
            applied.add(ch);
        }
        return applied;
    }
}

