/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.BoundImportDataDirectory;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.DebugDataDirectory;
import ghidra.app.util.bin.format.pe.ImageRuntimeFunctionEntries;
import ghidra.app.util.bin.format.pe.MachineName;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.bin.format.pe.SecurityDataDirectory;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FileHeader
implements StructConverter {
    public static final String NAME = "IMAGE_FILE_HEADER";
    public static final int IMAGE_SIZEOF_FILE_HEADER = 20;
    public static final int IMAGE_FILE_RELOCS_STRIPPED = 1;
    public static final int IMAGE_FILE_EXECUTABLE_IMAGE = 2;
    public static final int IMAGE_FILE_LINE_NUMS_STRIPPED = 4;
    public static final int IMAGE_FILE_LOCAL_SYMS_STRIPPED = 8;
    public static final int IMAGE_FILE_AGGRESIVE_WS_TRIM = 16;
    public static final int IMAGE_FILE_LARGE_ADDRESS_AWARE = 32;
    public static final int IMAGE_FILE_BYTES_REVERSED_LO = 128;
    public static final int IMAGE_FILE_32BIT_MACHINE = 256;
    public static final int IMAGE_FILE_DEBUG_STRIPPED = 512;
    public static final int IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP = 1024;
    public static final int IMAGE_FILE_NET_RUN_FROM_SWAP = 2048;
    public static final int IMAGE_FILE_SYSTEM = 4096;
    public static final int IMAGE_FILE_DLL = 8192;
    public static final int IMAGE_FILE_UP_SYSTEM_ONLY = 16384;
    public static final int IMAGE_FILE_BYTES_REVERSED_HI = 32768;
    private static final int LORDPE_SYMBOL_TABLE = 1919896667;
    private static final int LORDPE_NUMBER_OF_SYMBOLS = 1564823652;
    public static final String[] CHARACTERISTICS = new String[]{"Relocation info stripped from file", "File is executable  (i.e. no unresolved externel references)", "Line nunbers stripped from file", "Local symbols stripped from file", "Agressively trim working set", "App can handle >2gb addresses", "Bytes of machine word are reversed", "32 bit word machine", "Debugging info stripped from file in .DBG file", "If Image is on removable media, copy and run from the swap file", "If Image is on Net, copy and run from the swap file", "System file", "File is a DLL", "File should only be run on a UP machine", "Bytes of machine word are reversed"};
    public static final int IMAGE_FILE_MACHINE_MASK = 65535;
    public static final int IMAGE_FILE_MACHINE_UNKNOWN = 0;
    public static final int IMAGE_FILE_MACHINE_AM33 = 467;
    public static final int IMAGE_FILE_MACHINE_AMD64 = 34404;
    public static final int IMAGE_FILE_MACHINE_ARM = 448;
    public static final int IMAGE_FILE_MACHINE_ARM64 = 43620;
    public static final int IMAGE_FILE_MACHINE_ARMNT = 452;
    public static final int IMAGE_FILE_MACHINE_EBC = 3772;
    public static final int IMAGE_FILE_MACHINE_I386 = 332;
    public static final int IMAGE_FILE_MACHINE_IA64 = 512;
    public static final int IMAGE_FILE_MACHINE_M32R = 36929;
    public static final int IMAGE_FILE_MACHINE_MIPS16 = 614;
    public static final int IMAGE_FILE_MACHINE_MIPSFPU = 870;
    public static final int IMAGE_FILE_MACHINE_MIPSFPU16 = 1126;
    public static final int IMAGE_FILE_MACHINE_POWERPC = 496;
    public static final int IMAGE_FILE_MACHINE_POWERPCFP = 497;
    public static final int IMAGE_FILE_MACHINE_R4000 = 358;
    public static final int IMAGE_FILE_MACHINE_RISCV32 = 20530;
    public static final int IMAGE_FILE_MACHINE_RISCV64 = 20580;
    public static final int IMAGE_FILE_MACHINE_RISCV128 = 20776;
    public static final int IMAGE_FILE_MACHINE_SH3 = 418;
    public static final int IMAGE_FILE_MACHINE_SH3DSP = 419;
    public static final int IMAGE_FILE_MACHINE_SH4 = 422;
    public static final int IMAGE_FILE_MACHINE_SH5 = 424;
    public static final int IMAGE_FILE_MACHINE_THUMB = 450;
    public static final int IMAGE_FILE_MACHINE_WCEMIPSV2 = 361;
    private short machine;
    private short numberOfSections;
    private int timeDateStamp;
    private int pointerToSymbolTable;
    private int numberOfSymbols;
    private short sizeOfOptionalHeader;
    private short characteristics;
    private SectionHeader[] sectionHeaders;
    private List<DebugCOFFSymbol> symbols = new ArrayList<DebugCOFFSymbol>();
    private List<ImageRuntimeFunctionEntries._IMAGE_RUNTIME_FUNCTION_ENTRY> irfes = new ArrayList<ImageRuntimeFunctionEntries._IMAGE_RUNTIME_FUNCTION_ENTRY>();
    private FactoryBundledWithBinaryReader reader;
    private int startIndex;
    private NTHeader ntHeader;

    static FileHeader createFileHeader(FactoryBundledWithBinaryReader reader, int startIndex, NTHeader ntHeader) throws IOException {
        FileHeader fileHeader = (FileHeader)reader.getFactory().create(FileHeader.class, new Object[0]);
        fileHeader.initFileHeader(reader, startIndex, ntHeader);
        return fileHeader;
    }

    private void initFileHeader(FactoryBundledWithBinaryReader reader, int startIndex, NTHeader ntHeader) throws IOException {
        this.reader = reader;
        this.startIndex = startIndex;
        this.ntHeader = ntHeader;
        this.parse();
    }

    public short getMachine() {
        return this.machine;
    }

    public String getMachineName() {
        return MachineName.getName(this.machine);
    }

    public int getNumberOfSections() {
        return this.numberOfSections;
    }

    public SectionHeader[] getSectionHeaders() {
        if (this.sectionHeaders == null) {
            return new SectionHeader[0];
        }
        return this.sectionHeaders;
    }

    public List<DebugCOFFSymbol> getSymbols() {
        return this.symbols;
    }

    public List<ImageRuntimeFunctionEntries._IMAGE_RUNTIME_FUNCTION_ENTRY> getImageRuntimeFunctionEntries() {
        return this.irfes;
    }

    public SectionHeader getSectionHeaderContaining(int virtualAddr) {
        for (SectionHeader sectionHeader : this.sectionHeaders) {
            int start = sectionHeader.getVirtualAddress();
            int end = sectionHeader.getVirtualAddress() + sectionHeader.getVirtualSize() - 1;
            if (virtualAddr < start || virtualAddr > end) continue;
            return sectionHeader;
        }
        return null;
    }

    public SectionHeader getSectionHeader(int index) {
        if (index >= 0 && index < this.sectionHeaders.length) {
            return this.sectionHeaders[index];
        }
        return null;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public int getPointerToSymbolTable() {
        return this.pointerToSymbolTable;
    }

    public int getNumberOfSymbols() {
        return this.numberOfSymbols;
    }

    public int getSizeOfOptionalHeader() {
        return this.sizeOfOptionalHeader;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public int getPointerToSections() {
        short testSize;
        short sizeOptHdr = this.ntHeader.getFileHeader().sizeOfOptionalHeader;
        int ptrToSections = this.startIndex + 20 + sizeOptHdr;
        short s = testSize = this.ntHeader.getOptionalHeader().is64bit() ? (short)240 : 224;
        if (sizeOptHdr != testSize) {
            Msg.warn((Object)this, (Object)("Non-standard optional header size: " + sizeOptHdr + " bytes"));
        }
        return ptrToSections;
    }

    void processSections(OptionalHeader optHeader) throws IOException {
        long oldIndex = this.reader.getPointerIndex();
        int tmpIndex = this.getPointerToSections();
        if (this.numberOfSections < 0) {
            Msg.error((Object)this, (Object)("Number of sections = " + this.numberOfSections));
        } else if (optHeader.getFileAlignment() == 0) {
            Msg.error((Object)this, (Object)"File alignment == 0: section processing skipped");
        } else {
            long stringTableOffset = this.getStringTableOffset();
            this.sectionHeaders = new SectionHeader[this.numberOfSections];
            for (int i = 0; i < this.numberOfSections; ++i) {
                this.sectionHeaders[i] = SectionHeader.readSectionHeader(this.reader, tmpIndex, stringTableOffset);
                int pointerToRawData = this.sectionHeaders[i].getPointerToRawData();
                int sizeOfRawData = (int)Math.min(this.reader.length() - (long)pointerToRawData, (long)this.sectionHeaders[i].getSizeOfRawData());
                int virtualAddress = this.sectionHeaders[i].getVirtualAddress();
                int virtualSize = this.sectionHeaders[i].getVirtualSize();
                int alignedVirtualAddress = PortableExecutable.computeAlignment(virtualAddress, optHeader.getSectionAlignment());
                int alignedVirtualSize = PortableExecutable.computeAlignment(virtualSize, optHeader.getSectionAlignment());
                if (virtualAddress == alignedVirtualAddress) {
                    if (sizeOfRawData > virtualSize) {
                        this.sectionHeaders[i].setVirtualSize(Math.min(sizeOfRawData, alignedVirtualSize));
                    }
                } else {
                    Msg.warn((Object)this, (Object)("Section " + this.sectionHeaders[i].getName() + " is not aligned!"));
                }
                tmpIndex += 40;
            }
        }
        this.reader.setPointerIndex(oldIndex);
    }

    void processImageRuntimeFunctionEntries() throws IOException {
        FileHeader fh = this.ntHeader.getFileHeader();
        SectionHeader[] sections = fh.getSectionHeaders();
        SectionHeader irfeHeader = null;
        for (SectionHeader header : sections) {
            if (!header.getName().equals(".pdata")) continue;
            irfeHeader = header;
            break;
        }
        if (irfeHeader == null) {
            return;
        }
        long oldIndex = this.reader.getPointerIndex();
        int start = irfeHeader.getPointerToRawData();
        this.reader.setPointerIndex(start);
        ImageRuntimeFunctionEntries entries = ImageRuntimeFunctionEntries.createImageRuntimeFunctionEntries(this.reader, start, this.ntHeader);
        this.irfes = entries.getRuntimeFunctionEntries();
        this.reader.setPointerIndex(oldIndex);
    }

    void processSymbols() throws IOException {
        if (this.isLordPE()) {
            return;
        }
        long oldIndex = this.reader.getPointerIndex();
        int tmpIndex = this.getPointerToSymbolTable();
        if (!this.ntHeader.checkRVA(tmpIndex)) {
            Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(tmpIndex)));
            return;
        }
        if (this.numberOfSymbols < 0 || (long)this.numberOfSymbols > this.reader.length()) {
            Msg.error((Object)this, (Object)("Invalid symbol count " + Integer.toHexString(this.numberOfSymbols)));
            return;
        }
        long stringTableOffset = this.getStringTableOffset();
        for (int i = 0; i < this.numberOfSymbols; ++i) {
            if (!this.ntHeader.checkRVA(tmpIndex)) {
                Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(tmpIndex)));
                break;
            }
            DebugCOFFSymbol symbol = DebugCOFFSymbol.createDebugCOFFSymbol(this.reader, tmpIndex, stringTableOffset);
            tmpIndex += 18;
            tmpIndex += 18 * symbol.getNumberOfAuxSymbols();
            int numberOfAuxSymbols = symbol.getNumberOfAuxSymbols();
            i += numberOfAuxSymbols > 0 ? numberOfAuxSymbols : 0;
            this.symbols.add(symbol);
        }
        this.reader.setPointerIndex(oldIndex);
    }

    long getStringTableOffset() throws IOException {
        if (this.pointerToSymbolTable <= 0 || !this.ntHeader.checkRVA(this.pointerToSymbolTable) || this.numberOfSymbols < 0 || (long)(this.pointerToSymbolTable + this.numberOfSymbols * 18) > this.reader.length()) {
            return -1L;
        }
        return this.pointerToSymbolTable + 18 * this.numberOfSymbols;
    }

    public boolean isLordPE() {
        return this.getPointerToSymbolTable() == 1919896667 && this.getNumberOfSymbols() == 1564823652;
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.startIndex);
        this.machine = this.reader.readNextShort();
        this.numberOfSections = this.reader.readNextShort();
        this.timeDateStamp = this.reader.readNextInt();
        this.pointerToSymbolTable = this.reader.readNextInt();
        this.numberOfSymbols = this.reader.readNextInt();
        this.sizeOfOptionalHeader = this.reader.readNextShort();
        this.characteristics = this.reader.readNextShort();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, 2, "Machine", this.getMachineName());
        struct.add(WORD, 2, "NumberOfSections", null);
        struct.add(DWORD, 4, "TimeDateStamp", null);
        struct.add(DWORD, 4, "PointerToSymbolTable", null);
        struct.add(DWORD, 4, "NumberOfSymbols", null);
        struct.add(WORD, 2, "SizeOfOptionalHeader", null);
        struct.add(WORD, 2, "Characteristics", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    private void setSectionHeaders(SectionHeader[] sectionHeaders) {
        this.sectionHeaders = sectionHeaders;
        this.numberOfSections = (short)sectionHeaders.length;
    }

    void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.write(dc.getBytes(this.machine));
        raf.write(dc.getBytes(this.numberOfSections));
        raf.write(dc.getBytes(this.timeDateStamp));
        raf.write(dc.getBytes(this.pointerToSymbolTable));
        raf.write(dc.getBytes(this.numberOfSymbols));
        raf.write(dc.getBytes(this.sizeOfOptionalHeader));
        raf.write(dc.getBytes(this.characteristics));
    }

    public void addSection(MemoryBlock block, OptionalHeader optionalHeader) {
        DebugDataDirectory ddd;
        BoundImportDataDirectory bidd;
        DataDirectory[] directories = optionalHeader.getDataDirectories();
        DataDirectory[] dataDirectories = optionalHeader.getDataDirectories();
        SecurityDataDirectory sdd = null;
        if (dataDirectories.length > 4 && (sdd = (SecurityDataDirectory)dataDirectories[4]) != null && sdd.getSize() > 0) {
            sdd.updatePointers(PortableExecutable.computeAlignment((int)block.getSize(), optionalHeader.getFileAlignment()));
        }
        int lastPos = this.computeAlignedNewPosition(optionalHeader, directories);
        SectionHeader newSection = new SectionHeader(block, optionalHeader, lastPos);
        SectionHeader[] newSectionHeaders = new SectionHeader[this.sectionHeaders.length + 1];
        System.arraycopy(this.sectionHeaders, 0, newSectionHeaders, 0, this.sectionHeaders.length);
        newSectionHeaders[this.sectionHeaders.length] = newSection;
        this.setSectionHeaders(newSectionHeaders);
        int firstSectionStart = this.sectionHeaders[0].getPointerToRawData();
        int lastSectionEnd = this.sectionHeaders[this.sectionHeaders.length - 1].getPointerToRawData() + this.sectionHeaders[this.sectionHeaders.length - 1].getSizeOfRawData();
        for (int i = 0; i < directories.length; ++i) {
            if (directories[i] == null || directories[i].getSize() == 0 || directories[i].isContainedInSection()) continue;
            if (directories[i].getVirtualAddress() < firstSectionStart && i != 11) {
                throw new RuntimeException("PE - Unexpected directory before sections: " + i);
            }
            if (directories[i].getVirtualAddress() <= lastSectionEnd || i == 4) continue;
            throw new RuntimeException("PE - Unexpected directory after sections: " + i);
        }
        int offset = 0;
        if (dataDirectories.length > 11 && (bidd = (BoundImportDataDirectory)dataDirectories[11]) != null && bidd.getSize() > 0) {
            bidd.updatePointers(40);
            int endptr = bidd.getVirtualAddress() + bidd.getSize() - 1;
            if (endptr >= this.sectionHeaders[0].getPointerToRawData()) {
                int alignedPtr = PortableExecutable.computeAlignment(endptr, optionalHeader.getFileAlignment());
                offset = alignedPtr - this.sectionHeaders[0].getPointerToRawData();
                for (SectionHeader sectionHeader : this.sectionHeaders) {
                    sectionHeader.updatePointers(offset);
                }
                optionalHeader.setSizeOfHeaders(this.sectionHeaders[0].getPointerToRawData());
            }
        }
        if (dataDirectories.length > 6 && (ddd = (DebugDataDirectory)dataDirectories[6]) != null && ddd.getSize() > 0 && ddd.getVirtualAddress() > newSection.getVirtualAddress()) {
            if (sdd != null && sdd.getSize() > 0) {
                ddd.updatePointers(offset, sdd.getVirtualAddress() + sdd.getSize());
            } else {
                ddd.updatePointers(offset, newSection.getSizeOfRawData());
            }
        }
        if (block.isExecute()) {
            optionalHeader.setSizeOfCode(optionalHeader.getSizeOfCode() + (long)newSection.getSizeOfRawData());
        } else {
            optionalHeader.setSizeOfInitializedData(optionalHeader.getSizeOfInitializedData() + (long)newSection.getSizeOfRawData());
        }
        int soi = newSection.getVirtualAddress() + newSection.getSizeOfRawData();
        soi = PortableExecutable.computeAlignment(soi, optionalHeader.getSectionAlignment());
        optionalHeader.setSizeOfImage(soi);
    }

    private int computeAlignedNewPosition(OptionalHeader optionalHeader, DataDirectory[] directories) {
        int lastPos = 0;
        for (SectionHeader sectionHeader : this.sectionHeaders) {
            if (sectionHeader.getPointerToRawData() + sectionHeader.getSizeOfRawData() <= lastPos) continue;
            lastPos = sectionHeader.getPointerToRawData() + sectionHeader.getSizeOfRawData();
        }
        for (StructConverter structConverter : directories) {
            if (structConverter == null || ((DataDirectory)structConverter).getSize() == 0 || ((DataDirectory)structConverter).rvaToPointer() + ((DataDirectory)structConverter).getSize() <= lastPos) continue;
            lastPos = ((DataDirectory)structConverter).rvaToPointer() + ((DataDirectory)structConverter).getSize();
        }
        return PortableExecutable.computeAlignment(lastPos, optionalHeader.getFileAlignment());
    }
}

