/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Conv;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LoadConfigDirectory
implements StructConverter {
    public static final String NAME32 = "IMAGE_LOAD_CONFIG_DIRECTORY32";
    public static final String NAME64 = "IMAGE_LOAD_CONFIG_DIRECTORY64";
    private int size;
    private int timeDateStamp;
    private short majorVersion;
    private short minorVersion;
    private int globalFlagsClear;
    private int globalFlagsSet;
    private int criticalSectionDefaultTimeout;
    private long deCommitFreeBlockThreshold;
    private long deCommitTotalFreeThreshold;
    private long lockPrefixTable;
    private long maximumAllocationSize;
    private long virtualMemoryThreshold;
    private long processAffinityMask;
    private int processHeapFlags;
    private short csdVersion;
    private short dependentLoadFlags;
    private long editList;
    private long securityCookie;
    private long seHandlerTable;
    private long seHandlerCount;
    private long guardCfcCheckFunctionPointer;
    private long guardCfDispatchFunctionPointer;
    private long guardCfFunctionTable;
    private long guardCfFunctionCount;
    private GuardFlags guardFlags;
    private CodeIntegrity codeIntegrity;
    private long guardAddressTakenIatEntryTable;
    private long guardAddressTakenIatEntryCount;
    private long guardLongJumpTargetTable;
    private long guardLongJumpTargetCount;
    private long dynamicValueRelocTable;
    private long chpeMetadataPointer;
    private long guardRfFailureRoutine;
    private long guardRfFailureRoutineFunctionPointer;
    private int dynamicValueRelocTableOffset;
    private short dynamicValueRelocTableSection;
    private short reserved1;
    private long guardRfVerifyStackPointerFunctionPointer;
    private int hotPatchTableOffset;
    private int reserved2;
    private long reserved3;
    private boolean is64bit;

    static LoadConfigDirectory createLoadConfigDirectory(FactoryBundledWithBinaryReader reader, int index, OptionalHeader oh) throws IOException {
        LoadConfigDirectory loadConfigDirectory = (LoadConfigDirectory)reader.getFactory().create(LoadConfigDirectory.class, new Object[0]);
        loadConfigDirectory.initLoadConfigDirectory(reader, index, oh);
        return loadConfigDirectory;
    }

    private void initLoadConfigDirectory(FactoryBundledWithBinaryReader reader, int index, OptionalHeader oh) throws IOException {
        this.is64bit = oh.is64bit();
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(index);
        this.size = reader.readNextInt();
        this.timeDateStamp = reader.readNextInt();
        this.majorVersion = reader.readNextShort();
        this.minorVersion = reader.readNextShort();
        this.globalFlagsClear = reader.readNextInt();
        this.globalFlagsSet = reader.readNextInt();
        this.criticalSectionDefaultTimeout = reader.readNextInt();
        this.deCommitFreeBlockThreshold = this.readPointer(reader);
        this.deCommitTotalFreeThreshold = this.readPointer(reader);
        this.lockPrefixTable = this.readPointer(reader);
        this.maximumAllocationSize = this.readPointer(reader);
        this.virtualMemoryThreshold = this.readPointer(reader);
        if (this.is64bit) {
            this.processAffinityMask = this.readPointer(reader);
            this.processHeapFlags = reader.readNextInt();
        } else {
            this.processHeapFlags = reader.readNextInt();
            this.processAffinityMask = this.readPointer(reader);
        }
        this.csdVersion = reader.readNextShort();
        this.dependentLoadFlags = reader.readNextShort();
        this.editList = this.readPointer(reader);
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.securityCookie = this.readPointer(reader);
            this.seHandlerTable = this.readPointer(reader);
            this.seHandlerCount = this.readPointer(reader);
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.guardCfcCheckFunctionPointer = this.readPointer(reader);
            this.guardCfDispatchFunctionPointer = this.readPointer(reader);
            this.guardCfFunctionTable = this.readPointer(reader);
            this.guardCfFunctionCount = this.readPointer(reader);
            this.guardFlags = new GuardFlags(reader.readNextInt());
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.codeIntegrity = new CodeIntegrity(reader);
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.guardAddressTakenIatEntryTable = this.readPointer(reader);
            this.guardAddressTakenIatEntryCount = this.readPointer(reader);
            this.guardLongJumpTargetTable = this.readPointer(reader);
            this.guardLongJumpTargetCount = this.readPointer(reader);
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.dynamicValueRelocTable = this.readPointer(reader);
            this.chpeMetadataPointer = this.readPointer(reader);
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.guardRfFailureRoutine = this.readPointer(reader);
            this.guardRfFailureRoutineFunctionPointer = this.readPointer(reader);
            this.dynamicValueRelocTableOffset = reader.readNextInt();
            this.dynamicValueRelocTableSection = reader.readNextShort();
            this.reserved1 = reader.readNextShort();
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.guardRfVerifyStackPointerFunctionPointer = this.readPointer(reader);
            this.hotPatchTableOffset = reader.readNextInt();
        }
        if (reader.getPointerIndex() - (long)index < (long)this.size) {
            this.reserved2 = reader.readNextInt();
            this.reserved3 = this.readPointer(reader);
        }
        reader.setPointerIndex(oldIndex);
    }

    public int getSize() {
        return this.size;
    }

    public int getCriticalSectionDefaultTimeout() {
        return this.criticalSectionDefaultTimeout;
    }

    public long getSeHandlerTable() {
        return this.seHandlerTable;
    }

    public long getSeHandlerCount() {
        return this.seHandlerCount;
    }

    public GuardFlags getCfgGuardFlags() {
        return this.guardFlags;
    }

    public long getCfgCheckFunctionPointer() {
        return this.guardCfcCheckFunctionPointer;
    }

    public long getCfgDispatchFunctionPointer() {
        return this.guardCfDispatchFunctionPointer;
    }

    public long getCfgFunctionTablePointer() {
        return this.guardCfFunctionTable;
    }

    public long getCfgFunctionCount() {
        return this.guardCfFunctionCount;
    }

    public long getGuardAddressIatTableTablePointer() {
        return this.guardAddressTakenIatEntryTable;
    }

    public long getGuardAddressIatTableCount() {
        return this.guardAddressTakenIatEntryCount;
    }

    public long getRfgFailureRoutine() {
        return this.guardRfFailureRoutine;
    }

    public long getRfgFailureRoutineFunctionPointer() {
        return this.guardRfFailureRoutineFunctionPointer;
    }

    public long getRfgVerifyStackPointerFunctionPointer() {
        return this.guardRfVerifyStackPointerFunctionPointer;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(this.is64bit ? NAME64 : NAME32, 0);
        DataType counter = this.is64bit ? QWORD : DWORD;
        Pointer64DataType ptr = this.is64bit ? new Pointer64DataType() : new Pointer32DataType();
        struct.add(DWORD, "Size", null);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(WORD, "MajorVersion", null);
        struct.add(WORD, "MinorVersion", null);
        struct.add(DWORD, "GlobalFlagsClear", null);
        struct.add(DWORD, "GlobalFlagsSet", null);
        struct.add(DWORD, "CriticalSectionDefaultTimeout", null);
        struct.add(counter, "DeCommitFreeBlockThreshold", null);
        struct.add(counter, "DeCommitTotalFreeThreshold", null);
        struct.add((DataType)ptr, "LockPrefixTable", null);
        struct.add(counter, "MaximumAllocationSize", null);
        struct.add(counter, "VirtualMemoryThreshold", null);
        if (this.is64bit) {
            struct.add(counter, "ProcessAffinityMask", null);
            struct.add(DWORD, "ProcessHeapFlags", null);
        } else {
            struct.add(DWORD, "ProcessHeapFlags", null);
            struct.add(counter, "ProcessAffinityMask", null);
        }
        struct.add(WORD, "CsdVersion", null);
        struct.add(WORD, "DependentLoadFlags", null);
        struct.add((DataType)ptr, "EditList", null);
        if (struct.getLength() < this.size) {
            struct.add((DataType)ptr, "SecurityCookie", null);
            struct.add((DataType)ptr, "SEHandlerTable", null);
            struct.add(counter, "SEHandlerCount", null);
        }
        if (struct.getLength() < this.size) {
            struct.add((DataType)ptr, "GuardCFCCheckFunctionPointer", null);
            struct.add((DataType)ptr, "GuardCFDispatchFunctionPointer", null);
            struct.add((DataType)ptr, "GuardCFFunctionTable", null);
            struct.add(counter, "GuardCFFunctionCount", null);
            struct.add(this.guardFlags.toDataType(), "GuardFlags", null);
        }
        if (struct.getLength() < this.size) {
            struct.add(this.codeIntegrity.toDataType(), "CodeIntegrity", null);
        }
        if (struct.getLength() < this.size) {
            struct.add((DataType)ptr, "GuardAddressTakenIatEntryTable", null);
            struct.add(counter, "GuardAddressTakenIatEntryCount", null);
            struct.add((DataType)ptr, "GuardLongJumpTargetTable", null);
            struct.add(counter, "GuardLongJumpTargetCount", null);
        }
        if (struct.getLength() < this.size) {
            struct.add((DataType)ptr, "DynamicValueRelocTable", null);
            struct.add((DataType)ptr, "CHPEMetadataPointer", null);
        }
        if (struct.getLength() < this.size) {
            struct.add((DataType)ptr, "GuardRFFailureRoutine", null);
            struct.add((DataType)ptr, "GuardRFFailureRoutineFunctionPointer", null);
            struct.add(DWORD, "DynamicValueRelocTableOffset", null);
            struct.add(WORD, "DynamicValueRelocTableSection", null);
            struct.add(WORD, "Reserved1", null);
        }
        if (struct.getLength() < this.size) {
            struct.add((DataType)ptr, "GuardRFVerifyStackPointerFunctionPointer", null);
            struct.add(DWORD, "HotPatchTableOffset", null);
        }
        if (struct.getLength() < this.size) {
            struct.add(DWORD, "Reserved2", null);
            struct.add(counter, "Reserved3", null);
        }
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    private long readPointer(BinaryReader reader) throws IOException {
        if (this.is64bit) {
            return reader.readNextLong();
        }
        return (long)reader.readNextInt() & 0xFFFFFFFFL;
    }

    static class CodeIntegrity
    implements StructConverter {
        public static final String NAME = "IMAGE_LOAD_CONFIG_CODE_INTEGRITY";
        private short flags;
        private short catalog;
        private int catalogOffset;
        private int reserved;

        public CodeIntegrity(BinaryReader reader) throws IOException {
            this.flags = reader.readNextShort();
            this.catalog = reader.readNextShort();
            this.catalogOffset = reader.readNextInt();
            this.reserved = reader.readNextInt();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("flags=0x" + Integer.toHexString(Conv.shortToInt((short)this.flags)));
            sb.append(", catalog=0x" + Integer.toHexString(Conv.shortToInt((short)this.catalog)));
            sb.append(", catalogOffset=0x" + Integer.toHexString(this.catalogOffset));
            sb.append(", reserved=0x" + Integer.toHexString(this.reserved));
            return sb.toString();
        }

        @Override
        public DataType toDataType() throws DuplicateNameException {
            StructureDataType struct = new StructureDataType(NAME, 0);
            struct.add(WORD, "Flags", null);
            struct.add(WORD, "Catalog", null);
            struct.add(DWORD, "CatalogOffset", null);
            struct.add(DWORD, "Reserved", null);
            struct.setCategoryPath(new CategoryPath("/PE"));
            return struct;
        }
    }

    static class GuardFlags
    implements StructConverter {
        public static final String NAME = "IMAGE_GUARD_FLAGS";
        private int flags;

        public GuardFlags(int flags) {
            this.flags = flags;
        }

        public int getFlags() {
            return this.flags;
        }

        @Override
        public DataType toDataType() throws DuplicateNameException {
            EnumDataType enumDt = new EnumDataType(NAME, 4);
            enumDt.add("IMAGE_GUARD_CF_INSTRUMENTED", 256L);
            enumDt.add("IMAGE_GUARD_CFW_INSTRUMENTED", 512L);
            enumDt.add("IMAGE_GUARD_CF_FUNCTION_TABLE_PRESENT", 1024L);
            enumDt.add("IMAGE_GUARD_SECURITY_COOKIE_UNUSED", 2048L);
            enumDt.add("IMAGE_GUARD_PROTECT_DELAYLOAD_IAT", 4096L);
            enumDt.add("IMAGE_GUARD_DELAYLOAD_IAT_IN_ITS_OWN_SECTION", 8192L);
            enumDt.add("IMAGE_GUARD_CF_EXPORT_SUPPRESSION_INFO_PRESENT", 16384L);
            enumDt.add("IMAGE_GUARD_CF_ENABLE_EXPORT_SUPPRESSION", 32768L);
            enumDt.add("IMAGE_GUARD_CF_LONGJUMP_TABLE_PRESENT", 65536L);
            enumDt.add("IMAGE_GUARD_RF_INSTRUMENTED", 131072L);
            enumDt.add("IMAGE_GUARD_RF_ENABLE", 262144L);
            enumDt.add("IMAGE_GUARD_RF_STRICT", 524288L);
            enumDt.add("IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK_1", 0x10000000L);
            enumDt.add("IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK_2", 0x20000000L);
            enumDt.add("IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK_4", 0x40000000L);
            enumDt.add("IMAGE_GUARD_CF_FUNCTION_TABLE_SIZE_MASK_8", 0x80000000L);
            enumDt.setCategoryPath(new CategoryPath("/PE"));
            return enumDt;
        }
    }
}

