/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.util.Conv;
import java.io.IOException;

public class OMFSrcModuleLine {
    private short seg;
    private short cPair;
    private int[] offsets;
    private short[] linenumbers;

    static OMFSrcModuleLine createOMFSrcModuleLine(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        OMFSrcModuleLine omfSrcModuleLine = (OMFSrcModuleLine)reader.getFactory().create(OMFSrcModuleLine.class, new Object[0]);
        omfSrcModuleLine.initOMFSrcModuleLine(reader, ptr);
        return omfSrcModuleLine;
    }

    private void initOMFSrcModuleLine(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        int i;
        int index = ptr;
        this.seg = reader.readShort(index);
        this.cPair = reader.readShort(index += 2);
        index += 2;
        this.offsets = new int[Conv.shortToInt((short)this.cPair)];
        for (i = 0; i < Conv.shortToInt((short)this.cPair); ++i) {
            this.offsets[i] = reader.readInt(index);
            index += 4;
        }
        this.linenumbers = new short[Conv.shortToInt((short)this.cPair)];
        for (i = 0; i < Conv.shortToInt((short)this.cPair); ++i) {
            this.linenumbers[i] = reader.readShort(index);
            index += 2;
        }
    }

    public short getPairCount() {
        return this.cPair;
    }

    public short[] getLinenumbers() {
        return this.linenumbers;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public short getSegmentIndex() {
        return this.seg;
    }

    int getByteCount() {
        return 4 + 4 * this.cPair + 2 * this.cPair;
    }
}

