/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.program.database.data.TypedefSettings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import java.io.IOException;

class TypedefDB
extends DataTypeDB
implements TypeDef {
    private TypedefDBAdapter adapter;
    private SettingsDefinition[] settingsDef;

    public TypedefDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, TypedefDBAdapter adapter, DBRecord record) {
        super(dataMgr, cache, record);
        this.adapter = adapter;
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(2);
    }

    @Override
    protected String doGetName() {
        return this.record.getString(1);
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.getDataType().hasLanguageDependantLength();
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(1, name);
        this.adapter.updateRecord(this.record, true);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    @Override
    public boolean isZeroLength() {
        return this.getDataType().isZeroLength();
    }

    @Override
    public int getLength() {
        return this.getDataType().getLength();
    }

    @Override
    public String getDescription() {
        return this.getDataType().getDescription();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getDataType().getValue(buf, settings, length);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.getDataType().getValueClass(settings);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        this.checkIsValid();
        TypedefSettings ts = new TypedefSettings(super.getDefaultSettings(), settings);
        return this.getDataType().getRepresentation(buf, ts, length);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            if (this.checkIsValid() && dt == this.getDataType()) {
                this.notifySizeChanged(true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.lock.acquire();
        try {
            if (this.checkIsValid() && dt == this.getDataType()) {
                this.notifyAlignmentChanged(true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType getBaseDataType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataType dataType = this.getDataType();
            if (dataType instanceof TypeDef) {
                DataType dataType2 = ((TypeDef)dataType).getBaseDataType();
                return dataType2;
            }
            DataType dataType3 = dataType;
            return dataType3;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType getDataType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long dataTypeID = this.record.getLongValue(0);
            DataType dt = this.dataMgr.getDataType(dataTypeID);
            if (dt == null) {
                dt = DataType.DEFAULT;
            }
            DataType dataType = dt;
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        return new TypedefDataType(this.getCategoryPath(), this.getName(), this.getDataType(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return new TypedefDataType(this.getCategoryPath(), this.getName(), this.getDataType(), dtm);
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeDef)) {
            return false;
        }
        TypeDef td = (TypeDef)obj;
        this.checkIsValid();
        if (!DataTypeUtilities.equalsIgnoreConflict(this.getName(), td.getName())) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), td.getDataType());
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(2, categoryID);
        this.adapter.updateRecord(this.record, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        block10: {
            if (newDt == this || newDt instanceof Dynamic || newDt instanceof FactoryDataType) {
                newDt = DataType.DEFAULT;
            }
            this.lock.acquire();
            try {
                if (!this.checkIsValid() || this.getDataType() != oldDt) break block10;
                oldDt.removeParent(this);
                newDt = this.resolve(newDt);
                newDt.addParent(this);
                this.record.setLongValue(0, this.dataMgr.getResolvedID(newDt));
                try {
                    this.adapter.updateRecord(this.record, true);
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                if (oldDt.getLength() != newDt.getLength()) {
                    this.notifySizeChanged(false);
                } else if (oldDt.getAlignment() != newDt.getAlignment()) {
                    this.notifyAlignmentChanged(false);
                } else {
                    this.dataMgr.dataTypeChanged(this, false);
                }
            }
            finally {
                this.lock.release();
            }
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.getDataType() == dt) {
            this.dataMgr.addDataTypeToDelete(this.key);
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.settingsDef == null) {
                DataType dt = this.getDataType();
                this.settingsDef = dt.getSettingsDefinitions();
            }
            SettingsDefinition[] settingsDefinitionArray = this.settingsDef;
            return settingsDefinitionArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String toString() {
        return "typedef " + this.getName() + " " + this.getDataType().getName();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(6);
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(5);
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(4));
    }

    @Override
    protected void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(4, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(3));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(3, id.getValue());
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(6, lastChangeTime);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(5, lastChangeTimeInSourceArchive);
            this.adapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof TypeDef)) {
            throw new UnsupportedOperationException();
        }
        if (dataType != this) {
            this.dataTypeReplaced(this.getDataType(), ((TypeDef)dataType).getDataType());
        }
    }
}

