/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.lldb;

import SWIG.SBBreakpoint;
import SWIG.SBBreakpointLocation;
import SWIG.SBEvent;
import SWIG.SBFrame;
import SWIG.SBFunction;
import SWIG.SBLaunchInfo;
import SWIG.SBListener;
import SWIG.SBMemoryRegionInfo;
import SWIG.SBModule;
import SWIG.SBProcess;
import SWIG.SBSection;
import SWIG.SBSymbol;
import SWIG.SBTarget;
import SWIG.SBThread;
import SWIG.SBValue;
import SWIG.SBWatchpoint;
import SWIG.StateType;
import agent.lldb.lldb.DebugClientImpl;
import agent.lldb.lldb.DebugClientReentrant;
import agent.lldb.lldb.DebugOutputCallbacks;
import agent.lldb.lldb.DebugServerId;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.LldbManager;
import ghidra.comm.util.BitmaskUniverse;
import ghidra.dbg.target.TargetExecutionStateful;
import java.util.List;
import java.util.Map;

public interface DebugClient
extends DebugClientReentrant {
    public static DebugClient debugCreate() {
        return new DebugClientImpl();
    }

    public static String getModelKey(Object modelObject) {
        if (modelObject == null) {
            return null;
        }
        return modelObject.getClass() + ":" + DebugClient.getId(modelObject);
    }

    public static String getId(Object modelObject) {
        if (modelObject instanceof SBTarget) {
            SBTarget session = (SBTarget)modelObject;
            return Integer.toHexString(session.GetProcess().GetProcessID().intValue());
        }
        if (modelObject instanceof SBProcess) {
            SBProcess process = (SBProcess)modelObject;
            return Integer.toHexString(process.GetProcessID().intValue());
        }
        if (modelObject instanceof SBThread) {
            SBThread thread = (SBThread)modelObject;
            return Integer.toHexString(thread.GetThreadID().intValue());
        }
        if (modelObject instanceof SBFrame) {
            SBFrame frame = (SBFrame)modelObject;
            int frameId = (int)frame.GetFrameID();
            if (frameId < 0) {
                frameId = 0;
            }
            return Integer.toString(frameId);
        }
        if (modelObject instanceof SBValue) {
            SBValue val = (SBValue)modelObject;
            return val.GetName();
        }
        if (modelObject instanceof SBModule) {
            SBModule module = (SBModule)modelObject;
            return module.GetFileSpec().GetFilename();
        }
        if (modelObject instanceof SBSection) {
            SBSection section = (SBSection)modelObject;
            return section.GetName() + ":" + section.GetFileAddress();
        }
        if (modelObject instanceof SBMemoryRegionInfo) {
            SBMemoryRegionInfo region = (SBMemoryRegionInfo)modelObject;
            return Long.toHexString(region.GetRegionBase().longValue());
        }
        if (modelObject instanceof SBSymbol) {
            SBSymbol sym = (SBSymbol)modelObject;
            return sym.GetName();
        }
        if (modelObject instanceof SBBreakpoint) {
            SBBreakpoint spec = (SBBreakpoint)modelObject;
            return "B" + Integer.toHexString(spec.GetID());
        }
        if (modelObject instanceof SBWatchpoint) {
            SBWatchpoint spec = (SBWatchpoint)modelObject;
            return "W" + Integer.toHexString(spec.GetID());
        }
        if (modelObject instanceof SBBreakpointLocation) {
            SBBreakpointLocation loc = (SBBreakpointLocation)modelObject;
            return Long.toHexString(loc.GetLoadAddress().longValue());
        }
        if (modelObject instanceof SBFunction) {
            SBFunction fn = (SBFunction)modelObject;
            return fn.GetName();
        }
        throw new RuntimeException("Unknown object " + modelObject.getClass());
    }

    public static TargetExecutionStateful.TargetExecutionState convertState(StateType state) {
        switch (state.swigValue()) {
            case 0: {
                return TargetExecutionStateful.TargetExecutionState.RUNNING;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return TargetExecutionStateful.TargetExecutionState.ALIVE;
            }
            case 5: {
                return TargetExecutionStateful.TargetExecutionState.STOPPED;
            }
            case 6: 
            case 7: {
                return TargetExecutionStateful.TargetExecutionState.RUNNING;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TargetExecutionStateful.TargetExecutionState.TERMINATED;
            }
        }
        return TargetExecutionStateful.TargetExecutionState.STOPPED;
    }

    @Override
    public SBListener getListener();

    public DebugServerId getLocalServer();

    public void setOutputCallbacks(DebugOutputCallbacks var1);

    public SBProcess attachProcess(DebugServerId var1, int var2, String var3, boolean var4, boolean var5);

    public SBProcess connectRemote(DebugServerId var1, String var2, boolean var3, boolean var4, boolean var5);

    public SBProcess createProcess(DebugServerId var1, String var2);

    public SBProcess createProcess(DebugServerId var1, String var2, List<String> var3, List<String> var4, String var5);

    public SBProcess createProcess(DebugServerId var1, SBLaunchInfo var2);

    public SBProcess createProcess(DebugServerId var1, String var2, List<String> var3, List<String> var4, List<String> var5, String var6, long var7, boolean var9);

    public void terminateCurrentProcess();

    public void destroyCurrentProcess();

    public void detachCurrentProcess();

    public SBTarget connectSession(String var1);

    public Map<String, SBTarget> listSessions();

    public void endSession(DebugEndSessionFlags var1);

    public void openDumpFileWide(String var1);

    public SBEvent waitForEvent();

    public DebugStatus getExecutionStatus();

    public void processEvent(LldbEvent<?> var1);

    public boolean getInterrupt();

    public void setManager(LldbManager var1);

    public void addBroadcaster(Object var1);

    public void execute(String var1);

    public static enum DebugOutputFlags {
        DEBUG_OUTPUT_NORMAL(1),
        DEBUG_OUTPUT_ERROR(2),
        DEBUG_OUTPUT_WARNING(4),
        DEBUG_OUTPUT_VERBOSE(8),
        DEBUG_OUTPUT_PROMPT(16),
        DEBUG_OUTPUT_PROMPT_REGISTERS(32),
        DEBUG_OUTPUT_EXTENSION_WARNING(64),
        DEBUG_OUTPUT_DEBUGGEE(128),
        DEBUG_OUTPUT_DEBUGGEE_PROMPT(256),
        DEBUG_OUTPUT_SYMBOLS(512);

        private final int value;

        private DebugOutputFlags(int value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static enum DebugEndSessionFlags {
        DEBUG_END_PASSIVE(0),
        DEBUG_END_ACTIVE_TERMINATE(1),
        DEBUG_END_ACTIVE_DETACH(2),
        DEBUG_END_REENTRANT(3),
        DEBUG_END_DISCONNECT(4);

        private final int value;

        private DebugEndSessionFlags(int value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static enum DebugCreateFlags implements BitmaskUniverse
    {
        LAUNCH_DEFAULT(0),
        LAUNCH_EXEC(1),
        LAUNCH_DEBUG(2),
        LAUNCH_STOP_AT_ENTRY(4),
        LAUNCH_DISABLE_ASLR(8),
        LAUNCH_DISABLE_STDIO(16),
        LAUNCH_IN_TTY(32),
        LAUNCH_IN_SHELL(64),
        LAUNCH_IN_SEP_GROUP(128),
        LAUNCH_DONT_SET_EXIT_STATUS(256),
        LAUNCH_DETACH_ON_ERROR(512),
        LAUNCH_SHELL_EXPAND_ARGS(1024),
        LAUNCH_CLOSE_TTY_ON_EXIT(2048),
        LAUNCH_INHERIT_FROM_PARENT(4096);

        private final int mask;

        private DebugCreateFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum DebugAttachFlags implements BitmaskUniverse
    {
        DEFAULT(0),
        NONINVASIVE(1),
        EXISTING(2),
        NONINVASIVE_NO_SUSPEND(4),
        INVASIVE_NO_INITIAL_BREAK(8),
        INVASIVE_RESUME_PROCESS(16),
        NONINVASIVE_ALLOW_PARTIAL(32);

        private final int mask;

        private DebugAttachFlags(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeThreadState implements BitmaskUniverse
    {
        THREAD_ALL(-1),
        THREAD_STACK_CHANGED(SBThread.eBroadcastBitStackChanged),
        THREAD_SUSPENDED(SBThread.eBroadcastBitThreadSuspended),
        THREAD_RESUMED(SBThread.eBroadcastBitThreadResumed),
        THREAD_FRAME_CHANGED(SBThread.eBroadcastBitSelectedFrameChanged),
        THREAD_SELECTED(SBThread.eBroadcastBitThreadSelected);

        private final int mask;

        private ChangeThreadState(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeProcessState implements BitmaskUniverse
    {
        PROCESS_ALL(-1),
        PROCESS_STATE_CHANGED(SBProcess.eBroadcastBitStateChanged),
        PROCESS_INTERRUPT(SBProcess.eBroadcastBitInterrupt),
        PROCESS_STDOUT(SBProcess.eBroadcastBitSTDOUT),
        PROCESS_STDERR(SBProcess.eBroadcastBitSTDERR),
        PROCESS_PROFILE_DATA(SBProcess.eBroadcastBitProfileData),
        PROCESS_STRUCTURED_DATA(SBProcess.eBroadcastBitStructuredData);

        private final int mask;

        private ChangeProcessState(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum ChangeSessionState implements BitmaskUniverse
    {
        SESSION_ALL(-1),
        SESSION_BREAKPOINT_CHANGED(SBTarget.eBroadcastBitBreakpointChanged),
        SESSION_MODULE_LOADED(SBTarget.eBroadcastBitModulesLoaded),
        SESSION_MODULE_UNLOADED(SBTarget.eBroadcastBitModulesUnloaded),
        SESSION_WATCHPOINT_CHANGED(SBTarget.eBroadcastBitWatchpointChanged),
        SESSION_SYMBOLS_LOADED(SBTarget.eBroadcastBitSymbolsLoaded);

        private final int mask;

        private ChangeSessionState(int mask) {
            this.mask = mask;
        }

        public long getMask() {
            return this.mask;
        }
    }

    public static enum SessionStatus {
        ACTIVE,
        END_SESSION_ACTIVE_TERMINATE,
        END_SESSION_ACTIVE_DETACH,
        END_SESSION_PASSIVE,
        END,
        REBOOT,
        HIBERNATE,
        FAILURE;

    }

    public static enum DebugStatus {
        NO_CHANGE(false, null, 13),
        GO(true, ExecutionState.RUNNING, 10),
        GO_HANDLED(true, ExecutionState.RUNNING, 9),
        GO_NOT_HANDLED(true, ExecutionState.RUNNING, 8),
        STEP_OVER(true, ExecutionState.RUNNING, 7),
        STEP_INTO(true, ExecutionState.RUNNING, 5),
        BREAK(false, ExecutionState.STOPPED, 0),
        NO_DEBUGGEE(true, null, 1),
        STEP_BRANCH(true, ExecutionState.RUNNING, 6),
        IGNORE_EVENT(false, null, 11),
        RESTART_REQUESTED(true, null, 12),
        REVERSE_GO(true, null, 255),
        REVERSE_STEP_BRANCH(true, null, 255),
        REVERSE_STEP_OVER(true, null, 255),
        REVERSE_STEP_INTO(true, null, 255),
        OUT_OF_SYNC(false, null, 2),
        WAIT_INPUT(false, null, 3),
        TIMEOUT(false, null, 4);

        public static final long MASK = 175L;
        public static final long INSIDE_WAIT = 0x100000000L;
        public static final long WAIT_TIMEOUT = 0x200000000L;
        public final boolean shouldWait;
        public final ExecutionState threadState;
        public final int precedence;

        private DebugStatus(boolean shouldWait, ExecutionState threadState, int precedence) {
            this.shouldWait = shouldWait;
            this.threadState = threadState;
            this.precedence = precedence;
        }

        public static DebugStatus fromArgument(StateType state) {
            if (state == null) {
                return NO_DEBUGGEE;
            }
            switch (state.swigValue()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return GO;
                }
                case 5: {
                    return BREAK;
                }
                case 6: {
                    return GO;
                }
                case 7: {
                    return STEP_INTO;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return NO_DEBUGGEE;
                }
            }
            return NO_CHANGE;
        }
    }

    public static enum ExecutionState {
        RUNNING,
        STOPPED;

    }
}

