/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.SBFrame;
import SWIG.SBStream;
import SWIG.SBThread;
import SWIG.StateType;
import agent.lldb.lldb.DebugClient;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbReason;
import agent.lldb.model.iface1.LldbModelTargetFocusScope;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetStack;
import agent.lldb.model.iface2.LldbModelTargetStackFrame;
import agent.lldb.model.iface2.LldbModelTargetStackFrameRegisterContainer;
import agent.lldb.model.iface2.LldbModelTargetThread;
import agent.lldb.model.impl.LldbModelTargetFunctionImpl;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetStackFrameRegisterContainerImpl;
import agent.lldb.model.impl.LldbModelTargetThreadImpl;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="StackFrame", attributeResync=TargetObjectSchema.ResyncMode.ALWAYS, elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Registers", type=LldbModelTargetStackFrameRegisterContainerImpl.class, required=true), @TargetAttributeType(name="Function", type=LldbModelTargetFunctionImpl.class), @TargetAttributeType(name="function", type=String.class), @TargetAttributeType(name="Inst. Offset", type=Address.class), @TargetAttributeType(name="Frame Offset", type=Address.class), @TargetAttributeType(name="Return Offset", type=Address.class), @TargetAttributeType(name="Call Frame Offset", type=Address.class), @TargetAttributeType(name="Stack Offset", type=Address.class), @TargetAttributeType(type=Void.class)})
public class LldbModelTargetStackFrameImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetStackFrame {
    protected final LldbModelTargetThread thread;
    protected Address pc;
    protected String func;
    protected String display;
    private final LldbModelTargetStackFrameRegisterContainerImpl registers;
    private final LldbModelTargetFunctionImpl function;
    private Long frameOffset = -1L;
    private Long stackOffset = -1L;
    private Long callFrameOffset = -1L;

    protected static String indexFrame(SBFrame frame) {
        return DebugClient.getId(frame);
    }

    protected static String keyFrame(SBFrame frame) {
        return PathUtils.makeKey((String)LldbModelTargetStackFrameImpl.indexFrame(frame));
    }

    public LldbModelTargetStackFrameImpl(LldbModelTargetStack stack, LldbModelTargetThread thread, SBFrame frame) {
        super(stack.getModel(), (TargetObject)stack, LldbModelTargetStackFrameImpl.keyFrame(frame), frame, "StackFrame");
        this.thread = thread;
        this.pc = this.getModel().getAddressSpace("ram").getAddress(-1L);
        if (!this.valid) {
            this.registers = null;
            this.function = null;
            return;
        }
        this.registers = new LldbModelTargetStackFrameRegisterContainerImpl(this);
        this.function = new LldbModelTargetFunctionImpl(this, frame.GetFunction());
        this.display = this.getDescription(0);
        this.changeAttributes(List.of(), List.of(this.registers, this.function), Map.of("_display", this.display, "_pc", this.pc), "Initialized");
        this.setFrame(frame);
        this.getManager().addEventsListener(this);
    }

    @Override
    public String getDescription(int level) {
        SBStream stream = new SBStream();
        SBFrame frame = (SBFrame)this.getModelObject();
        frame.GetDescription(stream);
        return stream.GetData();
    }

    protected static String computeDisplay(SBFrame frame) {
        if (frame.GetFunction() == null) {
            return String.format("#%d 0x%s", DebugClient.getId(frame), frame.GetPC().toString(16));
        }
        return String.format("#%d 0x%s in %s ()", DebugClient.getId(frame), frame.GetPC().toString(16), frame.GetDisplayFunctionName());
    }

    @Override
    public void threadSelected(SBThread eventThread, SBFrame eventFrame, LldbCause cause) {
        if (eventFrame != null && eventFrame.equals(this.getFrame())) {
            ((LldbModelTargetFocusScope)this.searchForSuitable(TargetFocusScope.class)).setFocus(this);
        }
    }

    @TargetAttributeType(name="Registers", required=true, fixed=true)
    public LldbModelTargetStackFrameRegisterContainer getRegisters() {
        return this.registers;
    }

    @Override
    public void setFrame(SBFrame frame) {
        if (!frame.IsValid()) {
            System.err.println("Frame is not valid");
        }
        this.setModelObject(frame);
        BigInteger address = frame.GetPC();
        long lval = address == null ? -1L : address.longValue();
        this.pc = this.getModel().getAddressSpace("ram").getAddress(lval);
        this.func = frame.GetFunctionName();
        if (this.func == null) {
            this.func = "UNKNOWN";
        }
        this.frameOffset = frame.GetFP().longValue();
        this.stackOffset = frame.GetSP().longValue();
        this.callFrameOffset = frame.GetCFA().longValue();
        AddressSpace space = this.getModel().getAddressSpace("ram");
        this.display = this.getDescription(0);
        this.changeAttributes(List.of(), List.of(), Map.of("_pc", this.pc, "_display", this.display, "function", this.func, "Inst. Offset", space.getAddress(lval), "Frame Offset", space.getAddress(this.frameOffset.longValue()), "Stack Offset", space.getAddress(this.stackOffset.longValue()), "Call Frame Offset", space.getAddress(this.callFrameOffset.longValue())), "Refreshed");
    }

    @Override
    public TargetObject getThread() {
        return this.thread;
    }

    public SBFrame getFrame() {
        return (SBFrame)this.getModelObject();
    }

    @Override
    public Address getPC() {
        return this.pc;
    }

    @Override
    public LldbModelTargetProcess getProcess() {
        return ((LldbModelTargetThreadImpl)this.thread).getProcess();
    }

    public void threadStateChangedSpecific(StateType state, LldbReason reason) {
        this.setFrame(this.getFrame());
        this.registers.threadStateChangedSpecific(state, reason);
    }
}

