/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.util.PseudoDisassembler;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Undefined2DataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.data.Undefined8DataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;

public class PowerPCAddressAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String OPTION_NAME_CHECK_NIBBLE = "Restrict Address to same 256M page";
    private static final String OPTION_DESCRIPTION_CHECK_NIBBLE = "";
    private static final boolean OPTION_DEFAULT_CHECK_HIGH_NIBBLE = false;
    private static final String OPTION_NAME_MARK_DUAL_INSTRUCTION = "Mark dual instruction references";
    private static final String OPTION_DESCRIPTION_MARK_DUAL_INSTRUCTION = "Turn on to mark all potential dual instruction refs,\n(lis - addi/orri/subi)\neven if they are not seen to be used as a reference.";
    private static final boolean OPTION_DEFAULT_MARK_DUAL_INSTRUCTION = false;
    private static final String OPTION_NAME_PROPAGATE_R2 = "Propagate r2 register value";
    private static final String OPTION_DESCRIPTION_PROPAGATE_R2 = "Propagate r2 register value into called functions\nto facilitate function descriptor resolution.";
    private static final String OPTION_NAME_PROPAGATE_R30 = "Propagate r30 register value";
    private static final String OPTION_DESCRIPTION_PROPAGATE_R30 = "Propagate r30 register value into called functions\n";
    private static final String SWITCH_OPTION_NAME = "Switch Table Recovery";
    private static final String SWITCH_OPTION_DESCRIPTION = "Turn on to recover switch tables";
    private static final boolean SWITCH_OPTION_DEFAULT_VALUE = true;
    private boolean markupDualInstructionOption = false;
    private boolean checkHighNibbleOption = false;
    private boolean propagateR2value;
    private boolean propagateR30value;
    private boolean recoverSwitchTables = true;
    private static final String PROCESSOR_NAME = "PowerPC";

    public PowerPCAddressAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
    }

    private boolean getDefaultPropagateR2Option(Program program) {
        boolean isELF = "Executable and Linking Format (ELF)".equals(program.getExecutableFormat());
        return isELF && program.getLanguage().getLanguageDescription().getSize() == 64;
    }

    private boolean getDefaultPropagateR30Option(Program program) {
        boolean isELF = "Executable and Linking Format (ELF)".equals(program.getExecutableFormat());
        boolean is32bit = program.getLanguage().getLanguageDescription().getSize() == 32;
        return isELF && is32bit && program.getSymbolTable().getSymbols("__DT_PPC_GOT").hasNext();
    }

    public void registerOptions(Options options, Program program) {
        super.registerOptions(options, program);
        options.registerOption(OPTION_NAME_CHECK_NIBBLE, (Object)this.checkHighNibbleOption, null, OPTION_DESCRIPTION_CHECK_NIBBLE);
        options.registerOption(OPTION_NAME_MARK_DUAL_INSTRUCTION, (Object)this.markupDualInstructionOption, null, OPTION_DESCRIPTION_MARK_DUAL_INSTRUCTION);
        options.registerOption(SWITCH_OPTION_NAME, (Object)this.recoverSwitchTables, null, SWITCH_OPTION_DESCRIPTION);
        options.registerOption(OPTION_NAME_PROPAGATE_R2, (Object)this.getDefaultPropagateR2Option(program), null, OPTION_DESCRIPTION_PROPAGATE_R2);
        options.registerOption(OPTION_NAME_PROPAGATE_R30, (Object)this.getDefaultPropagateR30Option(program), null, OPTION_DESCRIPTION_PROPAGATE_R30);
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        this.checkHighNibbleOption = options.getBoolean(OPTION_NAME_CHECK_NIBBLE, this.checkHighNibbleOption);
        this.markupDualInstructionOption = options.getBoolean(OPTION_NAME_MARK_DUAL_INSTRUCTION, this.markupDualInstructionOption);
        this.recoverSwitchTables = options.getBoolean(SWITCH_OPTION_NAME, this.recoverSwitchTables);
        this.propagateR2value = options.getBoolean(OPTION_NAME_PROPAGATE_R2, this.propagateR2value);
        this.propagateR30value = options.getBoolean(OPTION_NAME_PROPAGATE_R30, this.propagateR30value);
    }

    public AddressSet flowConstants(final Program program, Address flowStart, AddressSetView flowSet, final SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        RegisterValue initR2Value;
        final RegisterValue startingR2Value = initR2Value = this.lookupR2(program, flowStart);
        final boolean isPEF = "Preferred Executable Format (PEF)".equals(program.getExecutableFormat());
        final Register r2 = program.getRegister("r2");
        final Register r30 = program.getRegister("r30");
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor, this.trustWriteMemOption){

            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                return false;
            }

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                if (PowerPCAddressAnalyzer.this.markupDualInstructionOption) {
                    this.markupDualInstructions(context, instr);
                }
                if ((PowerPCAddressAnalyzer.this.propagateR2value || PowerPCAddressAnalyzer.this.propagateR30value) && instr.getFlowType().isCall()) {
                    Reference[] refs;
                    for (Reference ref : refs = instr.getReferencesFrom()) {
                        Address destAddr = ref.getToAddress();
                        if (PowerPCAddressAnalyzer.this.propagateR2value && program.getProgramContext().getRegisterValue(r2, destAddr) == null) {
                            PowerPCAddressAnalyzer.this.setRegisterIfNotSet(program, destAddr, startingR2Value);
                        }
                        if (!PowerPCAddressAnalyzer.this.propagateR30value) continue;
                        RegisterValue r30Value = context.getRegisterValue(r30);
                        PowerPCAddressAnalyzer.this.setRegisterIfNotSet(program, destAddr, r30Value);
                    }
                }
                if (PowerPCAddressAnalyzer.this.propagateR2value && isPEF && PowerPCAddressAnalyzer.this.isPEFCallingConvention(program, instr) && startingR2Value != null) {
                    context.setRegisterValue(startingR2Value);
                }
                return false;
            }

            private void markupDualInstructions(VarnodeContext context, Instruction instr) {
                BigInteger val;
                Register reg;
                String mnemonic = instr.getMnemonicString();
                if ((mnemonic.equals("subi") || mnemonic.equals("addi")) && (reg = instr.getRegister(0)) != null && (val = context.getValue(reg, false)) != null) {
                    long lval = val.longValue();
                    Address refAddr = instr.getMinAddress().getNewTruncatedAddress(lval, true);
                    if ((lval > 4096L || lval < 0L) && program.getMemory().contains(refAddr) && instr.getOperandReferences(2).length == 0) {
                        instr.addOperandReference(2, refAddr, RefType.DATA, SourceType.ANALYSIS);
                    }
                }
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                if (refType.isJump() && refType.isComputed() && program.getMemory().contains(address) && address.getOffset() != 0L) {
                    super.evaluateReference(context, instr, pcodeop, address, size, dataType, refType);
                    return !symEval.encounteredBranch();
                }
                String mnemonic = instr.getMnemonicString();
                if (mnemonic.equals("li") && instr.getScalar(1) != null) {
                    return false;
                }
                if (mnemonic.equals("lis")) {
                    return false;
                }
                if (mnemonic.startsWith("ld") || mnemonic.startsWith("lw") || mnemonic.startsWith("lb") || mnemonic.startsWith("st")) {
                    for (Object obj : instr.getOpObjects(1)) {
                        if (!(obj instanceof Scalar) || ((Scalar)obj).getUnsignedValue() != address.getOffset()) continue;
                        return false;
                    }
                }
                if (refType.isData()) {
                    return true;
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, dataType, refType);
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                String mnemonic = instruction.getMnemonicString();
                if (!instruction.getFlowType().isJump()) {
                    return false;
                }
                if ((mnemonic.equals("bcctr") || mnemonic.equals("bcctrl") || mnemonic.equals("bctr")) && !PowerPCAddressAnalyzer.this.checkAlreadyRecovered(instruction.getProgram(), instruction.getMinAddress())) {
                    this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
                }
                return false;
            }

            public Long unknownValue(VarnodeContext context, Instruction instruction, Varnode node) {
                Register reg;
                if (node.isRegister() && (reg = program.getRegister(node.getAddress())) != null) {
                    if (reg.getName().equals("xer_so")) {
                        return 0L;
                    }
                    if (PowerPCAddressAnalyzer.this.propagateR2value && reg.getName().equals("r2") && startingR2Value != null && startingR2Value.hasValue()) {
                        return startingR2Value.getUnsignedValue().longValue();
                    }
                }
                return null;
            }

            public boolean followFalseConditionalBranches() {
                return true;
            }

            public boolean evaluateSymbolicReference(VarnodeContext context, Instruction instr, Address address) {
                return false;
            }

            public boolean allowAccess(VarnodeContext context, Address addr) {
                return PowerPCAddressAnalyzer.this.trustWriteMemOption;
            }
        };
        eval.setTrustWritableMemory(this.trustWriteMemOption).setMinpeculativeOffset(this.minSpeculativeRefAddress).setMaxSpeculativeOffset(this.maxSpeculativeRefAddress).setMinStoreLoadOffset(this.minStoreLoadRefAddress).setCreateComplexDataFromPointers(this.createComplexDataFromPointers);
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        if (this.recoverSwitchTables) {
            this.recoverSwitches(program, symEval, eval.getDestinationSet(), monitor);
        }
        return resultSet;
    }

    private void setRegisterIfNotSet(Program program, Address addr, RegisterValue regValue) {
        if (regValue == null || !regValue.hasValue() || regValue.getUnsignedValue().equals(BigInteger.ZERO)) {
            return;
        }
        ProgramContext programContext = program.getProgramContext();
        RegisterValue oldValue = programContext.getRegisterValue(regValue.getRegister(), addr);
        if (oldValue != null && oldValue.hasValue() && !oldValue.getUnsignedValueIgnoreMask().equals(BigInteger.ZERO)) {
            return;
        }
        try {
            programContext.setRegisterValue(addr, addr, regValue);
            if (program.getListing().getFunctionAt(addr) != null) {
                AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager((Program)program);
                analysisMgr.functionDefined(addr);
                analysisMgr.codeDefined(addr);
            }
        }
        catch (ContextChangeException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
    }

    private RegisterValue lookupR2(Program program, Address flowStart) {
        RegisterValue initR2Value = null;
        if (this.propagateR2value && ((initR2Value = program.getProgramContext().getRegisterValue(program.getRegister("r2"), flowStart)) == null || !initR2Value.hasValue())) {
            initR2Value = this.findR2Value(program, flowStart);
            this.setRegisterIfNotSet(program, flowStart, initR2Value);
        }
        return initR2Value;
    }

    private boolean checkAlreadyRecovered(Program program, Address addr) {
        int referenceCountFrom = program.getReferenceManager().getReferenceCountFrom(addr);
        if (referenceCountFrom > 1) {
            return true;
        }
        Reference[] refs = program.getReferenceManager().getReferencesFrom(addr);
        return refs.length == 1 && !refs[0].getReferenceType().isData();
    }

    private void recoverSwitches(final Program program, SymbolicPropogator symEval, AddressSet destinationSet, TaskMonitor monitor) throws CancelledException {
        final ArrayList<Address> targetList = new ArrayList<Address>();
        class SwitchEvaluator
        implements ContextEvaluator {
            private static final int STARTING_MAX_TABLE_SIZE = 64;
            long tableIndexOffset;
            Address targetSwitchAddr = null;
            boolean hitTheGuard = false;
            Long assumeValue = 0L;
            int tableSizeMax = 64;

            SwitchEvaluator() {
            }

            public void setGuard(boolean hitGuard) {
                this.hitTheGuard = hitGuard;
            }

            public void setAssume(Long assume) {
                this.assumeValue = assume;
            }

            public void setTargetSwitchAddr(Address addr) {
                this.targetSwitchAddr = addr;
            }

            public int getMaxTableSize() {
                return this.tableSizeMax;
            }

            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                return false;
            }

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                Scalar scalar;
                Register reg;
                int numOps;
                String mnemonic = instr.getMnemonicString();
                if ((mnemonic.compareToIgnoreCase("cmpi") == 0 || mnemonic.compareToIgnoreCase("cmpwi") == 0 || mnemonic.compareToIgnoreCase("cmpli") == 0 || mnemonic.compareToIgnoreCase("cmplwi") == 0) && (numOps = instr.getNumOperands()) > 1 && (reg = instr.getRegister(numOps - 2)) != null && (scalar = instr.getScalar(numOps - 1)) != null) {
                    long lval;
                    int newTableSizeMax = (int)scalar.getSignedValue() + 1;
                    if (newTableSizeMax > 0 && newTableSizeMax < 128) {
                        this.tableSizeMax = newTableSizeMax;
                    }
                    this.hitTheGuard = true;
                    RegisterValue rval = context.getRegisterValue(reg);
                    context.clearRegister(reg);
                    if (rval != null && (lval = rval.getSignedValue().longValue()) < 0L) {
                        this.tableIndexOffset = -lval;
                    }
                }
                if (instr.getFlowType().isConditional()) {
                    this.hitTheGuard = true;
                }
                return false;
            }

            public Address evaluateConstant(VarnodeContext context, Instruction instr, int pcodeop, Address constant, int size, DataType dataType, RefType refType) {
                return null;
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
                if (!refType.isComputed() && !refType.isConditional() || !program.getMemory().contains(address)) {
                    if (refType.isRead()) {
                        PowerPCAddressAnalyzer.this.createDataType(program, instr, address);
                    }
                    return false;
                }
                if (!targetList.contains(address)) {
                    targetList.add(address);
                }
                return true;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                return instruction.getMinAddress().equals((Object)this.targetSwitchAddr);
            }

            public boolean evaluateReturn(Varnode retVN, VarnodeContext context, Instruction instruction) {
                return false;
            }

            public Long unknownValue(VarnodeContext context, Instruction instruction, Varnode node) {
                if (node.isRegister()) {
                    if (instruction.getFlowType().isJump()) {
                        return null;
                    }
                    Register reg = program.getRegister(node.getAddress());
                    if (reg != null && (reg.getName().equals("xer_so") || reg.getName().startsWith("cr"))) {
                        return 0L;
                    }
                    if (this.hitTheGuard) {
                        return this.assumeValue;
                    }
                }
                return null;
            }

            public boolean followFalseConditionalBranches() {
                return false;
            }

            public boolean evaluateSymbolicReference(VarnodeContext context, Instruction instr, Address address) {
                return false;
            }

            public boolean allowAccess(VarnodeContext context, Address addr) {
                return false;
            }
        }
        SwitchEvaluator switchEvaluator = new SwitchEvaluator();
        AddressIterator iter = destinationSet.getAddresses(true);
        SimpleBlockModel model = new SimpleBlockModel(program);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Address loc = iter.next();
            int referenceCountFrom = program.getReferenceManager().getReferenceCountFrom(loc);
            if (referenceCountFrom > 2) continue;
            CodeBlock bl = null;
            try {
                bl = model.getFirstCodeBlockContaining(loc, monitor);
            }
            catch (CancelledException e) {
                return;
            }
            AddressSet branchSet = new AddressSet((AddressSetView)bl);
            try {
                boolean oneSource;
                CodeBlockReferenceIterator bliter = bl.getSources(monitor);
                boolean bl2 = oneSource = bl.getNumSources(monitor) == 1;
                while (bliter.hasNext()) {
                    CodeBlockReference sbl = bliter.next();
                    if (sbl.getFlowType().isCall() || !sbl.getFlowType().isFallthrough() && !oneSource && sbl.getFlowType().isConditional() || (bl = sbl.getSourceBlock()) == null) continue;
                    branchSet.add((AddressSetView)bl);
                }
            }
            catch (CancelledException e) {
                break;
            }
            for (long assume = 0L; assume < (long)switchEvaluator.getMaxTableSize(); ++assume) {
                switchEvaluator.setAssume(assume);
                switchEvaluator.setGuard(false);
                switchEvaluator.setTargetSwitchAddr(loc);
                symEval.flowConstants(branchSet.getMinAddress(), (AddressSetView)branchSet, (ContextEvaluator)switchEvaluator, false, monitor);
                if (assume > 0L && targetList.size() < 1 || symEval.readExecutable()) break;
            }
            if (targetList.size() > 1) {
                AddressTable table = new AddressTable(loc, targetList.toArray(new Address[0]), program.getDefaultPointerSize(), 0, false);
                table.fixupFunctionBody(program, program.getListing().getInstructionAt(loc), monitor);
                this.labelTable(program, loc, targetList);
                continue;
            }
            if (targetList.size() != 1) continue;
            Function f = program.getFunctionManager().getFunctionContaining(loc);
            CreateFunctionCmd.fixupFunctionBody((Program)program, (Function)f, (TaskMonitor)monitor);
        }
    }

    private void createDataType(Program program, Instruction instr, Address address) {
        if (!program.getListing().isUndefined(address, address)) {
            return;
        }
        String mnemonic = instr.getMnemonicString();
        if (mnemonic.startsWith("l") || mnemonic.startsWith("s")) {
            char endCh = mnemonic.charAt(1);
            Undefined8DataType dt = null;
            switch (endCh) {
                case 'd': {
                    dt = Undefined8DataType.dataType;
                    break;
                }
                case 'w': {
                    dt = Undefined4DataType.dataType;
                    break;
                }
                case 'h': {
                    dt = Undefined2DataType.dataType;
                    break;
                }
                case 'b': {
                    dt = Undefined1DataType.dataType;
                }
            }
            if (dt != null) {
                try {
                    program.getListing().createData(address, (DataType)dt);
                }
                catch (CodeUnitInsertionException codeUnitInsertionException) {
                    // empty catch block
                }
            }
        }
    }

    private RegisterValue findR2Value(Program program, Address start) {
        if ("Preferred Executable Format (PEF)".equals(program.getExecutableFormat())) {
            return this.findPefR2Value(program, start);
        }
        return null;
    }

    private RegisterValue findPefR2Value(Program program, Address start) {
        Listing listing = program.getListing();
        ReferenceManager referenceManager = program.getReferenceManager();
        Symbol tocSymbol = SymbolUtilities.getExpectedLabelOrFunctionSymbol((Program)program, (String)".toc", err -> Msg.error((Object)((Object)this), (Object)err));
        if (tocSymbol == null) {
            return null;
        }
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        ReferenceIterator refIter = referenceManager.getReferencesTo(start);
        while (refIter.hasNext()) {
            Reference ref = refIter.next();
            Data data = listing.getDataAt(ref.getFromAddress());
            if (data == null || !data.isPointer()) continue;
            Address dataAddr = data.getMaxAddress().add(1L);
            Address tocAddr = pdis.getIndirectAddr(dataAddr);
            if (!tocSymbol.getAddress().equals((Object)tocAddr)) continue;
            BigInteger tocValue = BigInteger.valueOf(tocAddr.getOffset());
            Register r2 = program.getRegister("r2");
            return new RegisterValue(r2, tocValue);
        }
        return null;
    }

    protected boolean isPEFCallingConvention(Program program, Instruction instr) {
        Register reg;
        if (instr.getMnemonicString().equals("lwz") && (reg = instr.getRegister(0)) != null && reg.getName().equals("r2")) {
            Object[] objs = instr.getOpObjects(1);
            Register stackRegister = program.getCompilerSpec().getStackPointer();
            for (Object obj : objs) {
                if (obj instanceof Register && (Register)obj != stackRegister) {
                    return false;
                }
                if (!(obj instanceof Scalar) || ((Scalar)obj).getValue() == 20L) continue;
                return false;
            }
            Address fallAddr = instr.getFallFrom();
            Instruction fallInstr = program.getListing().getInstructionContaining(fallAddr);
            if (fallInstr != null && fallInstr.getFlowType().isCall()) {
                return true;
            }
        }
        return false;
    }

    private void labelTable(Program program, Address loc, ArrayList<Address> targets) {
        Namespace space = null;
        Instruction start_inst = program.getListing().getInstructionAt(loc);
        String spaceName = "switch_" + start_inst.getMinAddress();
        try {
            space = program.getSymbolTable().createNameSpace(space, spaceName, SourceType.ANALYSIS);
        }
        catch (DuplicateNameException e) {
            space = program.getSymbolTable().getNamespace(spaceName, program.getGlobalNamespace());
        }
        catch (InvalidInputException e) {
            // empty catch block
        }
        int tableNumber = 0;
        for (Address addr : targets) {
            AddLabelCmd lcmd = new AddLabelCmd(addr, "case_" + Long.toHexString(tableNumber), space, SourceType.ANALYSIS);
            ++tableNumber;
            lcmd.setNamespace(space);
            lcmd.applyTo((DomainObject)program);
        }
    }
}

