/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ThreadReference;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.manager.JdiReason;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetEventScope;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ThreadContainer", elements={@TargetElementType(type=JdiModelTargetThread.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetThreadContainer
extends JdiModelTargetObjectImpl
implements JdiModelTargetEventScope,
JdiEventsListenerAdapter {
    private List<ThreadReference> threads;
    protected final Map<String, JdiModelTargetThread> threadsById = new WeakValueHashMap();

    public JdiModelTargetThreadContainer(JdiModelTargetObject object, String name, List<ThreadReference> threads) {
        super(object, name);
        this.threads = threads;
        if (this.targetVM != null) {
            this.impl.getManager().addEventsListener(this.targetVM.vm, this);
        }
    }

    public JdiModelTargetThread threadCreated(ThreadReference thread) {
        JdiModelTargetThread targetThread = this.getTargetThread(thread);
        this.changeElements(List.of(), List.of(targetThread), Map.of(), "Created");
        return targetThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadExited(ThreadReference thread) {
        JdiModelTargetThreadContainer jdiModelTargetThreadContainer = this;
        synchronized (jdiModelTargetThreadContainer) {
            this.threadsById.remove(thread.name());
        }
        this.changeElements(List.of(thread.name()), List.of(), Map.of(), "Exited");
    }

    @Override
    public void threadStateChanged(ThreadReference thread, Integer state, JdiCause cause, JdiReason reason) {
        JdiModelTargetThread targetThread = this.getTargetThread(thread);
        TargetExecutionStateful.TargetExecutionState targetState = targetThread.convertState(state);
        targetThread.threadStateChanged(targetState);
        TargetEventScope.TargetEventType eventType = this.getEventType(reason);
        this.broadcast().event((TargetObject)this, (TargetThread)targetThread, eventType, "Thread " + targetThread.getName() + " state changed", List.of(targetThread));
    }

    private TargetEventScope.TargetEventType getEventType(JdiReason reason) {
        if (reason == JdiReason.Reasons.STEP) {
            return TargetEventScope.TargetEventType.STEP_COMPLETED;
        }
        if (reason == JdiReason.Reasons.BREAKPOINT_HIT) {
            return TargetEventScope.TargetEventType.BREAKPOINT_HIT;
        }
        if (reason == JdiReason.Reasons.ACCESS_WATCHPOINT_HIT) {
            return TargetEventScope.TargetEventType.BREAKPOINT_HIT;
        }
        if (reason == JdiReason.Reasons.WATCHPOINT_HIT) {
            return TargetEventScope.TargetEventType.BREAKPOINT_HIT;
        }
        if (reason == JdiReason.Reasons.INTERRUPT) {
            return TargetEventScope.TargetEventType.SIGNAL;
        }
        if (reason == JdiReason.Reasons.RESUMED) {
            return TargetEventScope.TargetEventType.RUNNING;
        }
        return TargetEventScope.TargetEventType.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingThreads(List<ThreadReference> refs) {
        List targetThreads;
        JdiModelTargetThreadContainer jdiModelTargetThreadContainer = this;
        synchronized (jdiModelTargetThreadContainer) {
            targetThreads = refs.stream().map(this::getTargetThread).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetThread t : targetThreads) {
            fence.include(t.init());
        }
        return fence.ready().thenAccept(__ -> this.setElements(targetThreads, Map.of(), "Refreshed"));
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.updateUsingThreads(this.threads);
    }

    public synchronized JdiModelTargetThread getTargetThread(ThreadReference thread) {
        return this.threadsById.computeIfAbsent(thread.name(), i -> (JdiModelTargetThread)this.getInstance(thread));
    }

    public synchronized JdiModelTargetThread getTargetThreadIfPresent(String name) {
        return this.threadsById.get(name);
    }
}

