/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.Application;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.GhidraPrincipal;
import ghidra.framework.remote.GhidraServerHandle;
import ghidra.framework.remote.RemoteRepositoryServerHandle;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.SignatureCallback;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.cert.Certificate;
import java.util.HashSet;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

class ServerConnectTask
extends Task {
    private static final int LIVENESS_CHECK_TIMEOUT_MS = 3000;
    private ServerInfo server;
    private boolean allowLoginRetry;
    private RemoteRepositoryServerHandle hdl;
    private Exception exc;

    ServerConnectTask(ServerInfo server, boolean allowLoginRetry) {
        super("Connecting to " + server.getServerName(), true, false, true);
        this.server = server;
        this.allowLoginRetry = allowLoginRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) throws CancelledException {
        block8: {
            monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
            try {
                this.hdl = this.getRepositoryServerHandle(ClientUtil.getUserName(), monitor);
            }
            catch (RemoteException e) {
                this.exc = e;
                Throwable t = e.getCause();
                if (t instanceof Exception) {
                    this.exc = (Exception)t;
                }
            }
            catch (Exception e) {
                this.exc = e;
            }
            finally {
                if (!monitor.isCancelled()) break block8;
                this.exc = null;
                throw new CancelledException();
            }
        }
    }

    Exception getException() {
        return this.exc;
    }

    RemoteRepositoryServerHandle getRepositoryServerHandle() {
        return this.hdl;
    }

    private static Subject getLocalUserSubject() {
        String username = ClientUtil.getUserName();
        HashSet<GhidraPrincipal> pset = new HashSet<GhidraPrincipal>();
        HashSet emptySet = new HashSet();
        pset.add(new GhidraPrincipal(username));
        Subject subj = new Subject(false, pset, emptySet, emptySet);
        return subj;
    }

    private static boolean isSSLHandshakeCancelled(SSLHandshakeException e) throws IOException {
        if (e.getMessage().indexOf("bad_certificate") > 0) {
            if (ApplicationKeyManagerFactory.getPreferredKeyStore() == null) {
                throw new IOException("User PKI Certificate not installed", e);
            }
            return true;
        }
        return false;
    }

    public static GhidraServerHandle getGhidraServerHandle(ServerInfo server, TaskMonitor monitor) throws IOException, CancelledException {
        GhidraServerHandle gsh = null;
        boolean canCancel = monitor.isCancelEnabled();
        try {
            ServerConnectTask.testServerSSLConnection(server, monitor);
            monitor.setCancelEnabled(false);
            monitor.setMessage("Connecting...");
            Registry reg = LocateRegistry.getRegistry(server.getServerName(), server.getPortNumber(), new SslRMIClientSocketFactory());
            ServerConnectTask.checkServerBindNames(reg);
            gsh = (GhidraServerHandle)reg.lookup("GhidraServer9.0");
            gsh.checkCompatibility(11);
        }
        catch (NotBoundException e) {
            throw new IOException(e.getMessage());
        }
        catch (SSLHandshakeException e) {
            if (ServerConnectTask.isSSLHandshakeCancelled(e)) {
                GhidraServerHandle ghidraServerHandle = null;
                return ghidraServerHandle;
            }
            throw e;
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnmarshalException || cause instanceof ClassNotFoundException) {
                throw new RemoteException("Incompatible Ghidra Server interface version");
            }
            if (cause instanceof SSLHandshakeException && ServerConnectTask.isSSLHandshakeCancelled((SSLHandshakeException)cause)) {
                GhidraServerHandle ghidraServerHandle = null;
                return ghidraServerHandle;
            }
            throw e;
        }
        finally {
            monitor.setCancelEnabled(canCancel);
            monitor.setMessage("");
        }
        return gsh;
    }

    private RemoteRepositoryServerHandle getRepositoryServerHandle(String defaultUserID, TaskMonitor monitor) throws IOException, LoginException, CancelledException {
        GhidraServerHandle gsh = ServerConnectTask.getGhidraServerHandle(this.server, monitor);
        Callback[] callbacks = null;
        try {
            boolean loopOK = this.allowLoginRetry;
            String loginError = null;
            callbacks = gsh.getAuthenticationCallbacks();
            SignatureCallback pkiSignatureCb = null;
            boolean hasSSHSignatureCallback = false;
            if (callbacks != null) {
                for (Callback cb : callbacks) {
                    if (cb instanceof SignatureCallback) {
                        pkiSignatureCb = (SignatureCallback)cb;
                        continue;
                    }
                    if (!(cb instanceof SSHSignatureCallback)) continue;
                    hasSSHSignatureCallback = true;
                }
            }
            AnonymousCallback onlyAnonymousCb = null;
            while (true) {
                RemoteRepositoryServerHandle rsh;
                block29: {
                    try {
                        if (callbacks != null) {
                            if (onlyAnonymousCb != null) {
                                onlyAnonymousCb.setAnonymousAccessRequested(true);
                                loopOK = false;
                            } else if (callbacks.length == 1 && callbacks[0] instanceof AnonymousCallback) {
                                onlyAnonymousCb = (AnonymousCallback)callbacks[0];
                                loopOK = true;
                            } else if (hasSSHSignatureCallback && ClientUtil.isSSHKeyAvailable()) {
                                hasSSHSignatureCallback = false;
                                ClientUtil.processSSHSignatureCallback(callbacks, this.server.getServerName(), defaultUserID);
                            } else if (pkiSignatureCb != null) {
                                if (!ApplicationKeyManagerFactory.initialize()) {
                                    throw new IOException("Client PKI certificate has not been installed");
                                }
                                if (ApplicationKeyManagerFactory.usingGeneratedSelfSignedCertificate()) {
                                    Msg.warn((Object)((Object)this), (Object)"Server connect - client is using self-signed PKI certificate");
                                }
                                loopOK = false;
                                ClientUtil.processSignatureCallback(this.server.getServerName(), pkiSignatureCb);
                            } else if (!ClientUtil.processPasswordCallbacks(callbacks, this.server.getServerName(), defaultUserID, loginError)) {
                                RemoteRepositoryServerHandle remoteRepositoryServerHandle = null;
                                return remoteRepositoryServerHandle;
                            }
                        } else {
                            loopOK = false;
                        }
                        rsh = gsh.getRepositoryServer(ServerConnectTask.getLocalUserSubject(), callbacks);
                        if (!rsh.isReadOnly()) break block29;
                    }
                    catch (FailedLoginException e) {
                        try {
                            if (loopOK) {
                                loginError = "Access denied: " + this.server;
                                continue;
                            }
                            throw e;
                        }
                        catch (AccessException e2) {
                            throw new IOException(e2.getMessage());
                        }
                    }
                    Msg.showInfo((Object)((Object)this), null, (String)"Anonymous Server Login", (Object)("You have been logged-in anonymously to " + this.server.getServerName() + "\nRead-only permission is granted to repositories which allow anonymous access"));
                }
                RemoteRepositoryServerHandle remoteRepositoryServerHandle = rsh;
                return remoteRepositoryServerHandle;
            }
        }
        finally {
            if (callbacks != null) {
                for (Callback callback : callbacks) {
                    if (!(callback instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callback).clearPassword();
                }
            }
        }
    }

    private static void forceClose(Socket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static Certificate[] testServerSSLConnection(ServerInfo server, TaskMonitor monitor) throws IOException, CancelledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkServerBindNames(Registry reg) throws RemoteException {
        Object requiredVersion = "9.0";
        if (!Application.getApplicationVersion().startsWith((String)requiredVersion)) {
            requiredVersion = (String)requiredVersion + " - " + Application.getApplicationVersion();
        }
        String[] regList = reg.list();
        RemoteException exc = null;
        int badVerCount = 0;
        for (String name : regList) {
            if (name.equals("GhidraServer9.0")) {
                return;
            }
            if (!name.startsWith("GhidraServer")) continue;
            String version = name.substring("GhidraServer".length());
            if (version.length() == 0) {
                version = "4.3.x (or older)";
            }
            exc = new RemoteException("Incompatible Ghidra Server interface, detected interface version " + version + ",\nthis client requires server version " + (String)requiredVersion);
            ++badVerCount;
        }
        if (exc != null) {
            if (badVerCount == 1) {
                throw exc;
            }
            throw new RemoteException("Incompatible Ghidra Server interface, detected " + badVerCount + " incompatible server versions,\nthis client requires server version " + (String)requiredVersion);
        }
        throw new RemoteException("Ghidra Server not found.");
    }

    private static /* synthetic */ void lambda$testServerSSLConnection$1(SSLSocket socket) {
        ServerConnectTask.forceClose(socket);
    }

    private static /* synthetic */ void lambda$testServerSSLConnection$0(Socket socket) {
        ServerConnectTask.forceClose(socket);
    }

    private static class FastConnectionFailSocket
    extends Socket {
        FastConnectionFailSocket(String host, int port) throws UnknownHostException, IOException {
            super(host, port);
        }

        @Override
        public void connect(SocketAddress endpoint) throws IOException {
            this.connect(endpoint, 3000);
        }
    }

    private static class ConnectCancelledListener
    implements CancelledListener,
    Closeable {
        private TaskMonitor monitor;
        private CancelledListener callback;

        ConnectCancelledListener(TaskMonitor monitor, CancelledListener callback) {
            this.monitor = monitor;
            this.callback = callback;
            monitor.addCancelledListener((CancelledListener)this);
        }

        public void cancelled() {
            if (this.callback != null) {
                this.callback.cancelled();
            }
        }

        @Override
        public void close() throws IOException {
            this.monitor.removeCancelledListener((CancelledListener)this);
        }
    }
}

