/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.IdMsParsable;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AliasMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AliasStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArgumentsList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArgumentsListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Array16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArrayStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BadMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BaseClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BaseInterfaceMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BasicArray16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BasicArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Bitfield16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BitfieldMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BuildInfoMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Class16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Class19MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Cobol016MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Cobol0MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Cobol1MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DefaultArguments16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DefaultArgumentsMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DefaultArgumentsStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DerivedClassList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DerivedClassListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArray16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsLowerUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsLowerUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsLowerUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsLowerUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EndPrecompiledTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Enum16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumerateStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FieldList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FieldListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendFunction16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendFunctionStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FunctionIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.HighLevelShaderLanguageMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Index16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.IndexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.IndirectVirtualBaseClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.IndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.InterfaceMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.LabelMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ManagedMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ManagedStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MatrixMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Member16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunction16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunctionIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberModifyMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberModifyStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MethodList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MethodListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Modifier16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ModifierExMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedType16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeExtMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeExtStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NotTranMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NullMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OemDefinableString16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OemDefinableString2MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OemDefinableStringMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OneMethod16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OneMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OneMethodStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OverloadedMethod16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OverloadedMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OverloadedMethodStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Pointer16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrecompiledType16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrecompiledTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrecompiledTypeStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Procedure16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ProcedureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ReferencedSymbolMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Skip16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.SkipMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StaticMember16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StaticMemberStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StridedArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StringIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Structure16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Structure19MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StructureStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.SubstringListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.TypeServer2MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.TypeServerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.TypeServerStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Union16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnionStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnknownMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeModuleSourceAndLineMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeSourceAndLineMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VectorMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualBaseClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTableMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePath16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePathMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointer16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointerWithOffset16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointerWithOffsetMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeMsType;
import ghidra.util.exception.CancelledException;
import java.util.Objects;

public class TypeParser {
    private TypeParser() {
    }

    public static AbstractMsType parseRecord(AbstractPdb pdb, PdbByteReader reader, RecordNumber recordNumber) throws PdbException, CancelledException {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        AbstractMsType result = TypeParser.parse(pdb, reader, AbstractMsType.class);
        result.setRecordNumber(recordNumber);
        return result;
    }

    public static MsTypeField parseField(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        MsTypeField result = TypeParser.parse(pdb, reader, MsTypeField.class);
        return result;
    }

    public static AbstractMsType parse(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        AbstractMsType result = TypeParser.parse(pdb, reader, AbstractMsType.class);
        return result;
    }

    private static <T> T parse(AbstractPdb pdb, PdbByteReader reader, Class<T> requiredClass) throws PdbException, CancelledException {
        int dataTypeId = reader.parseUnsignedShortVal();
        try {
            IdMsParsable parsable = TypeParser.parse(pdb, reader, dataTypeId);
            if (requiredClass.isInstance(parsable)) {
                return requiredClass.cast(parsable);
            }
            PdbLog.logSerializationItemClassMismatch(parsable, requiredClass, dataTypeId);
        }
        catch (PdbException e) {
            PdbLog.logDeserializationFailure(reader, dataTypeId, e);
        }
        return requiredClass.cast(new BadMsType(pdb, dataTypeId));
    }

    private static IdMsParsable parse(AbstractPdb pdb, PdbByteReader reader, int dataTypeId) throws PdbException, CancelledException {
        pdb.getPdbReaderMetrics().witnessDataTypeId(dataTypeId);
        AbstractMsType type = null;
        switch (dataTypeId) {
            case 1: {
                type = new Modifier16MsType(pdb, reader);
                break;
            }
            case 2: {
                type = new Pointer16MsType(pdb, reader);
                break;
            }
            case 3: {
                type = new Array16MsType(pdb, reader);
                break;
            }
            case 4: {
                type = new Class16MsType(pdb, reader);
                break;
            }
            case 5: {
                type = new Structure16MsType(pdb, reader);
                break;
            }
            case 6: {
                type = new Union16MsType(pdb, reader);
                break;
            }
            case 7: {
                type = new Enum16MsType(pdb, reader);
                break;
            }
            case 8: {
                type = new Procedure16MsType(pdb, reader);
                break;
            }
            case 9: {
                type = new MemberFunction16MsType(pdb, reader);
                break;
            }
            case 10: {
                type = new VtShapeMsType(pdb, reader);
                break;
            }
            case 11: {
                type = new Cobol016MsType(pdb, reader);
                break;
            }
            case 12: {
                type = new Cobol1MsType(pdb, reader);
                break;
            }
            case 13: {
                type = new BasicArray16MsType(pdb, reader);
                break;
            }
            case 14: {
                type = new LabelMsType(pdb, reader);
                break;
            }
            case 15: {
                type = new NullMsType(pdb, reader);
                break;
            }
            case 16: {
                type = new NotTranMsType(pdb, reader);
                break;
            }
            case 17: {
                type = new DimensionedArray16MsType(pdb, reader);
                break;
            }
            case 18: {
                type = new VirtualFunctionTablePath16MsType(pdb, reader);
                break;
            }
            case 19: {
                type = new PrecompiledType16MsType(pdb, reader);
                break;
            }
            case 20: {
                type = new EndPrecompiledTypeMsType(pdb, reader);
                break;
            }
            case 21: {
                type = new OemDefinableString16MsType(pdb, reader);
                break;
            }
            case 22: {
                type = new TypeServerStMsType(pdb, reader);
                break;
            }
            case 512: {
                type = new Skip16MsType(pdb, reader);
                break;
            }
            case 513: {
                type = new ArgumentsList16MsType(pdb, reader);
                break;
            }
            case 514: {
                type = new DefaultArguments16MsType(pdb, reader);
                break;
            }
            case 515: {
                type = new ListMsType(pdb, reader);
                break;
            }
            case 516: {
                type = new FieldList16MsType(pdb, reader);
                break;
            }
            case 517: {
                type = new DerivedClassList16MsType(pdb, reader);
                break;
            }
            case 518: {
                type = new Bitfield16MsType(pdb, reader);
                break;
            }
            case 519: {
                type = new MethodList16MsType(pdb, reader);
                break;
            }
            case 520: {
                type = new DimensionedArrayConstBoundsUpper16MsType(pdb, reader);
                break;
            }
            case 521: {
                type = new DimensionedArrayConstBoundsLowerUpper16MsType(pdb, reader);
                break;
            }
            case 522: {
                type = new DimensionedArrayVarBoundsUpper16MsType(pdb, reader);
                break;
            }
            case 523: {
                type = new DimensionedArrayVarBoundsLowerUpper16MsType(pdb, reader);
                break;
            }
            case 524: {
                type = new ReferencedSymbolMsType(pdb, reader);
                break;
            }
            case 1024: {
                type = new BaseClass16MsType(pdb, reader);
                break;
            }
            case 1025: {
                type = new VirtualBaseClass16MsType(pdb, reader);
                break;
            }
            case 1026: {
                type = new IndirectVirtualBaseClass16MsType(pdb, reader);
                break;
            }
            case 1027: {
                type = new EnumerateStMsType(pdb, reader);
                break;
            }
            case 1028: {
                type = new FriendFunction16MsType(pdb, reader);
                break;
            }
            case 1029: {
                type = new Index16MsType(pdb, reader);
                break;
            }
            case 1030: {
                type = new Member16MsType(pdb, reader);
                break;
            }
            case 1031: {
                type = new StaticMember16MsType(pdb, reader);
                break;
            }
            case 1032: {
                type = new OverloadedMethod16MsType(pdb, reader);
                break;
            }
            case 1033: {
                type = new NestedType16MsType(pdb, reader);
                break;
            }
            case 1034: {
                type = new VirtualFunctionTablePointer16MsType(pdb, reader);
                break;
            }
            case 1035: {
                type = new FriendClass16MsType(pdb, reader);
                break;
            }
            case 1036: {
                type = new OneMethod16MsType(pdb, reader);
                break;
            }
            case 1037: {
                type = new VirtualFunctionTablePointerWithOffset16MsType(pdb, reader);
                break;
            }
            case 4097: {
                type = new ModifierMsType(pdb, reader);
                break;
            }
            case 4098: {
                type = new PointerMsType(pdb, reader);
                break;
            }
            case 4099: {
                type = new ArrayStMsType(pdb, reader);
                break;
            }
            case 4100: {
                type = new ClassStMsType(pdb, reader);
                break;
            }
            case 4101: {
                type = new StructureStMsType(pdb, reader);
                break;
            }
            case 4102: {
                type = new UnionStMsType(pdb, reader);
                break;
            }
            case 4103: {
                type = new EnumStMsType(pdb, reader);
                break;
            }
            case 4104: {
                type = new ProcedureMsType(pdb, reader);
                break;
            }
            case 4105: {
                type = new MemberFunctionMsType(pdb, reader);
                break;
            }
            case 4106: {
                type = new Cobol0MsType(pdb, reader);
                break;
            }
            case 4107: {
                type = new BasicArrayMsType(pdb, reader);
                break;
            }
            case 4108: {
                type = new DimensionedArrayStMsType(pdb, reader);
                break;
            }
            case 4109: {
                type = new VirtualFunctionTablePathMsType(pdb, reader);
                break;
            }
            case 4110: {
                type = new PrecompiledTypeStMsType(pdb, reader);
                break;
            }
            case 4111: {
                type = new OemDefinableStringMsType(pdb, reader);
                break;
            }
            case 4112: {
                type = new AliasStMsType(pdb, reader);
                break;
            }
            case 4113: {
                type = new OemDefinableString2MsType(pdb, reader);
                break;
            }
            case 4608: {
                type = new SkipMsType(pdb, reader);
                break;
            }
            case 4609: {
                type = new ArgumentsListMsType(pdb, reader);
                break;
            }
            case 4610: {
                type = new DefaultArgumentsStMsType(pdb, reader);
                break;
            }
            case 4611: {
                type = new FieldListMsType(pdb, reader);
                break;
            }
            case 4612: {
                type = new DerivedClassListMsType(pdb, reader);
                break;
            }
            case 4613: {
                type = new BitfieldMsType(pdb, reader);
                break;
            }
            case 4614: {
                type = new MethodListMsType(pdb, reader);
                break;
            }
            case 4615: {
                type = new DimensionedArrayConstBoundsUpperMsType(pdb, reader);
                break;
            }
            case 4616: {
                type = new DimensionedArrayConstBoundsLowerUpperMsType(pdb, reader);
                break;
            }
            case 4617: {
                type = new DimensionedArrayVarBoundsUpperMsType(pdb, reader);
                break;
            }
            case 4618: {
                type = new DimensionedArrayVarBoundsLowerUpperMsType(pdb, reader);
                break;
            }
            case 5120: {
                type = new BaseClassMsType(pdb, reader);
                break;
            }
            case 5121: {
                type = new VirtualBaseClassMsType(pdb, reader);
                break;
            }
            case 5122: {
                type = new IndirectVirtualBaseClassMsType(pdb, reader);
                break;
            }
            case 5123: {
                type = new FriendFunctionStMsType(pdb, reader);
                break;
            }
            case 5124: {
                type = new IndexMsType(pdb, reader);
                break;
            }
            case 5125: {
                type = new MemberStMsType(pdb, reader);
                break;
            }
            case 5126: {
                type = new StaticMemberStMsType(pdb, reader);
                break;
            }
            case 5127: {
                type = new OverloadedMethodStMsType(pdb, reader);
                break;
            }
            case 5128: {
                type = new NestedTypeStMsType(pdb, reader);
                break;
            }
            case 5129: {
                type = new VirtualFunctionTablePointerMsType(pdb, reader);
                break;
            }
            case 5130: {
                type = new FriendClassMsType(pdb, reader);
                break;
            }
            case 5131: {
                type = new OneMethodStMsType(pdb, reader);
                break;
            }
            case 5132: {
                type = new VirtualFunctionTablePointerWithOffsetMsType(pdb, reader);
                break;
            }
            case 5133: {
                type = new NestedTypeExtStMsType(pdb, reader);
                break;
            }
            case 5134: {
                type = new MemberModifyStMsType(pdb, reader);
                break;
            }
            case 5135: {
                type = new ManagedStMsType(pdb, reader);
                break;
            }
            case 5377: {
                type = new TypeServerMsType(pdb, reader);
                break;
            }
            case 5378: {
                type = new EnumerateMsType(pdb, reader);
                break;
            }
            case 5379: {
                type = new ArrayMsType(pdb, reader);
                break;
            }
            case 5380: {
                type = new ClassMsType(pdb, reader);
                break;
            }
            case 5381: {
                type = new StructureMsType(pdb, reader);
                break;
            }
            case 5382: {
                type = new UnionMsType(pdb, reader);
                break;
            }
            case 5383: {
                type = new EnumMsType(pdb, reader);
                break;
            }
            case 5384: {
                type = new DimensionedArrayMsType(pdb, reader);
                break;
            }
            case 5385: {
                type = new PrecompiledTypeMsType(pdb, reader);
                break;
            }
            case 5386: {
                type = new AliasMsType(pdb, reader);
                break;
            }
            case 5387: {
                type = new DefaultArgumentsMsType(pdb, reader);
                break;
            }
            case 5388: {
                type = new FriendFunctionMsType(pdb, reader);
                break;
            }
            case 5389: {
                type = new MemberMsType(pdb, reader);
                break;
            }
            case 5390: {
                type = new StaticMemberMsType(pdb, reader);
                break;
            }
            case 5391: {
                type = new OverloadedMethodMsType(pdb, reader);
                break;
            }
            case 5392: {
                type = new NestedTypeMsType(pdb, reader);
                break;
            }
            case 5393: {
                type = new OneMethodMsType(pdb, reader);
                break;
            }
            case 5394: {
                type = new NestedTypeExtMsType(pdb, reader);
                break;
            }
            case 5395: {
                type = new MemberModifyMsType(pdb, reader);
                break;
            }
            case 5396: {
                type = new ManagedMsType(pdb, reader);
                break;
            }
            case 5397: {
                type = new TypeServer2MsType(pdb, reader);
                break;
            }
            case 5398: {
                type = new StridedArrayMsType(pdb, reader);
                break;
            }
            case 5399: {
                type = new HighLevelShaderLanguageMsType(pdb, reader);
                break;
            }
            case 5400: {
                type = new ModifierExMsType(pdb, reader);
                break;
            }
            case 5401: {
                type = new InterfaceMsType(pdb, reader);
                break;
            }
            case 5402: {
                type = new BaseInterfaceMsType(pdb, reader);
                break;
            }
            case 5403: {
                type = new VectorMsType(pdb, reader);
                break;
            }
            case 5404: {
                type = new MatrixMsType(pdb, reader);
                break;
            }
            case 5405: {
                type = new VirtualFunctionTableMsType(pdb, reader);
                break;
            }
            case 5633: {
                type = new FunctionIdMsType(pdb, reader);
                break;
            }
            case 5634: {
                type = new MemberFunctionIdMsType(pdb, reader);
                break;
            }
            case 5635: {
                type = new BuildInfoMsType(pdb, reader);
                break;
            }
            case 5636: {
                type = new SubstringListMsType(pdb, reader);
                break;
            }
            case 5637: {
                type = new StringIdMsType(pdb, reader);
                break;
            }
            case 5638: {
                type = new UserDefinedTypeSourceAndLineMsType(pdb, reader);
                break;
            }
            case 5639: {
                type = new UserDefinedTypeModuleSourceAndLineMsType(pdb, reader);
                break;
            }
            case 5640: {
                type = new Class19MsType(pdb, reader);
                break;
            }
            case 5641: {
                type = new Structure19MsType(pdb, reader);
                break;
            }
            default: {
                type = new UnknownMsType(pdb, reader, dataTypeId);
            }
        }
        return type;
    }
}

