/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.BlockSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DataSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefinedSingleAddressRangeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.EndSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FrameAndProcedureInformationSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.LabelSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.LocalOptimizedSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ManagedProcedureSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NoSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PeCoffGroupSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PeCoffSectionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.PublicSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ReferenceSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.RegisterRelativeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SeparatedCodeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.app.util.pdb.pdbapplicator.TrampolineSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.TypedefSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.WithSymbolApplier;
import ghidra.util.exception.CancelledException;

public class SymbolApplierFactory {
    private DefaultPdbApplicator applicator;

    SymbolApplierFactory(DefaultPdbApplicator applicator) {
        this.applicator = applicator;
    }

    MsSymbolApplier getSymbolApplier(SymbolGroup.AbstractMsSymbolIterator iter) throws CancelledException {
        AbstractMsSymbol symbol = iter.peek();
        if (symbol == null) {
            this.applicator.appendLogMsg("PDB Warning: No AbstractMsSymbol");
            return null;
        }
        MsSymbolApplier applier = null;
        switch (symbol.getPdbId()) {
            case 4: {
                applier = new TypedefSymbolApplier(this.applicator, iter);
                break;
            }
            case 6: {
                applier = new EndSymbolApplier(this.applicator, iter);
                break;
            }
            case 11: {
                applier = new TypedefSymbolApplier(this.applicator, iter);
                break;
            }
            case 257: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 258: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 259: {
                applier = new PublicSymbolApplier(this.applicator, iter);
                break;
            }
            case 260: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 261: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 262: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 263: {
                applier = new BlockSymbolApplier(this.applicator, iter);
                break;
            }
            case 264: {
                applier = new WithSymbolApplier(this.applicator, iter);
                break;
            }
            case 265: {
                applier = new LabelSymbolApplier(this.applicator, iter);
                break;
            }
            case 268: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, iter);
                break;
            }
            case 513: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 514: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 515: {
                applier = new PublicSymbolApplier(this.applicator, iter);
                break;
            }
            case 516: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 517: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 518: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 519: {
                applier = new BlockSymbolApplier(this.applicator, iter);
                break;
            }
            case 520: {
                applier = new WithSymbolApplier(this.applicator, iter);
                break;
            }
            case 521: {
                applier = new LabelSymbolApplier(this.applicator, iter);
                break;
            }
            case 524: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, iter);
                break;
            }
            case 768: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 769: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 1024: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 1025: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 1027: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 4099: {
                applier = new TypedefSymbolApplier(this.applicator, iter);
                break;
            }
            case 4100: {
                applier = new TypedefSymbolApplier(this.applicator, iter);
                break;
            }
            case 4103: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4104: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4105: {
                applier = new PublicSymbolApplier(this.applicator, iter);
                break;
            }
            case 4106: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4107: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4109: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4112: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4113: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4114: {
                applier = new FrameAndProcedureInformationSymbolApplier(this.applicator, iter);
                break;
            }
            case 4117: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4118: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4122: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, iter);
                break;
            }
            case 4123: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, iter);
                break;
            }
            case 4128: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4129: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4354: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4355: {
                applier = new BlockSymbolApplier(this.applicator, iter);
                break;
            }
            case 4356: {
                applier = new WithSymbolApplier(this.applicator, iter);
                break;
            }
            case 4357: {
                applier = new LabelSymbolApplier(this.applicator, iter);
                break;
            }
            case 4360: {
                applier = new TypedefSymbolApplier(this.applicator, iter);
                break;
            }
            case 4361: {
                applier = new TypedefSymbolApplier(this.applicator, iter);
                break;
            }
            case 4364: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4365: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4366: {
                applier = new PublicSymbolApplier(this.applicator, iter);
                break;
            }
            case 4367: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4368: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4369: {
                applier = new RegisterRelativeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4372: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4373: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4376: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4377: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4380: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4381: {
                applier = new DataSymbolApplier(this.applicator, iter);
                break;
            }
            case 4389: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 4390: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 4391: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 4392: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 4393: {
                applier = new ReferenceSymbolApplier(this.applicator, iter);
                break;
            }
            case 4394: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, iter);
                break;
            }
            case 4395: {
                applier = new ManagedProcedureSymbolApplier(this.applicator, iter);
                break;
            }
            case 4396: {
                applier = new TrampolineSymbolApplier(this.applicator, iter);
                break;
            }
            case 4402: {
                applier = new SeparatedCodeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4403: {
                applier = new LocalOptimizedSymbolApplier(this.applicator, iter);
                break;
            }
            case 4406: {
                applier = new PeCoffSectionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4407: {
                applier = new PeCoffGroupSymbolApplier(this.applicator, iter);
                break;
            }
            case 4414: {
                applier = new LocalOptimizedSymbolApplier(this.applicator, iter);
                break;
            }
            case 4415: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4416: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4417: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4418: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4419: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4420: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4421: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4422: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4423: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4424: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4425: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4426: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4427: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4431: {
                applier = new EndSymbolApplier(this.applicator, iter);
                break;
            }
            case 4432: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            case 4437: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4438: {
                applier = new FunctionSymbolApplier(this.applicator, iter);
                break;
            }
            case 4439: {
                applier = new DefinedSingleAddressRangeSymbolApplier(this.applicator, iter);
                break;
            }
            default: {
                this.applicator.getPdbApplicatorMetrics().witnessCannotApplySymbolType(symbol);
                applier = new NoSymbolApplier(this.applicator, iter);
            }
        }
        return applier;
    }
}

