/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import java.math.BigInteger;

public class DbgSetActiveThreadCommand
extends AbstractDbgCommand<Void> {
    private DbgThreadImpl thread;
    private Integer frameId;
    private Long offset;

    public DbgSetActiveThreadCommand(DbgManagerImpl manager, DbgThread thread, Integer frameId) {
        super(manager);
        this.thread = (DbgThreadImpl)thread;
        this.frameId = frameId;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public Void complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent out : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(out.getOutput());
        }
        this.parse(builder.toString());
        if (this.offset != null) {
            this.manager.getSystemObjects().setImplicitThreadDataOffset(this.offset);
        }
        return null;
    }

    private void parse(String result) {
        String[] lines = result.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains("THREAD")) continue;
            String[] fields = line.trim().split("\\s+");
            if (fields.length <= 1 || !fields[0].equals("THREAD")) break;
            BigInteger val = new BigInteger(fields[1], 16);
            this.offset = val.longValue();
            this.thread.setOffset(this.offset);
            break;
        }
    }

    @Override
    public void invoke() {
        DebugThreadId id = this.thread.getId();
        if (id != null) {
            if (!this.manager.isKernelMode()) {
                this.manager.getSystemObjects().setCurrentThreadId(id);
            } else {
                this.offset = this.thread.getOffset();
                if (this.offset == null || this.offset == 0L) {
                    DebugControl control = this.manager.getControl();
                    control.execute("!thread -t " + Long.toHexString(this.thread.getTid()) + " 0");
                }
            }
            if (this.frameId != null) {
                this.manager.getSymbols().setCurrentScopeFrameIndex(this.frameId);
            }
        }
    }
}

