/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgModule;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetModule;
import agent.dbgeng.model.iface2.DbgModelTargetModuleContainer;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetModuleImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetProcessImpl;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ModuleContainer", elements={@TargetElementType(type=DbgModelTargetModuleImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetModuleContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetModuleContainer {
    protected final DbgModelTargetProcessImpl targetProcess;
    protected final DbgProcess process;

    public DbgModelTargetModuleContainerImpl(DbgModelTargetProcessImpl process) {
        super(process.getModel(), (TargetObject)process, "Modules", "ModuleContainer");
        this.targetProcess = process;
        this.process = process.process;
        DbgManagerImpl manager = this.getManager();
        if (manager.isKernelMode() && !this.process.getId().isSystem()) {
            return;
        }
        if (this.getModel().isSuppressDescent()) {
            return;
        }
        this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Internal
    public void libraryLoaded(String name) {
        DbgModelTargetModule module;
        DbgModelTargetModuleContainerImpl dbgModelTargetModuleContainerImpl = this;
        synchronized (dbgModelTargetModuleContainerImpl) {
            module = this.getTargetModule(name);
        }
        this.changeElements(List.of(), List.of(module), Map.of(), "Loaded");
    }

    @Override
    @Internal
    public void libraryUnloaded(String name) {
        DbgModelTargetModule targetModule = this.getTargetModule(name);
        if (targetModule != null) {
            DbgModelImpl impl = (DbgModelImpl)this.model;
            impl.deleteModelObject(targetModule.getDbgModule());
        }
        this.changeElements(List.of(name), List.of(), Map.of(), "Unloaded");
    }

    public boolean supportsSyntheticModules() {
        return false;
    }

    @Override
    public CompletableFuture<? extends TargetModule> addSyntheticModule(String name) {
        throw new UnsupportedOperationException("Dbgeng Does not support synthetic modules");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        ArrayList result = new ArrayList();
        return this.process.listModules().thenAccept(byName -> {
            DbgModelTargetModuleContainerImpl dbgModelTargetModuleContainerImpl = this;
            synchronized (dbgModelTargetModuleContainerImpl) {
                for (Map.Entry ent : byName.entrySet()) {
                    result.add(this.getTargetModule((String)ent.getKey()));
                }
            }
            this.changeElements(List.of(), result, Map.of(), "Refreshed");
        });
    }

    @Override
    public DbgModelTargetModule getTargetModule(String name) {
        DbgModule module = this.process.getKnownModules().get(name);
        if (module == null) {
            return null;
        }
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(module);
        if (modelObject != null) {
            return (DbgModelTargetModule)modelObject;
        }
        return new DbgModelTargetModuleImpl(this, module);
    }
}

