/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.vertex;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import generic.theme.GThemeDefaults;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.AbstractVisualVertexRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class VisualVertexRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractVisualVertexRenderer<V, E> {
    public void paintVertex(RenderContext<V, E> rc, Layout<V, E> layout, V vertex) {
        Graph graph = layout.getGraph();
        if (!rc.getVertexIncludePredicate().apply((Object)Context.getInstance((Object)graph, vertex))) {
            return;
        }
        GraphicsDecorator g = rc.getGraphicsContext();
        GraphicsDecorator gCopy = this.getEmphasisGraphics(g, vertex, rc, layout);
        Shape fullShape = this.getFullShape(rc, layout, vertex);
        Shape compactShape = this.getCompactShape(rc, layout, vertex);
        if (!this.vertexHit(rc, fullShape)) {
            return;
        }
        Rectangle bounds = fullShape.getBounds();
        this.paintHighlight(rc, vertex, gCopy, bounds);
        this.paintDropShadow(rc, gCopy, compactShape, vertex);
        this.paintVertexOrVertexShape(rc, gCopy, layout, vertex, compactShape, fullShape);
        gCopy.dispose();
    }

    protected void paintDropShadow(RenderContext<V, E> rc, GraphicsDecorator g, Shape shape, V vertex) {
        super.paintDropShadow(rc, g, shape);
    }

    protected void paintVertexOrVertexShape(RenderContext<V, E> rc, GraphicsDecorator g, Layout<V, E> layout, V vertex, Shape compactShape, Shape fullShape) {
        if (this.isScaledPastVertexPaintingThreshold(rc)) {
            this.paintScaledVertex(rc, vertex, g, compactShape);
            return;
        }
        Rectangle bounds = fullShape.getBounds();
        this.paintVertex(rc, g, vertex, bounds, layout);
    }

    protected void paintVertex(RenderContext<V, E> rc, GraphicsDecorator g, V vertex, Rectangle bounds, Layout<V, E> layout) {
        JComponent component = vertex.getComponent();
        g.draw((Component)component, rc.getRendererPane(), bounds.x, bounds.y, bounds.width, bounds.height, true);
        component.setBounds(bounds);
    }

    protected boolean isScaledPastVertexPaintingThreshold(RenderContext<V, E> rc) {
        double scale = this.getScale(rc);
        return scale < 0.1;
    }

    protected void paintScaledVertex(RenderContext<V, E> rc, V vertex, GraphicsDecorator g, Shape shape) {
        Paint fillPaint;
        Function fillXform = this.getVertexFillPaintTransformer();
        if (fillXform == null) {
            fillXform = rc.getVertexFillPaintTransformer();
        }
        if ((fillPaint = (Paint)fillXform.apply(vertex)) == null) {
            return;
        }
        Paint oldPaint = g.getPaint();
        g.setPaint(fillPaint);
        g.fill(shape);
        g.setColor((Color)GThemeDefaults.Colors.BORDER);
        g.draw(shape);
        g.setPaint(oldPaint);
    }
}

