/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeFactory;

public class ClangSyntaxToken
extends ClangToken {
    private int open = -1;
    private int close = -1;

    public ClangSyntaxToken(ClangNode par) {
        super(par);
    }

    public ClangSyntaxToken(ClangNode par, String txt) {
        super(par, txt);
    }

    public ClangSyntaxToken(ClangNode par, String txt, int color) {
        super(par, txt, color);
    }

    @Override
    public boolean isVariableRef() {
        return this.Parent() instanceof ClangVariableDecl;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_OPEN.id()) {
                this.open = (int)decoder.readSignedInteger();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_CLOSE.id()) continue;
            this.close = (int)decoder.readSignedInteger();
        }
        decoder.rewindAttributes();
        super.decode(decoder, pfactory);
    }

    public int getOpen() {
        return this.open;
    }

    public int getClose() {
        return this.close;
    }
}

