/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GColor;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.decompiler.component.ClangDecompilerHighlighter;
import ghidra.app.decompiler.component.ClangHighlightListener;
import ghidra.app.decompiler.component.ColorProvider;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.NullClangHighlightController;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.collections4.map.LazyMap;
import util.CollectionUtils;

public abstract class ClangHighlightController {
    public static Color DEFAULT_HIGHLIGHT_COLOR = new GColor("color.bg.decompiler.highlights.default");
    protected Color defaultHighlightColor = DEFAULT_HIGHLIGHT_COLOR;
    protected Color defaultParenColor = DEFAULT_HIGHLIGHT_COLOR;
    private TokenHighlights primaryHighlightTokens = new TokenHighlights();
    private Map<Function, List<ClangDecompilerHighlighter>> secondaryHighlightersbyFunction = LazyMap.lazyMap(new HashMap(), f -> new ArrayList());
    private Set<ClangDecompilerHighlighter> secondaryHighlighters = new HashSet<ClangDecompilerHighlighter>();
    private Map<ClangDecompilerHighlighter, TokenHighlights> highlighterHighlights = new HashMap<ClangDecompilerHighlighter, TokenHighlights>();
    private TokenHighlightColors secondaryHighlightColors = new TokenHighlightColors();
    private long updateId;
    private List<ClangHighlightListener> listeners = new ArrayList<ClangHighlightListener>();

    public static ClangHighlightController dummyIfNull(ClangHighlightController c) {
        if (c == null) {
            return new NullClangHighlightController();
        }
        return c;
    }

    public abstract void fieldLocationChanged(FieldLocation var1, Field var2, EventTrigger var3);

    void setHighlightColor(Color c) {
        this.defaultHighlightColor = c;
    }

    public ColorProvider getRandomColorProvider() {
        return token -> this.secondaryHighlightColors.getColor(token.getText());
    }

    public String getPrimaryHighlightedText() {
        ClangToken highlightedToken = this.getHighlightedToken();
        if (highlightedToken != null) {
            return highlightedToken.getText();
        }
        return null;
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public boolean hasPrimaryHighlight(ClangToken token) {
        return this.primaryHighlightTokens.contains(token);
    }

    public boolean hasSecondaryHighlight(ClangToken token) {
        return this.getSecondaryHighlight(token) != null;
    }

    public boolean hasSecondaryHighlights(Function function) {
        return !this.secondaryHighlightersbyFunction.get(function).isEmpty();
    }

    public Color getSecondaryHighlight(ClangToken token) {
        DecompilerHighlighter highlighter = this.getSecondaryHighlighter(token);
        if (highlighter != null) {
            TokenHighlights highlights = this.highlighterHighlights.get(highlighter);
            HighlightToken hlToken = highlights.get(token);
            return hlToken.getColor();
        }
        return null;
    }

    public TokenHighlightColors getSecondaryHighlightColors() {
        return this.secondaryHighlightColors;
    }

    public TokenHighlights getPrimaryHighlights() {
        return this.primaryHighlightTokens;
    }

    public Set<ClangDecompilerHighlighter> getSecondaryHighlighters(Function function) {
        return new HashSet<ClangDecompilerHighlighter>((Collection)this.secondaryHighlightersbyFunction.get(function));
    }

    public Set<ClangDecompilerHighlighter> getGlobalHighlighters() {
        Set<ClangDecompilerHighlighter> allHighlighters = this.highlighterHighlights.keySet();
        HashSet<ClangDecompilerHighlighter> results = new HashSet<ClangDecompilerHighlighter>(allHighlighters);
        results.removeAll(this.secondaryHighlighters);
        return results;
    }

    public TokenHighlights getHighlighterHighlights(DecompilerHighlighter highlighter) {
        return this.highlighterHighlights.get(highlighter);
    }

    public ClangToken getHighlightedToken() {
        if (this.primaryHighlightTokens.size() == 1) {
            HighlightToken hlToken = (HighlightToken)CollectionUtils.any((Iterable)this.primaryHighlightTokens);
            return hlToken.getToken();
        }
        return null;
    }

    private void gatherAllTokens(ClangNode parentNode, Set<ClangToken> results) {
        int n = parentNode.numChildren();
        for (int i = 0; i < n; ++i) {
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                this.gatherAllTokens(node, results);
                continue;
            }
            if (!(node instanceof ClangToken)) continue;
            results.add((ClangToken)node);
        }
    }

    public void clearPrimaryHighlights() {
        Consumer<ClangToken> clearAll = token -> {
            token.setMatchingToken(false);
            this.updateHighlightColor((ClangToken)token);
        };
        this.doClearHighlights(this.primaryHighlightTokens, clearAll);
        this.notifyListeners();
    }

    private void doClearHighlights(TokenHighlights tokenHighlights, Consumer<ClangToken> clearer) {
        Iterator<HighlightToken> it = tokenHighlights.iterator();
        while (it.hasNext()) {
            HighlightToken highlight = it.next();
            it.remove();
            ClangToken token = highlight.getToken();
            clearer.accept(token);
        }
    }

    public void togglePrimaryHighlights(Color hlColor, Supplier<List<ClangToken>> tokens) {
        boolean isAllHighlighted = true;
        for (ClangToken otherToken : tokens.get()) {
            if (this.hasPrimaryHighlight(otherToken)) continue;
            isAllHighlighted = false;
            break;
        }
        this.clearPrimaryHighlights();
        if (isAllHighlighted) {
            return;
        }
        this.addPrimaryHighlights(tokens, hlColor);
    }

    public void removeSecondaryHighlights(Function f) {
        List<ClangDecompilerHighlighter> highlighters = this.secondaryHighlightersbyFunction.get(f);
        for (ClangDecompilerHighlighter highlighter : highlighters) {
            TokenHighlights highlights = this.highlighterHighlights.get(highlighter);
            Consumer<ClangToken> clearHighlight = token -> this.updateHighlightColor((ClangToken)token);
            this.doClearHighlights(highlights, clearHighlight);
        }
        highlighters.clear();
        this.notifyListeners();
    }

    public void removeSecondaryHighlights(ClangToken token) {
        DecompilerHighlighter highlighter = this.getSecondaryHighlighter(token);
        if (highlighter != null) {
            highlighter.dispose();
        }
        this.notifyListeners();
    }

    private DecompilerHighlighter getSecondaryHighlighter(ClangToken token) {
        for (DecompilerHighlighter decompilerHighlighter : this.secondaryHighlighters) {
            TokenHighlights highlights = this.highlighterHighlights.get(decompilerHighlighter);
            HighlightToken hlToken = highlights.get(token);
            if (hlToken == null) continue;
            return decompilerHighlighter;
        }
        return null;
    }

    public void removeHighlighter(DecompilerHighlighter highlighter) {
        this.removeHighlighterHighlights(highlighter);
        this.highlighterHighlights.remove(highlighter);
        this.secondaryHighlighters.remove(highlighter);
        Collection<List<ClangDecompilerHighlighter>> lists = this.secondaryHighlightersbyFunction.values();
        for (List<ClangDecompilerHighlighter> highlighters : lists) {
            if (highlighters.remove(highlighter)) break;
        }
    }

    public void removeHighlighterHighlights(DecompilerHighlighter highlighter) {
        TokenHighlights highlighterTokens = this.highlighterHighlights.get(highlighter);
        if (highlighterTokens == null) {
            return;
        }
        Consumer<ClangToken> clearHighlight = token -> this.updateHighlightColor((ClangToken)token);
        this.doClearHighlights(highlighterTokens, clearHighlight);
        this.notifyListeners();
    }

    public void addSecondaryHighlighter(Function function, ClangDecompilerHighlighter highlighter) {
        this.secondaryHighlightersbyFunction.get(function).add(highlighter);
        this.secondaryHighlighters.add(highlighter);
        this.highlighterHighlights.putIfAbsent(highlighter, new TokenHighlights());
    }

    public void addHighlighter(ClangDecompilerHighlighter highlighter) {
        this.highlighterHighlights.putIfAbsent(highlighter, new TokenHighlights());
    }

    public void addHighlighterHighlights(ClangDecompilerHighlighter highlighter, Supplier<? extends Collection<ClangToken>> tokens, ColorProvider colorProvider) {
        Objects.requireNonNull(highlighter);
        TokenHighlights highlighterTokens = this.highlighterHighlights.computeIfAbsent(highlighter, k -> new TokenHighlights());
        this.addTokensToHighlights(tokens.get(), colorProvider, highlighterTokens);
    }

    private void addPrimaryHighlights(Supplier<? extends Collection<ClangToken>> tokens, Color hlColor) {
        ColorProvider colorProvider = token -> hlColor;
        this.addTokensToHighlights(tokens.get(), colorProvider, this.primaryHighlightTokens);
    }

    public void addPrimaryHighlights(ClangNode parentNode, Set<PcodeOp> ops, Color hlColor) {
        this.addPrimaryHighlights(parentNode, (ClangToken token) -> {
            PcodeOp op = token.getPcodeOp();
            return ops.contains(op) ? hlColor : null;
        });
    }

    public void addPrimaryHighlights(ClangNode parentNode, ColorProvider colorProvider) {
        HashSet<ClangToken> tokens = new HashSet<ClangToken>();
        this.gatherAllTokens(parentNode, tokens);
        this.addTokensToHighlights(tokens, colorProvider::getColor, this.primaryHighlightTokens);
    }

    private void addPrimaryHighlights(Collection<ClangToken> tokens, Color hlColor) {
        ColorProvider colorProvider = token -> hlColor;
        this.addTokensToHighlights(tokens, colorProvider, this.primaryHighlightTokens);
    }

    private void addTokensToHighlights(Collection<ClangToken> tokens, ColorProvider colorProvider, TokenHighlights currentHighlights) {
        ++this.updateId;
        for (ClangToken clangToken : tokens) {
            Color color = colorProvider.getColor(clangToken);
            this.doAddHighlight(clangToken, color, currentHighlights);
        }
        this.notifyListeners();
    }

    protected void addPrimaryHighlight(ClangToken token, Color highlightColor) {
        this.addPrimaryHighlights(Set.of(token), highlightColor);
    }

    private void doAddHighlight(ClangToken clangToken, Color highlightColor, TokenHighlights currentHighlights) {
        if (highlightColor == null) {
            return;
        }
        currentHighlights.add(new HighlightToken(clangToken, highlightColor));
        this.updateHighlightColor(clangToken);
    }

    private void updateHighlightColor(ClangToken t) {
        Color combinedColor = this.getCombinedColor(t);
        t.setHighlight(combinedColor);
    }

    private void add(List<Color> colors, HighlightToken hlToken) {
        if (hlToken != null) {
            colors.add(hlToken.getColor());
        }
    }

    private void add(List<Color> colors, Color c) {
        if (c != null) {
            colors.add(c);
        }
    }

    public Color getCombinedColor(ClangToken t) {
        HighlightToken primaryHl = this.primaryHighlightTokens.get(t);
        Color blendedHlColor = this.blendHighlighterColors(t);
        ArrayList<Color> allColors = new ArrayList<Color>();
        this.add(allColors, primaryHl);
        this.add(allColors, blendedHlColor);
        Color blended = this.blend(allColors);
        return blended;
    }

    public Color blend(List<Color> colors) {
        if (colors.isEmpty()) {
            return null;
        }
        if (colors.size() == 1) {
            return (Color)CollectionUtils.any(colors);
        }
        Color lastColor = colors.get(0);
        for (int i = 1; i < colors.size(); ++i) {
            Color nextColor = colors.get(i);
            lastColor = ColorUtils.blend((Color)lastColor, (Color)nextColor, (double)0.8f);
        }
        return lastColor;
    }

    private Color blendHighlighterColors(ClangToken token) {
        Function function = this.getFunction(token);
        if (function == null) {
            return null;
        }
        Set<ClangDecompilerHighlighter> global = this.getGlobalHighlighters();
        Set<ClangDecompilerHighlighter> secondary = this.getSecondaryHighlighters(function);
        Iterable it = CollectionUtils.asIterable((Iterable[])new Iterable[]{global, secondary});
        Color lastColor = null;
        for (ClangDecompilerHighlighter highlighter : it) {
            TokenHighlights highlights = this.highlighterHighlights.get(highlighter);
            HighlightToken hlToken = highlights.get(token);
            if (hlToken == null) continue;
            Color nextColor = hlToken.getColor();
            if (lastColor != null) {
                lastColor = ColorUtils.blend((Color)lastColor, (Color)nextColor, (double)0.8f);
                continue;
            }
            lastColor = nextColor;
        }
        return lastColor;
    }

    private Function getFunction(ClangToken t) {
        ClangFunction cFunction = t.getClangFunction();
        if (cFunction == null) {
            return null;
        }
        HighFunction highFunction = cFunction.getHighFunction();
        if (highFunction == null) {
            return null;
        }
        return highFunction.getFunction();
    }

    protected List<ClangToken> addPrimaryHighlightToTokensForParenthesis(ClangSyntaxToken tok, Color highlightColor) {
        int paren = tok.getOpen();
        if (paren == -1) {
            paren = tok.getClose();
        }
        if (paren == -1) {
            return new ArrayList<ClangToken>();
        }
        List<ClangToken> results = this.gatherContentsOfParenthesis(tok, paren);
        this.addPrimaryHighlights(results, highlightColor);
        return results;
    }

    private List<ClangToken> gatherContentsOfParenthesis(ClangSyntaxToken tok, int parenId) {
        ArrayList<ClangToken> results = new ArrayList<ClangToken>();
        int parenCount = 0;
        ClangNode par = tok.Parent();
        while (par != null) {
            boolean outside = true;
            if (!(par instanceof ClangTokenGroup)) {
                par = par.Parent();
                continue;
            }
            ArrayList<ClangNode> list = new ArrayList<ClangNode>();
            ((ClangTokenGroup)par).flatten(list);
            for (ClangNode node : list) {
                ClangToken tk = (ClangToken)node;
                if (tk instanceof ClangSyntaxToken) {
                    ClangSyntaxToken syn = (ClangSyntaxToken)tk;
                    if (syn.getOpen() == parenId) {
                        ++parenCount;
                        outside = false;
                    } else if (syn.getClose() == parenId) {
                        ++parenCount;
                        outside = true;
                        results.add(syn);
                    }
                }
                if (!outside) {
                    results.add(tk);
                }
                if (parenCount != 2) continue;
                return results;
            }
            par = par.Parent();
        }
        return results;
    }

    public void addBraceHighlight(ClangSyntaxToken token, Color highlightColor) {
        if (DecompilerUtils.isBrace(token)) {
            this.highlightBrace(token, highlightColor);
            this.notifyListeners();
        }
    }

    private void highlightBrace(ClangSyntaxToken startToken, Color highlightColor) {
        ClangSyntaxToken matchingBrace = DecompilerUtils.getMatchingBrace(startToken);
        if (matchingBrace != null) {
            matchingBrace.setMatchingToken(true);
            this.addPrimaryHighlights(Set.of(matchingBrace), highlightColor);
        }
    }

    public void addListener(ClangHighlightListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ClangHighlightListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ClangHighlightListener listener : this.listeners) {
            listener.tokenHighlightsChanged();
        }
    }

    public void dispose() {
        this.listeners.clear();
        this.primaryHighlightTokens.clear();
        this.secondaryHighlighters.clear();
        this.secondaryHighlightersbyFunction.clear();
        this.highlighterHighlights.clear();
    }
}

