/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingType;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionShellSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.UndefinedFunction;
import ghidra.util.data.DataTypeParser;

public abstract class AbstractDecompilerAction
extends DockingAction {
    AbstractDecompilerAction(String name) {
        super(name, DecompilePlugin.class.getSimpleName());
    }

    AbstractDecompilerAction(String name, KeyBindingType kbType) {
        super(name, DecompilePlugin.class.getSimpleName(), kbType);
    }

    public boolean isValidContext(ActionContext context) {
        return context instanceof DecompilerActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        return decompilerContext.checkActionEnablement(() -> this.isEnabledForDecompilerContext(decompilerContext));
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerContext = (DecompilerActionContext)context;
        decompilerContext.performAction(() -> this.decompilerActionPerformed(decompilerContext));
    }

    public static Composite getCompositeDataType(ClangToken tok) {
        ClangFieldToken fieldtok = (ClangFieldToken)tok;
        DataType dt = fieldtok.getDataType();
        if (dt == null) {
            return null;
        }
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Composite) {
            return (Composite)dt;
        }
        return null;
    }

    protected static boolean checkFullCommit(HighSymbol highSymbol, HighFunction hfunction) {
        if (highSymbol != null && !highSymbol.isParameter()) {
            return false;
        }
        Function function = hfunction.getFunction();
        Parameter[] parameters = function.getParameters();
        LocalSymbolMap localSymbolMap = hfunction.getLocalSymbolMap();
        int numParams = localSymbolMap.getNumParams();
        if (numParams != parameters.length) {
            return true;
        }
        for (int i = 0; i < numParams; ++i) {
            HighSymbol param = localSymbolMap.getParamSymbol(i);
            if (param.getCategoryIndex() != i) {
                return true;
            }
            VariableStorage storage = param.getStorage();
            if (0 == storage.compareTo(parameters[i].getVariableStorage())) continue;
            return true;
        }
        return false;
    }

    protected static DataType chooseDataType(PluginTool tool, Program program, DataType currentDataType) {
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        DataTypeSelectionDialog chooserDialog = new DataTypeSelectionDialog(tool, (DataTypeManager)dataTypeManager, Integer.MAX_VALUE, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
        chooserDialog.setInitialDataType(currentDataType);
        tool.showDialog((DialogComponentProvider)chooserDialog);
        return chooserDialog.getUserChosenDataType();
    }

    protected Symbol getSymbol(DecompilerActionContext context) {
        Function function = this.getFunction(context);
        if (function != null && !(function instanceof UndefinedFunction)) {
            return function.getSymbol();
        }
        Program program = context.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        Address address = context.getAddress();
        if (address == null) {
            return null;
        }
        return symbolTable.getPrimarySymbol(address);
    }

    protected Function getFunction(DecompilerActionContext context) {
        ClangToken token = context.getTokenAtCursor();
        Function f = null;
        if (token instanceof ClangFuncNameToken) {
            f = DecompilerUtils.getFunction(context.getProgram(), (ClangFuncNameToken)token);
        } else {
            HighSymbol highSymbol = token.getHighSymbol(context.getHighFunction());
            if (highSymbol instanceof HighFunctionShellSymbol) {
                f = (Function)highSymbol.getSymbol().getObject();
            }
        }
        while (f != null && f.isThunk() && f.getSymbol().getSource() == SourceType.DEFAULT) {
            f = f.getThunkedFunction(false);
        }
        return f;
    }

    protected abstract boolean isEnabledForDecompilerContext(DecompilerActionContext var1);

    protected abstract void decompilerActionPerformed(DecompilerActionContext var1);
}

