/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.OverridePrototypeAction;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class DeletePrototypeOverrideAction
extends AbstractDecompilerAction {
    public DeletePrototypeOverrideAction() {
        super("Remove Signature Override");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRemoveOverride"));
        this.setPopupMenuData(new MenuData(new String[]{"Remove Signature Override"}, "Decompile"));
    }

    public static CodeSymbol getSymbol(Function func, ClangToken tokenAtCursor) {
        if (tokenAtCursor == null) {
            return null;
        }
        Namespace overspace = HighFunction.findOverrideSpace((Function)func);
        if (overspace == null) {
            return null;
        }
        PcodeOp op = OverridePrototypeAction.getCallOp(func.getProgram(), tokenAtCursor);
        if (op == null) {
            return null;
        }
        SymbolTable symtab = func.getProgram().getSymbolTable();
        SymbolIterator iter = symtab.getSymbolsAsIterator(op.getSeqnum().getTarget());
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!sym.getName().startsWith("prt") || !(sym instanceof CodeSymbol) || !sym.getParentNamespace().equals(overspace)) continue;
            return (CodeSymbol)sym;
        }
        return null;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        return DeletePrototypeOverrideAction.getSymbol(function, context.getTokenAtCursor()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function func = context.getFunction();
        CodeSymbol sym = DeletePrototypeOverrideAction.getSymbol(func, context.getTokenAtCursor());
        Program program = func.getProgram();
        SymbolTable symtab = program.getSymbolTable();
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        int txId = program.startTransaction("Remove Override Signature");
        try {
            symtab.removeSymbolSpecial((Symbol)sym);
        }
        finally {
            program.endTransaction(txId, true);
        }
    }
}

