/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetTogglable;
import ghidra.dbg.target.schema.TargetAttributeType;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@DebuggerTargetObjectIface(value="BreakpointSpec")
public interface TargetBreakpointSpec
extends TargetObject,
TargetTogglable {
    public static final String CONTAINER_ATTRIBUTE_NAME = "_container";
    public static final String EXPRESSION_ATTRIBUTE_NAME = "_expression";
    public static final String KINDS_ATTRIBUTE_NAME = "_kinds";
    public static final String AS_BPT_ATTRIBUTE_NAME = "_bpt";

    @TargetAttributeType(name="_container", required=true, hidden=true)
    default public TargetBreakpointSpecContainer getContainer() {
        return this.getTypedAttributeNowByName(CONTAINER_ATTRIBUTE_NAME, TargetBreakpointSpecContainer.class, null);
    }

    @TargetAttributeType(name="_expression", required=true, hidden=true)
    default public String getExpression() {
        return this.getTypedAttributeNowByName(EXPRESSION_ATTRIBUTE_NAME, String.class, "");
    }

    @TargetAttributeType(name="_kinds", required=true, hidden=true)
    default public TargetBreakpointSpecContainer.TargetBreakpointKindSet getKinds() {
        return this.getTypedAttributeNowByName(KINDS_ATTRIBUTE_NAME, TargetBreakpointSpecContainer.TargetBreakpointKindSet.class, TargetBreakpointSpecContainer.TargetBreakpointKindSet.EMPTY);
    }

    public void addAction(TargetBreakpointAction var1);

    public void removeAction(TargetBreakpointAction var1);

    default public CompletableFuture<? extends Collection<? extends TargetBreakpointLocation>> getLocations() {
        if (this instanceof TargetBreakpointLocation) {
            return CompletableFuture.completedFuture(List.of((TargetBreakpointLocation)((Object)this)));
        }
        return DebugModelConventions.collectSuccessors(this, TargetBreakpointLocation.class);
    }

    public static interface TargetBreakpointAction {
        public void breakpointHit(TargetBreakpointSpec var1, TargetObject var2, TargetStackFrame var3, TargetBreakpointLocation var4);
    }

    public static enum TargetBreakpointKind {
        READ,
        WRITE,
        HW_EXECUTE,
        SW_EXECUTE;

    }
}

