/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.ComponentProvider;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectNode;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectPane;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTreeCellRenderer;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class ObjectTree
implements ObjectPane {
    public static final Icon ICON_TREE = new GIcon("icon.debugger.tree.object");
    private final ObjectNode root;
    private final MyGTree tree;
    private final Map<String, ObjectNode> nodeMap = new LinkedHashMap<String, ObjectNode>();
    private final SwingUpdateManager restoreTreeStateManager = new SwingUpdateManager(this::restoreTreeState);
    private TreePath[] currentSelectionPaths;
    private List<TreePath> currentExpandedPaths;
    private Point currentViewPosition;

    public ObjectTree(final ObjectContainer container) {
        this.root = new ObjectNode(this, null, container);
        this.addToMap(null, container, this.root);
        this.tree = new MyGTree((GTreeNode)this.root);
        this.tree.addGTreeSelectionListener(new GTreeSelectionListener(){

            public void valueChanged(GTreeSelectionEvent e) {
                TreePath currentPath;
                TreePath selectedPath;
                DebuggerObjectsProvider provider = container.getProvider();
                provider.updateActions(container);
                provider.getTool().contextChanged((ComponentProvider)provider);
                if (e.getEventOrigin() == GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED) {
                    ObjectTree.this.restoreTreeStateManager.updateLater();
                    return;
                }
                TreePath[] selectionPaths = ObjectTree.this.tree.getSelectionPaths();
                if (e.getEventOrigin() == GTreeSelectionEvent.EventOrigin.API_GENERATED && ObjectTree.this.currentSelectionPaths != null && ObjectTree.this.currentSelectionPaths.length > 0 && selectionPaths != null && selectionPaths.length > 0 && (selectedPath = selectionPaths[0]).isDescendant(currentPath = ObjectTree.this.currentSelectionPaths[0])) {
                    return;
                }
                ObjectTree.this.currentSelectionPaths = selectionPaths;
                List paths = ObjectTree.this.tree.getExpandedPaths();
                if (ObjectTree.this.currentExpandedPaths == null) {
                    ObjectTree.this.currentExpandedPaths = paths;
                } else if (paths != null && paths.size() >= ObjectTree.this.currentExpandedPaths.size()) {
                    ObjectTree.this.currentExpandedPaths = paths;
                }
                ObjectTree.this.currentViewPosition = ObjectTree.this.tree.getViewPosition();
                ObjectTree.this.restoreTreeStateManager.updateLater();
            }
        });
        this.tree.setCellRenderer(new ObjectTreeCellRenderer(this.root.getProvider()));
        this.tree.setDataTransformer(t -> {
            if (t instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)((Object)t);
                return List.of(node.getContainer().getDecoratedName());
            }
            return null;
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath expandedPath = event.getPath();
                Object last = expandedPath.getLastPathComponent();
                if (last instanceof ObjectNode) {
                    ObjectNode node = (ObjectNode)((Object)last);
                    node.markExpanded();
                    ObjectTree.this.currentExpandedPaths = ObjectTree.this.tree.getExpandedPaths();
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath collapsedPath = event.getPath();
                Object last = collapsedPath.getLastPathComponent();
                if (last instanceof ObjectNode) {
                    ObjectNode node = (ObjectNode)((Object)last);
                    node.markCollapsed();
                    ObjectTree.this.currentExpandedPaths = ObjectTree.this.tree.getExpandedPaths();
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ObjectTree.this.activateOrNavigateSelectedObject();
                }
            }
        });
        this.tree.tree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjectTree.this.activateOrNavigateSelectedObject();
                    e.consume();
                }
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setSelectedNode((GTreeNode)this.root);
    }

    private void activateOrNavigateSelectedObject() {
        TargetObject object = this.getSelectedObject();
        if (object == null) {
            return;
        }
        if (this.getProvider().navigateToSelectedObject(object, null) != null) {
            return;
        }
        if (object instanceof DummyTargetObject) {
            return;
        }
        DebugModelConventions.requestActivation((TargetObject)object).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could not activate " + object), (Throwable)ex);
            return null;
        });
    }

    @Override
    public ObjectContainer getContainer() {
        return this.root.getContainer();
    }

    @Override
    public TargetObject getTargetObject() {
        return this.root.getTargetObject();
    }

    public DebuggerObjectsProvider getProvider() {
        return this.root.getProvider();
    }

    @Override
    public TargetObject getSelectedObject() {
        Object last;
        TreePath path = this.tree.getSelectionPath();
        if (path == null && this.currentSelectionPaths != null && this.currentSelectionPaths.length > 0) {
            path = this.currentSelectionPaths[0];
        }
        if (path != null && (last = path.getLastPathComponent()) instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)((Object)last);
            return node.getContainer().getTargetObject();
        }
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.tree;
    }

    @Override
    public JComponent getPrincipalComponent() {
        return this.tree;
    }

    private void restoreTreeState() {
        if (this.currentExpandedPaths != null && !this.tree.getExpandedPaths().equals(this.currentExpandedPaths)) {
            this.tree.expandPaths(this.currentExpandedPaths);
        }
        if (this.currentSelectionPaths != null) {
            this.tree.setSelectionPaths(this.currentSelectionPaths);
        }
        if (this.currentViewPosition != null) {
            this.tree.runTask(m -> {
                if (this.currentViewPosition != null) {
                    this.tree.setViewPosition(this.currentViewPosition);
                }
                this.currentViewPosition = null;
            });
        }
    }

    @Override
    public String getName() {
        TargetObject targetObject = this.getTargetObject();
        return targetObject == null ? "Main" : targetObject.getName();
    }

    @Override
    public void signalContentsChanged(ObjectContainer container) {
        ObjectNode node = this.nodeMap.get(this.path(container));
        if (node != null) {
            node.callUpdate();
        }
    }

    @Override
    public void signalDataChanged(ObjectContainer container) {
        Swing.runIfSwingOrRunLater(() -> {
            ObjectNode node = this.nodeMap.get(this.path(container));
            if (node != null) {
                node.setContainer(this, container.getParent(), container);
                node.fireNodeChanged();
            }
        });
    }

    @Override
    public void signalUpdate(ObjectContainer container) {
        AtomicReference access = new AtomicReference();
        TargetObject targetObject = container.getTargetObject();
        if (targetObject == null) {
            return;
        }
        AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then(seq -> DebugModelConventions.findSuitable(TargetAccessConditioned.class, (TargetObject)targetObject).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForProducer)seq).next(arg_0, arg_1)), access).then(seq -> {
            boolean accessible = true;
            TargetAccessConditioned conditioned = (TargetAccessConditioned)access.get();
            if (conditioned != null) {
                accessible = conditioned.isAccessible();
            }
            if (accessible) {
                Swing.runIfSwingOrRunLater(() -> {
                    ObjectNode node = this.nodeMap.get(this.path(container));
                    if (node != null) {
                        if (this.currentSelectionPaths == null) {
                            this.currentSelectionPaths = this.tree.getSelectionPaths();
                        }
                        if (this.currentExpandedPaths == null) {
                            this.currentExpandedPaths = this.tree.getExpandedPaths();
                        }
                        if (this.currentViewPosition == null) {
                            this.currentViewPosition = this.tree.getViewPosition();
                        }
                        this.tree.runTask(monitor -> node.unloadChildren());
                        this.restoreTreeStateManager.updateLater();
                    }
                });
            }
        }).finish();
    }

    public void waitOnLoad() {
        List expandedPaths = this.tree.getExpandedPaths();
        while (!this.checkLoaded(expandedPaths)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkLoaded(List<TreePath> expandedPaths) {
        for (TreePath path : expandedPaths) {
            Object[] objs = path.getPath();
            for (int i = 0; i < objs.length - 2; ++i) {
                ObjectNode node;
                Object object = objs[i];
                if (!(object instanceof ObjectNode) || (node = (ObjectNode)((Object)object)).isLoaded()) continue;
                return false;
            }
        }
        return true;
    }

    public List<GTreeNode> update(ObjectContainer container) {
        ObjectNode node = this.nodeMap.get(this.path(container));
        if (node == null) {
            if (this.path(container) != null) {
                Msg.warn((Object)this, (Object)("Missing node: " + this.path(container)));
            }
            return new ArrayList<GTreeNode>();
        }
        Set<ObjectContainer> currentChildren = container.getCurrentChildren();
        ArrayList<GTreeNode> childList = new ArrayList<GTreeNode>();
        node.setRestructured(false);
        for (ObjectContainer c : currentChildren) {
            ObjectNode nc;
            String path = this.path(c);
            boolean hideIntrinsics = this.getContainer().getProvider().isHideIntrinsics();
            if (!c.isVisible() && hideIntrinsics) continue;
            if (this.nodeMap.containsKey(path)) {
                nc = this.nodeMap.get(path);
                nc.setContainer(this, container, c);
            } else {
                node.setRestructured(true);
                nc = new ObjectNode(this, container, c);
            }
            childList.add((GTreeNode)nc);
        }
        node.markExpanded();
        node.cleanUpOldChildren(childList);
        return childList;
    }

    private String path(ObjectContainer container) {
        if (container == null) {
            return null;
        }
        return container.getTreePath();
    }

    @Override
    public void setFocus(TargetObject object, TargetObject focused) {
        Swing.runIfSwingOrRunLater(() -> {
            List path = focused.getPath();
            this.tree.setSelectedNodeByNamePath(this.addRootNameToPath(path));
        });
    }

    @Override
    public void setSelectedObject(TargetObject object) {
        Swing.runIfSwingOrRunLater(() -> {
            List path = object.getPath();
            this.tree.setSelectedNodeByNamePath(this.addRootNameToPath(path));
        });
    }

    private String[] addRootNameToPath(List<String> path) {
        String[] fullPath = new String[path.size() + 1];
        fullPath[0] = this.tree.getModelRoot().getName();
        for (int i = 0; i < path.size(); ++i) {
            fullPath[i + 1] = path.get(i);
        }
        return fullPath;
    }

    public void addToMap(ObjectContainer parent, ObjectContainer container, ObjectNode node) {
        String ppath = parent == null ? "" : parent.getTreePath();
        String tpath = ppath + ":" + node.getName();
        container.setTreePath(tpath);
        this.nodeMap.put(tpath, node);
    }

    @Override
    public void setRoot(ObjectContainer container, TargetObject targetObject) {
        this.nodeMap.remove(this.path(container));
        container.setTargetObject(targetObject);
        this.root.setContainer(this, null, container);
        this.nodeMap.put(this.path(container), this.root);
        this.tree.setRootVisible(true);
    }

    public void setSelectedNode(ObjectNode node) {
        if (this.tree != null) {
            this.tree.setSelectedNode((GTreeNode)node);
        }
    }

    public void cleanupOldNode(ObjectNode node) {
        DebuggerObjectsProvider provider = this.getProvider();
        ObjectContainer oc = node.getContainer();
        provider.deleteFromMap(oc);
        this.nodeMap.remove(this.path(node.getContainer()));
    }

    private static class MyGTree
    extends GTree {
        public MyGTree(GTreeNode root) {
            super(root);
            this.getJTree().setToggleClickCount(0);
        }

        private JTree tree() {
            return this.getJTree();
        }
    }
}

