/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.launch;

import db.Transaction;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerMethodInvocationDialog;
import ghidra.app.plugin.core.debug.service.model.launch.DebuggerProgramLaunchOffer;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MapProposal;
import ghidra.app.services.ModuleMapProposal;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncTimer;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceModule;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractDebuggerProgramLaunchOffer
implements DebuggerProgramLaunchOffer {
    private static final String HTML = "<html><p style='width:300px;'>";
    private static final String NO_PAUSE_DIAGNOSTIC_MESSAGE = "It's possible the target launched but never paused, and so Ghidra has not been able to inspect it. Try interrupting the target, then inspect the process list. Further intervention may be required to establish the module/address mappings.";
    protected final Program program;
    protected final PluginTool tool;
    protected final DebuggerModelFactory factory;

    public AbstractDebuggerProgramLaunchOffer(Program program, PluginTool tool, DebuggerModelFactory factory) {
        this.program = program;
        this.tool = tool;
        this.factory = factory;
    }

    @Override
    public String getMenuParentTitle() {
        String name = this.program.getName();
        DomainFile df = this.program.getDomainFile();
        if (df != null) {
            name = df.getName();
        }
        return "Debug " + name;
    }

    protected List<String> getLauncherPath() {
        return PathUtils.parse((String)"");
    }

    protected long getTimeoutMillis() {
        return 10000L;
    }

    protected CompletableFuture<TargetObject> listenForTarget(final DebuggerObjectModel model) {
        var result = new CompletableFuture<TargetObject>(){
            DebuggerModelListener listener = new DebuggerModelListener(){

                protected void checkObject(TargetObject object) {
                    if (DebugModelConventions.liveProcessOrNull((TargetObject)object) == null) {
                        return;
                    }
                    this.complete(object);
                    model.removeModelListener((DebuggerModelListener)this);
                }

                public void created(TargetObject object) {
                    this.checkObject(object);
                }

                public void attributesChanged(TargetObject object, Collection<String> removed, Map<String, ?> added) {
                    if (!added.containsKey("_state")) {
                        return;
                    }
                    this.checkObject(object);
                }
            };
        };
        model.addModelListener(result.listener);
        result.exceptionally(ex -> {
            model.removeModelListener(result.listener);
            return null;
        });
        return result;
    }

    protected CompletableFuture<TraceRecorder> listenForRecorder(final DebuggerModelService service, final TargetObject target) {
        var result = new CompletableFuture<TraceRecorder>(){
            CollectionChangeListener<TraceRecorder> listener = new CollectionChangeListener<TraceRecorder>(){

                public void elementAdded(TraceRecorder element) {
                    if (element.getTarget() == target) {
                        this.complete(element);
                        service.removeTraceRecordersChangedListener(this);
                    }
                }
            };
        };
        service.addTraceRecordersChangedListener(result.listener);
        result.exceptionally(ex -> {
            service.removeTraceRecordersChangedListener(result.listener);
            return null;
        });
        return result;
    }

    protected Address getMappingProbeAddress() {
        AddressIterator eepi = this.program.getSymbolTable().getExternalEntryPointIterator();
        if (eepi.hasNext()) {
            return eepi.next();
        }
        InstructionIterator ii = this.program.getListing().getInstructions(true);
        if (ii.hasNext()) {
            return ii.next().getAddress();
        }
        AddressSetView es = this.program.getMemory().getExecuteSet();
        if (!es.isEmpty()) {
            return es.getMinAddress();
        }
        if (!this.program.getMemory().isEmpty()) {
            return this.program.getMinAddress();
        }
        return null;
    }

    protected CompletableFuture<Void> listenForMapping(final DebuggerStaticMappingService mappingService, final TraceRecorder recorder) {
        final ProgramLocation probe = new ProgramLocation(this.program, this.getMappingProbeAddress());
        final Trace trace = recorder.getTrace();
        var result = new CompletableFuture<Void>(){
            DebuggerStaticMappingChangeListener listener = (affectedTraces, affectedPrograms) -> {
                if (!affectedPrograms.contains(AbstractDebuggerProgramLaunchOffer.this.program) && !affectedTraces.contains(trace)) {
                    return;
                }
                this.check();
            };

            protected void check() {
                TraceLocation result = mappingService.getOpenMappedLocation(trace, probe, recorder.getSnap());
                if (result == null) {
                    return;
                }
                this.complete(null);
                mappingService.removeChangeListener(this.listener);
            }
        };
        mappingService.addChangeListener(result.listener);
        result.check();
        result.exceptionally(ex -> {
            mappingService.removeChangeListener(result.listener);
            return null;
        });
        return result;
    }

    protected Collection<ModuleMapProposal.ModuleMapEntry> invokeMapper(TaskMonitor monitor, DebuggerStaticMappingService mappingService, TraceRecorder recorder) throws CancelledException {
        Map<TraceModule, ModuleMapProposal> map = mappingService.proposeModuleMaps(recorder.getTrace().getModuleManager().getAllModules(), List.of(this.program));
        Collection<ModuleMapProposal.ModuleMapEntry> proposal = MapProposal.flatten(map.values());
        mappingService.addModuleMappings(proposal, monitor, true);
        return proposal;
    }

    private void saveLauncherArgs(Map<String, ?> args, Map<String, TargetMethod.ParameterDescription<?>> params) {
        SaveState state = new SaveState();
        for (TargetMethod.ParameterDescription<?> param : params.values()) {
            Object val = args.get(param.name);
            if (val == null) continue;
            AutoConfigState.ConfigStateField.putState((SaveState)state, param.type.asSubclass(Object.class), (String)param.name, val);
        }
        if (this.program != null) {
            ProgramUserData userData = this.program.getProgramUserData();
            try (Transaction tx = userData.openTransaction();){
                Element element = state.saveToXml();
                userData.setStringProperty("args", XmlUtilities.toString((Element)element));
            }
        }
    }

    protected Map<String, ?> takeDefaultsForParameters(Map<String, TargetMethod.ParameterDescription<?>> params) {
        return params.values().stream().collect(Collectors.toMap(p -> p.name, p -> p.defaultValue));
    }

    protected Map<String, ?> generateDefaultLauncherArgs(Map<String, TargetMethod.ParameterDescription<?>> params) {
        if (this.program == null) {
            return Map.of();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, TargetMethod.ParameterDescription<?>> entry : params.entrySet()) {
            map.put(entry.getKey(), entry.getValue().defaultValue);
        }
        map.put("args", TargetLauncher.TargetCmdLineLauncher.quoteImagePathIfSpaces((String)this.program.getExecutablePath()));
        return map;
    }

    protected Map<String, ?> promptLauncherArgs(TargetLauncher launcher, DebuggerProgramLaunchOffer.LaunchConfigurator configurator) {
        Map<String, ?> args;
        TargetMethod.TargetParameterMap params = launcher.getParameters();
        DebuggerMethodInvocationDialog dialog = new DebuggerMethodInvocationDialog(this.tool, this.getButtonTitle(), "Launch", this.getIcon());
        boolean reset = false;
        do {
            args = configurator.configureLauncher(launcher, this.loadLastLauncherArgs(launcher, true), DebuggerProgramLaunchOffer.RelPrompt.BEFORE);
            for (TargetMethod.ParameterDescription param : params.values()) {
                Object val = args.get(param.name);
                if (val == null) continue;
                dialog.setMemorizedArgument(param.name, param.type.asSubclass(Object.class), val);
            }
            args = dialog.promptArguments((Map<String, TargetMethod.ParameterDescription<?>>)params);
            if (args == null) {
                return null;
            }
            reset = dialog.isResetRequested();
            if (reset) {
                args = this.generateDefaultLauncherArgs((Map<String, TargetMethod.ParameterDescription<?>>)params);
            }
            this.saveLauncherArgs(args, (Map<String, TargetMethod.ParameterDescription<?>>)params);
        } while (reset);
        return args;
    }

    protected Map<String, ?> loadLastLauncherArgs(TargetLauncher launcher, boolean forPrompt) {
        if (this.program != null) {
            TargetMethod.TargetParameterMap params = launcher.getParameters();
            ProgramUserData userData = this.program.getProgramUserData();
            String property = userData.getStringProperty("args", null);
            if (property != null) {
                try {
                    Element element = XmlUtilities.fromString((String)property);
                    SaveState state = new SaveState(element);
                    List<String> names = List.of(state.getNames());
                    LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                    for (TargetMethod.ParameterDescription param : params.values()) {
                        Object configState;
                        if (!names.contains(param.name) || (configState = AutoConfigState.ConfigStateField.getState((SaveState)state, (Class)param.type, (String)param.name)) == null) continue;
                        args.put(param.name, configState);
                    }
                    if (!args.isEmpty()) {
                        return args;
                    }
                }
                catch (IOException | JDOMException e) {
                    if (!forPrompt) {
                        throw new RuntimeException("Saved launcher args are corrupt, or launcher parameters changed. Not launching.", e);
                    }
                    Msg.error((Object)this, (Object)"Saved launcher args are corrupt, or launcher parameters changed. Defaulting.", (Throwable)e);
                }
            }
            Map<String, ?> args = this.generateDefaultLauncherArgs((Map<String, TargetMethod.ParameterDescription<?>>)params);
            this.saveLauncherArgs(args, (Map<String, TargetMethod.ParameterDescription<?>>)params);
            return args;
        }
        return new LinkedHashMap();
    }

    public Map<String, ?> getLauncherArgs(TargetLauncher launcher, boolean prompt, DebuggerProgramLaunchOffer.LaunchConfigurator configurator) {
        return prompt ? configurator.configureLauncher(launcher, this.promptLauncherArgs(launcher, configurator), DebuggerProgramLaunchOffer.RelPrompt.AFTER) : configurator.configureLauncher(launcher, this.loadLastLauncherArgs(launcher, false), DebuggerProgramLaunchOffer.RelPrompt.NONE);
    }

    public Map<String, ?> getLauncherArgs(TargetLauncher launcher, boolean prompt) {
        return this.getLauncherArgs(launcher, prompt, DebuggerProgramLaunchOffer.LaunchConfigurator.NOP);
    }

    protected DebuggerModelFactory getModelFactory() {
        return this.factory;
    }

    protected CompletableFuture<DebuggerObjectModel> connect(DebuggerModelService service, boolean prompt, DebuggerProgramLaunchOffer.LaunchConfigurator configurator) {
        DebuggerModelFactory factory = this.getModelFactory();
        configurator.configureConnector(factory);
        if (prompt) {
            return service.showConnectDialog(factory);
        }
        return factory.build().thenApplyAsync(m -> {
            service.addModel((DebuggerObjectModel)m);
            return m;
        }, (Executor)SwingExecutorService.LATER);
    }

    protected CompletableFuture<TargetLauncher> findLauncher(DebuggerObjectModel m) {
        List<String> launcherPath = this.getLauncherPath();
        TargetObjectSchema schema = m.getRootSchema().getSuccessorSchema(launcherPath);
        if (!schema.getInterfaces().contains(TargetLauncher.class)) {
            throw new AssertionError((Object)"LaunchOffer / model implementation error: The given launcher path is not a TargetLauncher, according to its schema");
        }
        return new ValueExpecter(m, launcherPath).thenApply(o -> (TargetLauncher)o);
    }

    protected CompletableFuture<Void> launch(TargetLauncher launcher, boolean prompt, DebuggerProgramLaunchOffer.LaunchConfigurator configurator, TaskMonitor monitor) {
        Map<String, ?> args = this.getLauncherArgs(launcher, prompt, configurator);
        if (args == null) {
            throw new CancellationException();
        }
        return AsyncTimer.DEFAULT_TIMER.mark().timeOut(launcher.launch(args), this.getTimeoutMillis(), () -> this.onTimedOutLaunch(monitor));
    }

    protected void checkCancelled(TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            throw new CancellationException("User cancelled");
        }
    }

    protected TargetLauncher onTimedOutFindLauncher(TaskMonitor monitor) {
        this.checkCancelled(monitor);
        monitor.setMessage("Timed out finding the launcher. Aborting.");
        JOptionPane.showMessageDialog(null, "<html><p style='width:300px;'>Timed out finding the launcher. This indicates an error in the implementation of the connector and/or the launcher opinion. Try again, and/or report the bug.", this.getMenuParentTitle(), 0);
        throw new CancellationException("Timed out");
    }

    protected Void onTimedOutLaunch(TaskMonitor monitor) {
        this.checkCancelled(monitor);
        monitor.setMessage("Timed out waiting for launch. Aborting.");
        JOptionPane.showMessageDialog(null, "<html><p style='width:300px;'>Timed out waiting for launch. It's possible the target launched but never paused, and so Ghidra has not been able to inspect it. Try interrupting the target, then inspect the process list. Further intervention may be required to establish the module/address mappings.", this.getMenuParentTitle(), 0);
        throw new CancellationException("Timed out");
    }

    protected TargetObject onTimedOutTarget(TaskMonitor monitor) {
        this.checkCancelled(monitor);
        monitor.setMessage("Timed out waiting for target. Aborting.");
        JOptionPane.showMessageDialog(null, "<html><p style='width:300px;'>Timed out waiting for target. It's possible the target launched but never paused, and so Ghidra has not been able to inspect it. Try interrupting the target, then inspect the process list. Further intervention may be required to establish the module/address mappings.", this.getMenuParentTitle(), 0);
        throw new CancellationException("Timed out");
    }

    protected CompletableFuture<TraceRecorder> waitRecorder(DebuggerModelService service, TargetObject target) {
        CompletableFuture<TraceRecorder> futureRecorder = this.listenForRecorder(service, target);
        TraceRecorder recorder = service.getRecorder(target);
        if (recorder != null) {
            futureRecorder.cancel(true);
            return CompletableFuture.completedFuture(recorder);
        }
        return futureRecorder;
    }

    protected TraceRecorder onTimedOutRecorder(TaskMonitor monitor, DebuggerModelService service, TargetObject target) {
        this.checkCancelled(monitor);
        monitor.setMessage("Timed out waiting for recording. Invoking the recorder.");
        TraceRecorder recorder = service.recordTargetPromptOffers(target);
        if (recorder == null) {
            throw new CancellationException("User cancelled at record dialog");
        }
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        if (traceManager != null) {
            Trace trace = recorder.getTrace();
            Swing.runLater(() -> {
                traceManager.openTrace(trace);
                traceManager.activate(traceManager.resolveTrace(trace), DebuggerTraceManagerService.ActivationCause.START_RECORDING);
            });
        }
        return recorder;
    }

    protected Void onTimedOutMapping(TaskMonitor monitor, DebuggerStaticMappingService mappingService, TraceRecorder recorder) {
        Collection<ModuleMapProposal.ModuleMapEntry> mapped;
        this.checkCancelled(monitor);
        monitor.setMessage("Timed out waiting for module map. Invoking the mapper.");
        try {
            mapped = this.invokeMapper(monitor, mappingService, recorder);
        }
        catch (CancelledException e) {
            throw new CancellationException(e.getMessage());
        }
        if (mapped.isEmpty()) {
            monitor.setMessage("Could not formulate a mapping with the target program. Continuing without one.");
            Msg.showWarn((Object)this, null, (String)("Launch " + this.program), (Object)("The resulting target process has no mapping to the static image " + this.program + ". Intervention is required before static and dynamic addresses can be translated. Check the target's module list."));
        }
        return null;
    }

    @Override
    public CompletableFuture<DebuggerProgramLaunchOffer.LaunchResult> launchProgram(TaskMonitor monitor, final DebuggerProgramLaunchOffer.PromptMode mode, DebuggerProgramLaunchOffer.LaunchConfigurator configurator) {
        DebuggerModelService service = (DebuggerModelService)this.tool.getService(DebuggerModelService.class);
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)this.tool.getService(DebuggerStaticMappingService.class);
        monitor.initialize(6L);
        monitor.setMessage("Connecting");
        var locals = new Object(){
            DebuggerObjectModel model;
            CompletableFuture<TargetObject> futureTarget;
            TargetObject target;
            TraceRecorder recorder;
            Throwable exception;
            boolean prompt;
            {
                this.prompt = mode == DebuggerProgramLaunchOffer.PromptMode.ALWAYS;
            }

            DebuggerProgramLaunchOffer.LaunchResult getResult() {
                return new DebuggerProgramLaunchOffer.LaunchResult(this.model, this.target, this.recorder, this.exception);
            }
        };
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.connect(service, locals.prompt, configurator).thenCompose(m -> {
            this.checkCancelled(monitor);
            locals.model = m;
            monitor.incrementProgress(1L);
            monitor.setMessage("Finding Launcher");
            return AsyncTimer.DEFAULT_TIMER.mark().timeOut(this.findLauncher((DebuggerObjectModel)m), this.getTimeoutMillis(), () -> this.onTimedOutFindLauncher(monitor));
        })).thenCompose(l -> {
            this.checkCancelled(monitor);
            monitor.incrementProgress(1L);
            monitor.setMessage("Launching");
            locals.futureTarget = this.listenForTarget(l.getModel());
            return AsyncUtils.loop((TypeSpec)TypeSpec.VOID, loop -> {
                ((CompletableFuture)this.launch((TargetLauncher)l, locals.prompt, configurator, monitor).thenAccept(arg_0 -> ((AsyncLoopHandlerForSecond)loop).exit(arg_0))).exceptionally(ex -> {
                    loop.repeat();
                    return null;
                });
                locals.prompt = mode != DebuggerProgramLaunchOffer.PromptMode.NEVER;
            });
        })).thenCompose(__ -> {
            this.checkCancelled(monitor);
            monitor.incrementProgress(1L);
            monitor.setMessage("Waiting for target");
            return AsyncTimer.DEFAULT_TIMER.mark().timeOut(locals.futureTarget, this.getTimeoutMillis(), () -> this.onTimedOutTarget(monitor));
        })).thenCompose(t -> {
            this.checkCancelled(monitor);
            locals.target = t;
            monitor.incrementProgress(1L);
            monitor.setMessage("Waiting for recorder");
            return AsyncTimer.DEFAULT_TIMER.mark().timeOut(this.waitRecorder(service, (TargetObject)t), this.getTimeoutMillis(), () -> this.onTimedOutRecorder(monitor, service, (TargetObject)t));
        })).thenCompose(r -> {
            this.checkCancelled(monitor);
            locals.recorder = r;
            monitor.incrementProgress(1L);
            if (r == null) {
                throw new CancellationException();
            }
            monitor.setMessage("Confirming program is mapped to target");
            return AsyncTimer.DEFAULT_TIMER.mark().timeOut(this.listenForMapping(mappingService, (TraceRecorder)r), this.getTimeoutMillis(), () -> this.onTimedOutMapping(monitor, mappingService, (TraceRecorder)r));
        })).exceptionally(ex -> {
            locals.exception = AsyncUtils.unwrapThrowable((Throwable)ex);
            return null;
        })).thenApply(__ -> {
            if (locals.exception != null) {
                monitor.setMessage("Launch error: " + locals.exception);
                return locals.getResult();
            }
            monitor.setMessage("Launch successful");
            monitor.incrementProgress(1L);
            return locals.getResult();
        });
    }

    static class ValueExpecter
    extends CompletableFuture<Object>
    implements DebuggerModelListener {
        private final DebuggerObjectModel model;
        private final List<String> path;

        public ValueExpecter(DebuggerObjectModel model, List<String> path) {
            this.model = model;
            this.path = path;
            model.addModelListener((DebuggerModelListener)this);
            this.retryFetch();
        }

        protected void retryFetch() {
            ((CompletableFuture)this.model.fetchModelValue(this.path).thenAccept((T v) -> {
                if (v != null) {
                    this.model.removeModelListener((DebuggerModelListener)this);
                    this.complete(v);
                }
            })).exceptionally((T ex) -> {
                this.model.removeModelListener((DebuggerModelListener)this);
                this.completeExceptionally((Throwable)ex);
                return null;
            });
        }

        public void rootAdded(TargetObject root) {
            this.retryFetch();
        }

        public void attributesChanged(TargetObject object, Collection<String> removed, Map<String, ?> added) {
            this.retryFetch();
        }

        public void elementsChanged(TargetObject object, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            this.retryFetch();
        }
    }
}

