/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class StackUnwindWarningSet
implements Collection<StackUnwindWarning> {
    private final Collection<StackUnwindWarning> warnings = new LinkedHashSet<StackUnwindWarning>();

    public static StackUnwindWarningSet custom(String message) {
        StackUnwindWarningSet set = new StackUnwindWarningSet();
        set.add(new StackUnwindWarning.CustomStackUnwindWarning(message));
        return set;
    }

    public StackUnwindWarningSet() {
    }

    public StackUnwindWarningSet(StackUnwindWarning ... warnings) {
        this.warnings.addAll(Arrays.asList(warnings));
    }

    public StackUnwindWarningSet(Collection<StackUnwindWarning> warnings) {
        this.warnings.addAll(warnings);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackUnwindWarningSet)) {
            return false;
        }
        StackUnwindWarningSet that = (StackUnwindWarningSet)obj;
        return this.warnings.equals(that.warnings);
    }

    @Override
    public int size() {
        return this.warnings.size();
    }

    @Override
    public boolean isEmpty() {
        return this.warnings.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.warnings.contains(o);
    }

    @Override
    public Iterator<StackUnwindWarning> iterator() {
        return this.warnings.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.warnings.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.warnings.toArray(a);
    }

    @Override
    public boolean add(StackUnwindWarning e) {
        return this.warnings.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.warnings.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.warnings.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends StackUnwindWarning> c) {
        return this.warnings.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.warnings.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.warnings.retainAll(c);
    }

    @Override
    public void clear() {
        this.warnings.clear();
    }

    public List<String> summarize() {
        LinkedHashSet combined = new LinkedHashSet();
        ArrayList<String> lines = new ArrayList<String>();
        for (StackUnwindWarning w : this.warnings) {
            if (this.warnings.stream().anyMatch(mw -> mw.moots(w))) continue;
            if (w instanceof StackUnwindWarning.Combinable) {
                StackUnwindWarning.Combinable c = (StackUnwindWarning.Combinable)((Object)w);
                Class<?> cls = w.getClass();
                if (!combined.add(cls)) continue;
                Collection all = this.warnings.stream().filter(cw -> cls.isInstance(cw)).collect(Collectors.toList());
                if (all.size() == 1) {
                    lines.add(w.getMessage());
                    continue;
                }
                lines.add(c.summarize(all));
                continue;
            }
            lines.add(w.getMessage());
        }
        return lines;
    }

    public void reportDetails() {
        for (StackUnwindWarning w : this.warnings) {
            w.reportDetails();
        }
    }
}

