/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import ghidra.app.plugin.core.debug.stack.Sym;
import ghidra.app.plugin.core.debug.stack.SymPcodeArithmetic;
import ghidra.app.plugin.core.debug.stack.SymStateSpace;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SymPcodeExecutorState
implements PcodeExecutorState<Sym> {
    private final Program program;
    private final CompilerSpec cSpec;
    private final Language language;
    private final SymPcodeArithmetic arithmetic;
    private final SymStateSpace stackSpace;
    private final SymStateSpace registerSpace;
    private final SymStateSpace uniqueSpace;
    final Set<StackUnwindWarning> warnings = new LinkedHashSet<StackUnwindWarning>();

    public SymPcodeExecutorState(Program program) {
        this.program = program;
        this.cSpec = program.getCompilerSpec();
        this.language = this.cSpec.getLanguage();
        this.arithmetic = new SymPcodeArithmetic(this.cSpec);
        this.stackSpace = new SymStateSpace();
        this.registerSpace = new SymStateSpace();
        this.uniqueSpace = new SymStateSpace();
    }

    protected SymPcodeExecutorState(Program program, SymPcodeArithmetic arithmetic, SymStateSpace stackSpace, SymStateSpace registerSpace, SymStateSpace uniqueSpace) {
        this.program = program;
        this.cSpec = program.getCompilerSpec();
        this.language = this.cSpec.getLanguage();
        this.arithmetic = new SymPcodeArithmetic(this.cSpec);
        this.stackSpace = stackSpace;
        this.registerSpace = registerSpace;
        this.uniqueSpace = uniqueSpace;
    }

    public String toString() {
        return String.format("%s[\n    cSpec=%s\n    stack=%s\n    registers=%s\n    unique=%s\n]\n", this.getClass().getSimpleName(), this.cSpec.toString(), this.stackSpace.toString("    ", this.language), this.registerSpace.toString("    ", this.language), this.uniqueSpace.toString("    ", this.language));
    }

    public Language getLanguage() {
        return this.language;
    }

    public PcodeArithmetic<Sym> getArithmetic() {
        return this.arithmetic;
    }

    public void setVar(AddressSpace space, Sym offset, int size, boolean quantize, Sym val) {
        Address address = offset.addressIn(space, this.cSpec);
        if (address.isRegisterAddress()) {
            this.registerSpace.set(address, size, val);
        } else if (address.isUniqueAddress()) {
            this.uniqueSpace.set(address, size, val);
        } else {
            if (address.isConstantAddress()) {
                throw new IllegalArgumentException();
            }
            if (address.isStackAddress()) {
                this.stackSpace.set(address, size, val);
            } else {
                Msg.trace((Object)this, (Object)("Ignoring set: space=" + space + ",offset=" + offset + ",size=" + size + ",val=" + val));
            }
        }
    }

    public Sym getVar(AddressSpace space, Sym offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        Address address = offset.addressIn(space, this.cSpec);
        if (address.isRegisterAddress()) {
            return this.registerSpace.get(address, size, this.arithmetic, this.language);
        }
        if (address.isUniqueAddress()) {
            return this.uniqueSpace.get(address, size, this.arithmetic, this.language);
        }
        if (address.isConstantAddress()) {
            return offset;
        }
        if (address.isStackAddress()) {
            return this.stackSpace.get(address, size, this.arithmetic, this.language);
        }
        return Sym.opaque();
    }

    public Map<Register, Sym> getRegisterValues() {
        return Map.of();
    }

    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return new MemoryBufferImpl(this.program.getMemory(), address);
    }

    public void clear() {
        this.registerSpace.clear();
        this.stackSpace.clear();
    }

    public SymPcodeExecutorState fork() {
        return new SymPcodeExecutorState(this.program, this.arithmetic, this.stackSpace.fork(), this.registerSpace.fork(), this.uniqueSpace.fork());
    }

    public SymPcodeExecutorState forkRegs() {
        return new SymPcodeExecutorState(this.program, this.arithmetic, new SymStateSpace(), this.registerSpace.fork(), new SymStateSpace());
    }

    public void dump() {
        System.err.println("Registers: ");
        this.registerSpace.dump("  ", this.language);
        System.err.println("Unique: ");
        this.uniqueSpace.dump("  ", this.language);
        System.err.println("Stack: ");
        this.stackSpace.dump("  ", this.language);
    }

    public Long computeStackDepth() {
        Sym.RegisterSym regVar;
        Register sp = this.cSpec.getStackPointer();
        Sym expr = (Sym)this.getVar(sp, PcodeExecutorStatePiece.Reason.INSPECT);
        if (expr instanceof Sym.RegisterSym && (regVar = (Sym.RegisterSym)expr).register() == sp) {
            return 0L;
        }
        if (expr instanceof Sym.StackOffsetSym) {
            Sym.StackOffsetSym stackOff = (Sym.StackOffsetSym)expr;
            return stackOff.offset();
        }
        return null;
    }

    public Address computeAddressOfReturn() {
        Sym expr = (Sym)this.getVar(this.language.getProgramCounter(), PcodeExecutorStatePiece.Reason.INSPECT);
        if (expr instanceof Sym.StackDerefSym) {
            Sym.StackDerefSym stackVar = (Sym.StackDerefSym)expr;
            return this.cSpec.getStackSpace().getAddress(stackVar.offset());
        }
        if (expr instanceof Sym.RegisterSym) {
            Sym.RegisterSym regVar = (Sym.RegisterSym)expr;
            return regVar.register().getAddress();
        }
        return null;
    }

    public Map<Register, Address> computeMapUsingStack() {
        HashMap<Register, Address> result = new HashMap<Register, Address>();
        for (SymStateSpace.SymEntry ent : this.stackSpace.map.values()) {
            Sym sym;
            if (ent.isTruncated() || !((sym = ent.sym()) instanceof Sym.RegisterSym)) continue;
            Sym.RegisterSym regVar = (Sym.RegisterSym)sym;
            result.put(regVar.register(), ent.entRange().getMinAddress());
        }
        return result;
    }

    public Map<Register, Address> computeMapUsingRegisters() {
        HashMap<Register, Address> result = new HashMap<Register, Address>();
        for (SymStateSpace.SymEntry ent : this.registerSpace.map.values()) {
            Sym sym;
            if (ent.isTruncated() || !((sym = ent.sym()) instanceof Sym.StackDerefSym)) continue;
            Sym.StackDerefSym stackVar = (Sym.StackDerefSym)sym;
            Register register = ent.getRegister(this.language);
            if (register == null) continue;
            result.put(register, this.cSpec.getStackSpace().getAddress(stackVar.offset()));
        }
        return result;
    }
}

