/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.app.plugin.core.debug.service.emulation.DebuggerEmulationServicePlugin;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerPcodeEmulatorFactory;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerPcodeMachine;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.time.schedule.Scheduler;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@ServiceInfo(defaultProvider={DebuggerEmulationServicePlugin.class})
public interface DebuggerEmulationService {
    public Collection<DebuggerPcodeEmulatorFactory> getEmulatorFactories();

    public void setEmulatorFactory(DebuggerPcodeEmulatorFactory var1);

    public DebuggerPcodeEmulatorFactory getEmulatorFactory();

    public long emulate(TracePlatform var1, TraceSchedule var2, TaskMonitor var3) throws CancelledException;

    default public long emulate(Trace trace, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        return this.emulate(trace.getPlatformManager().getHostPlatform(), time, monitor);
    }

    public EmulationResult run(TracePlatform var1, TraceSchedule var2, TaskMonitor var3, Scheduler var4) throws CancelledException;

    public CompletableFuture<Long> backgroundEmulate(TracePlatform var1, TraceSchedule var2);

    public CompletableFuture<EmulationResult> backgroundRun(TracePlatform var1, TraceSchedule var2, Scheduler var3);

    public DebuggerPcodeMachine<?> getCachedEmulator(Trace var1, TraceSchedule var2);

    public Collection<CachedEmulator> getBusyEmulators();

    public void addStateListener(EmulatorStateListener var1);

    public void removeStateListener(EmulatorStateListener var1);

    public static interface EmulatorStateListener {
        public void running(CachedEmulator var1);

        public void stopped(CachedEmulator var1);
    }

    public record CachedEmulator(Trace trace, DebuggerPcodeMachine<?> emulator, long version) {
        public CachedEmulator(Trace trace, DebuggerPcodeMachine<?> emulator) {
            this(trace, emulator, trace.getEmulatorCacheVersion());
        }

        public boolean isValid() {
            return this.version >= this.trace.getEmulatorCacheVersion();
        }
    }

    public record RecordEmulationResult(TraceSchedule schedule, long snapshot, Throwable error) implements EmulationResult
    {
    }

    public static interface EmulationResult
    extends Scheduler.RunResult {
        public long snapshot();
    }
}

